/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launcher.gui.service;

import java.io.EOFException;
import java.io.InputStream;
import java.net.InetSocketAddress;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import pro.gravit.launcher.base.Launcher;
import pro.gravit.launcher.base.profiles.ClientProfile;
import pro.gravit.launcher.base.profiles.ClientProfileBuilder;
import pro.gravit.launcher.base.profiles.ClientProfileVersions;
import pro.gravit.launcher.base.profiles.optional.OptionalView;
import pro.gravit.launcher.base.request.auth.SetProfileRequest;
import pro.gravit.launcher.core.hasher.HashedDir;
import pro.gravit.launcher.gui.JavaFXApplication;
import pro.gravit.launcher.gui.config.RuntimeSettings;
import pro.gravit.launcher.gui.impl.AbstractStage;
import pro.gravit.launcher.gui.impl.ContextHelper;
import pro.gravit.launcher.runtime.client.ClientLauncherProcess;
import pro.gravit.launcher.runtime.client.DirBridge;
import pro.gravit.utils.helper.CommonHelper;
import pro.gravit.utils.helper.IOHelper;
import pro.gravit.utils.helper.JVMHelper;
import pro.gravit.utils.helper.JavaHelper;
import pro.gravit.utils.helper.LogHelper;

public class LaunchService {
    private final JavaFXApplication application;

    public LaunchService(JavaFXApplication javaFXApplication) {
        this.application = javaFXApplication;
    }

    public boolean isTestUpdate(ClientProfile clientProfile, RuntimeSettings.ProfileSettings profileSettings) {
        return this.application.offlineService.isOfflineMode() || this.application.authService.checkDebugPermission("skipupdate") && profileSettings.debugSkipUpdate;
    }

    private void downloadClients(CompletableFuture<ClientInstance> completableFuture, ClientProfile clientProfile, RuntimeSettings.ProfileSettings profileSettings, JavaHelper.JavaVersion javaVersion, HashedDir hashedDir) {
        Path path = DirBridge.dirUpdates.resolve(clientProfile.getAssetDir());
        LogHelper.info("Start update to %s", path.toString());
        boolean bl = this.isTestUpdate(clientProfile, profileSettings);
        Consumer<HashedDir> consumer = hashedDir2 -> {
            Path path2 = DirBridge.dirUpdates.resolve(clientProfile.getDir());
            LogHelper.info("Start update to %s", path2.toString());
            this.application.gui.updateScene.sendUpdateRequest(clientProfile.getDir(), path2, clientProfile.getClientUpdateMatcher(), true, this.application.profilesService.getOptionalView(), true, bl, hashedDir3 -> {
                LogHelper.info("Success update");
                try {
                    ClientInstance clientInstance = this.doLaunchClient(path, (HashedDir)hashedDir2, path2, (HashedDir)hashedDir3, clientProfile, this.application.profilesService.getOptionalView(), javaVersion, hashedDir);
                    completableFuture.complete(clientInstance);
                }
                catch (Throwable throwable) {
                    completableFuture.completeExceptionally(throwable);
                }
            });
        };
        if (clientProfile.getVersion().compareTo(ClientProfileVersions.MINECRAFT_1_6_4) <= 0) {
            this.application.gui.updateScene.sendUpdateRequest(clientProfile.getAssetDir(), path, clientProfile.getAssetUpdateMatcher(), true, null, false, bl, consumer);
        } else {
            this.application.gui.updateScene.sendUpdateAssetRequest(clientProfile.getAssetDir(), path, clientProfile.getAssetUpdateMatcher(), true, clientProfile.getAssetIndex(), bl, consumer);
        }
    }

    private ClientInstance doLaunchClient(Path path, HashedDir hashedDir, Path path2, HashedDir hashedDir2, ClientProfile clientProfile, OptionalView optionalView, JavaHelper.JavaVersion javaVersion, HashedDir hashedDir3) {
        Object object;
        RuntimeSettings.ProfileSettings profileSettings = this.application.getProfileSettings();
        if (javaVersion == null) {
            javaVersion = this.application.javaService.getRecommendJavaVersion(clientProfile);
        }
        if (javaVersion == null) {
            javaVersion = JavaHelper.JavaVersion.getCurrentJavaVersion();
        }
        if (this.application.authService.checkDebugPermission("skipfilemonitor") && profileSettings.debugSkipFileMonitor) {
            object = new ClientProfileBuilder(clientProfile);
            ((ClientProfileBuilder)object).setUpdate(new ArrayList<String>());
            ((ClientProfileBuilder)object).setUpdateVerify(new ArrayList<String>());
            ((ClientProfileBuilder)object).setUpdateExclusions(new ArrayList<String>());
            clientProfile = ((ClientProfileBuilder)object).createClientProfile();
        }
        object = new ClientLauncherProcess(path2, path, javaVersion, path2.resolve("resourcepacks"), clientProfile, this.application.authService.getPlayerProfile(), optionalView, this.application.authService.getAccessToken(), hashedDir2, hashedDir, hashedDir3);
        ((ClientLauncherProcess)object).params.ram = profileSettings.ram;
        ((ClientLauncherProcess)object).params.offlineMode = this.application.offlineService.isOfflineMode();
        if (((ClientLauncherProcess)object).params.ram > 0) {
            ((ClientLauncherProcess)object).jvmArgs.add("-Xms" + ((ClientLauncherProcess)object).params.ram + "M");
            ((ClientLauncherProcess)object).jvmArgs.add("-Xmx" + ((ClientLauncherProcess)object).params.ram + "M");
        }
        ((ClientLauncherProcess)object).params.fullScreen = profileSettings.fullScreen;
        ((ClientLauncherProcess)object).params.autoEnter = profileSettings.autoEnter;
        if (JVMHelper.OS_TYPE == JVMHelper.OS.LINUX) {
            ((ClientLauncherProcess)object).params.lwjglGlfwWayland = profileSettings.waylandSupport;
        }
        return new ClientInstance((ClientLauncherProcess)object, clientProfile, profileSettings);
    }

    private String getJavaDirName(Path path) {
        String string = DirBridge.dirUpdates.toAbsolutePath().toString();
        if (path == null || !path.startsWith(string)) {
            return null;
        }
        Path path2 = DirBridge.dirUpdates.relativize(path);
        return path2.toString();
    }

    private void showJavaAlert(ClientProfile clientProfile) {
        if ((JVMHelper.ARCH_TYPE == JVMHelper.ARCH.ARM32 || JVMHelper.ARCH_TYPE == JVMHelper.ARCH.ARM64) && clientProfile.getVersion().compareTo(ClientProfileVersions.MINECRAFT_1_12_2) <= 0) {
            this.application.messageManager.showDialog(this.application.getTranslation("runtime.scenes.serverinfo.javaalert.lwjgl2.header"), this.application.getTranslation("runtime.scenes.serverinfo.javaalert.lwjgl2.description").formatted(clientProfile.getRecommendJavaVersion()), () -> {}, () -> {}, true);
        } else {
            this.application.messageManager.showDialog(this.application.getTranslation("runtime.scenes.serverinfo.javaalert.header"), this.application.getTranslation("runtime.scenes.serverinfo.javaalert.description").formatted(clientProfile.getRecommendJavaVersion()), () -> {}, () -> {}, true);
        }
    }

    public CompletableFuture<ClientInstance> launchClient() {
        return this.launchClient(this.application.getMainStage());
    }

    private CompletableFuture<ClientInstance> launchClient(AbstractStage abstractStage) {
        ClientProfile clientProfile = this.application.profilesService.getProfile();
        if (clientProfile == null) {
            throw new NullPointerException("profilesService.getProfile() is null");
        }
        CompletableFuture<ClientInstance> completableFuture = new CompletableFuture<ClientInstance>();
        this.application.gui.processingOverlay.processRequest(abstractStage, this.application.getTranslation("runtime.overlay.processing.text.setprofile"), new SetProfileRequest(clientProfile), setProfileRequestEvent -> ContextHelper.runInFxThreadStatic(() -> {
            RuntimeSettings.ProfileSettings profileSettings = this.application.getProfileSettings();
            JavaHelper.JavaVersion javaVersion = null;
            for (JavaHelper.JavaVersion javaVersion2 : this.application.javaService.javaVersions) {
                if (!javaVersion2.jvmDir.toAbsolutePath().toString().equals(profileSettings.javaPath)) continue;
                javaVersion = javaVersion2;
            }
            if (javaVersion == null && profileSettings.javaPath != null && !this.application.guiModuleConfig.forceDownloadJava) {
                try {
                    javaVersion = JavaHelper.JavaVersion.getByPath(Paths.get(profileSettings.javaPath, new String[0]));
                }
                catch (Throwable throwable) {
                    if (LogHelper.isDevEnabled()) {
                        LogHelper.error(throwable);
                    }
                    LogHelper.warning("Incorrect java path %s", profileSettings.javaPath);
                }
            }
            if (javaVersion == null || this.application.javaService.isIncompatibleJava(javaVersion, clientProfile)) {
                javaVersion = this.application.javaService.getRecommendJavaVersion(clientProfile);
            }
            if (javaVersion == null) {
                this.showJavaAlert(clientProfile);
                return;
            }
            String string = this.getJavaDirName(javaVersion.jvmDir);
            if (string != null) {
                JavaHelper.JavaVersion javaVersion2;
                javaVersion2 = javaVersion;
                try {
                    abstractStage.setScene(this.application.gui.updateScene, true);
                    this.application.gui.updateScene.reset();
                }
                catch (Exception exception) {
                    completableFuture.completeExceptionally(exception);
                }
                this.application.gui.updateScene.sendUpdateRequest(string, javaVersion.jvmDir, null, true, this.application.profilesService.getOptionalView(), false, this.isTestUpdate(clientProfile, profileSettings), hashedDir -> {
                    Path path;
                    if ((JVMHelper.OS_TYPE == JVMHelper.OS.LINUX || JVMHelper.OS_TYPE == JVMHelper.OS.MACOSX) && Files.exists(path = javaVersion.jvmDir.resolve("bin").resolve("java"), new LinkOption[0]) && !path.toFile().setExecutable(true)) {
                        LogHelper.warning("Set permission for %s unsuccessful", path.toString());
                    }
                    this.downloadClients(completableFuture, clientProfile, profileSettings, javaVersion2, (HashedDir)hashedDir);
                });
            } else {
                try {
                    abstractStage.setScene(this.application.gui.updateScene, true);
                    this.application.gui.updateScene.reset();
                }
                catch (Exception exception) {
                    completableFuture.completeExceptionally(exception);
                }
                this.downloadClients(completableFuture, clientProfile, profileSettings, javaVersion, null);
            }
        }), completableFuture::completeExceptionally, null);
        return completableFuture;
    }

    public class ClientInstance {
        private final ClientLauncherProcess process;
        private final ClientProfile clientProfile;
        private final RuntimeSettings.ProfileSettings settings;
        private final Thread writeParamsThread;
        private Thread runThread;
        private final CompletableFuture<Void> onWriteParams = new CompletableFuture();
        private final CompletableFuture<Integer> runFuture = new CompletableFuture();
        private final Set<ProcessListener> listeners = ConcurrentHashMap.newKeySet();

        public ClientInstance(ClientLauncherProcess clientLauncherProcess, ClientProfile clientProfile, RuntimeSettings.ProfileSettings profileSettings) {
            this.process = clientLauncherProcess;
            this.clientProfile = clientProfile;
            this.settings = profileSettings;
            this.writeParamsThread = CommonHelper.newThread("Client Params Writer Thread", true, () -> {
                try {
                    clientLauncherProcess.runWriteParams(new InetSocketAddress("127.0.0.1", Launcher.getConfig().clientPort));
                    this.onWriteParams.complete(null);
                }
                catch (Throwable throwable) {
                    LogHelper.error(throwable);
                    this.onWriteParams.completeExceptionally(throwable);
                }
            });
        }

        private void run() {
            try {
                this.process.start(true);
                Process process = this.process.getProcess();
                InputStream inputStream = process.getInputStream();
                byte[] byArray = IOHelper.newBuffer();
                try {
                    int n = inputStream.read(byArray);
                    while (n >= 0) {
                        this.handleListeners(byArray, 0, n);
                        n = inputStream.read(byArray);
                    }
                }
                catch (EOFException eOFException) {
                    // empty catch block
                }
                if (process.isAlive()) {
                    process.waitFor();
                }
                if (this.writeParamsThread != null && this.writeParamsThread.isAlive()) {
                    this.writeParamsThread.interrupt();
                }
                this.runFuture.complete(process.exitValue());
            }
            catch (Throwable throwable) {
                if (this.writeParamsThread != null && this.writeParamsThread.isAlive()) {
                    this.writeParamsThread.interrupt();
                }
                this.runFuture.completeExceptionally(throwable);
            }
        }

        public void kill() {
            this.process.getProcess().destroyForcibly();
        }

        private void handleListeners(byte[] byArray, int n, int n2) {
            for (ProcessListener processListener : this.listeners) {
                processListener.onNext(byArray, n, n2);
            }
        }

        public synchronized CompletableFuture<Integer> start() {
            if (this.runThread == null) {
                this.runThread = CommonHelper.newThread("Run Thread", true, this::run);
                this.writeParamsThread.start();
                this.runThread.start();
            }
            return this.runFuture;
        }

        public ClientLauncherProcess getProcess() {
            return this.process;
        }

        public ClientProfile getClientProfile() {
            return this.clientProfile;
        }

        public RuntimeSettings.ProfileSettings getSettings() {
            return this.settings;
        }

        public CompletableFuture<Void> getOnWriteParamsFuture() {
            return this.onWriteParams;
        }

        public void registerListener(ProcessListener processListener) {
            this.listeners.add(processListener);
        }

        public void unregisterListener(ProcessListener processListener) {
            this.listeners.remove(processListener);
        }

        @FunctionalInterface
        public static interface ProcessListener {
            public void onNext(byte[] var1, int var2, int var3);
        }
    }
}

