/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launcher.gui.service;

import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import pro.gravit.launcher.base.ClientPermissions;
import pro.gravit.launcher.base.events.request.AuthRequestEvent;
import pro.gravit.launcher.base.events.request.ProfilesRequestEvent;
import pro.gravit.launcher.base.profiles.ClientProfile;
import pro.gravit.launcher.base.profiles.PlayerProfile;
import pro.gravit.launcher.base.profiles.Texture;
import pro.gravit.launcher.base.request.Request;
import pro.gravit.launcher.base.request.auth.AuthRequest;
import pro.gravit.launcher.base.request.auth.password.AuthOAuthPassword;
import pro.gravit.launcher.base.request.update.ProfilesRequest;
import pro.gravit.launcher.base.request.websockets.OfflineRequestService;
import pro.gravit.launcher.gui.JavaFXApplication;
import pro.gravit.launcher.runtime.client.DirBridge;
import pro.gravit.utils.helper.SecurityHelper;

public class OfflineService {
    private final JavaFXApplication application;

    public OfflineService(JavaFXApplication javaFXApplication) {
        this.application = javaFXApplication;
    }

    public boolean isAvailableOfflineMode() {
        if (this.application.guiModuleConfig.disableOfflineMode) {
            return false;
        }
        return this.application.runtimeSettings.profiles != null;
    }

    public boolean isOfflineMode() {
        return Request.getRequestService() instanceof OfflineRequestService;
    }

    public static void applyRuntimeProcessors(OfflineRequestService offlineRequestService) {
        offlineRequestService.registerRequestProcessor(AuthRequest.class, authRequest -> {
            AuthRequest.AuthPasswordInterface authPasswordInterface;
            ClientPermissions clientPermissions = new ClientPermissions();
            String string = authRequest.login;
            if (string == null && (authPasswordInterface = authRequest.password) instanceof AuthOAuthPassword) {
                AuthOAuthPassword authOAuthPassword = (AuthOAuthPassword)authPasswordInterface;
                string = authOAuthPassword.accessToken;
            }
            if (string == null) {
                string = "Player";
            }
            return new AuthRequestEvent(clientPermissions, new PlayerProfile(UUID.nameUUIDFromBytes(string.getBytes(StandardCharsets.UTF_8)), string, new HashMap<String, Texture>(), new HashMap<String, String>()), SecurityHelper.randomStringToken(), "", null, new AuthRequestEvent.OAuthRequestEvent(string, null, 0L));
        });
        offlineRequestService.registerRequestProcessor(ProfilesRequest.class, profilesRequest -> {
            JavaFXApplication javaFXApplication = JavaFXApplication.getInstance();
            List<ClientProfile> list = javaFXApplication.runtimeSettings.profiles.stream().filter(clientProfile -> Files.exists(DirBridge.dirUpdates.resolve(clientProfile.getDir()), new LinkOption[0]) && Files.exists(DirBridge.dirUpdates.resolve(clientProfile.getAssetDir()), new LinkOption[0])).collect(Collectors.toList());
            return new ProfilesRequestEvent(list);
        });
    }
}

