/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launcher.gui.service;

import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import pro.gravit.launcher.runtime.client.ServerPinger;

public class PingService {
    private final Map<String, CompletableFuture<PingServerReport>> reports = new ConcurrentHashMap<String, CompletableFuture<PingServerReport>>();

    public CompletableFuture<PingServerReport> getPingReport(String string2) {
        CompletableFuture completableFuture = this.reports.computeIfAbsent(string2, string -> new CompletableFuture());
        return completableFuture;
    }

    public void addReports(Map<String, PingServerReport> map) {
        map.forEach((string, pingServerReport) -> {
            CompletableFuture<PingServerReport> completableFuture = this.getPingReport((String)string);
            completableFuture.complete((PingServerReport)pingServerReport);
        });
    }

    public void addReport(String string, ServerPinger.Result result) {
        CompletableFuture<PingServerReport> completableFuture = this.getPingReport(string);
        PingServerReport pingServerReport = new PingServerReport(string, result.maxPlayers, result.onlinePlayers);
        completableFuture.complete(pingServerReport);
    }

    public void clear() {
        this.reports.forEach((string, completableFuture) -> {
            if (!completableFuture.isDone()) {
                completableFuture.completeExceptionally(new InterruptedException());
            }
        });
        this.reports.clear();
    }

    public static class PingServerReport {
        public final String name;
        public final int maxPlayers;
        public final int playersOnline;

        public PingServerReport(String string, int n, int n2) {
            this.name = string;
            this.maxPlayers = n;
            this.playersOnline = n2;
        }
    }
}

