/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launcher.runtime;

import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.KeyPair;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.security.interfaces.ECPrivateKey;
import java.security.interfaces.ECPublicKey;
import java.security.spec.InvalidKeySpecException;
import java.util.Arrays;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import pro.gravit.launcher.base.Launcher;
import pro.gravit.launcher.base.LauncherConfig;
import pro.gravit.launcher.base.modules.events.OfflineModeEvent;
import pro.gravit.launcher.base.modules.events.PreConfigPhase;
import pro.gravit.launcher.base.profiles.optional.actions.OptionalAction;
import pro.gravit.launcher.base.profiles.optional.triggers.OptionalTrigger;
import pro.gravit.launcher.base.request.Request;
import pro.gravit.launcher.base.request.RequestException;
import pro.gravit.launcher.base.request.RequestService;
import pro.gravit.launcher.base.request.auth.AuthRequest;
import pro.gravit.launcher.base.request.auth.GetAvailabilityAuthRequest;
import pro.gravit.launcher.base.request.websockets.OfflineRequestService;
import pro.gravit.launcher.base.request.websockets.StdWebSocketService;
import pro.gravit.launcher.client.BasicLauncherEventHandler;
import pro.gravit.launcher.client.ClientLauncherEntryPoint;
import pro.gravit.launcher.client.ClientLauncherMethods;
import pro.gravit.launcher.client.ClientParams;
import pro.gravit.launcher.client.RuntimeLauncherCoreModule;
import pro.gravit.launcher.client.events.ClientExitPhase;
import pro.gravit.launcher.client.utils.NativeJVMHalt;
import pro.gravit.launcher.core.LauncherTrustManager;
import pro.gravit.launcher.runtime.LauncherEngineWrapper;
import pro.gravit.launcher.runtime.client.DirBridge;
import pro.gravit.launcher.runtime.client.RuntimeGsonManager;
import pro.gravit.launcher.runtime.client.events.ClientEngineInitPhase;
import pro.gravit.launcher.runtime.client.events.ClientPreGuiPhase;
import pro.gravit.launcher.runtime.console.GetPublicKeyCommand;
import pro.gravit.launcher.runtime.console.ModulesCommand;
import pro.gravit.launcher.runtime.console.SignDataCommand;
import pro.gravit.launcher.runtime.gui.NoRuntimeProvider;
import pro.gravit.launcher.runtime.gui.RuntimeProvider;
import pro.gravit.launcher.runtime.managers.ConsoleManager;
import pro.gravit.launcher.start.RuntimeModuleManager;
import pro.gravit.utils.helper.EnvHelper;
import pro.gravit.utils.helper.IOHelper;
import pro.gravit.utils.helper.JVMHelper;
import pro.gravit.utils.helper.LogHelper;
import pro.gravit.utils.helper.SecurityHelper;

public class LauncherEngine {
    public static ClientParams clientParams;
    public static RuntimeModuleManager modulesManager;
    public final boolean clientInstance;
    private final AtomicBoolean started = new AtomicBoolean(false);
    public RuntimeProvider runtimeProvider;
    public ECPublicKey publicKey;
    public ECPrivateKey privateKey;
    public Class<? extends RuntimeProvider> basicRuntimeProvider;

    private LauncherEngine(boolean bl, Class<? extends RuntimeProvider> clazz) {
        this.clientInstance = bl;
        this.basicRuntimeProvider = clazz;
    }

    public static X509Certificate[] getCertificates(Class<?> clazz) {
        Object[] objectArray = clazz.getSigners();
        if (objectArray == null) {
            return null;
        }
        return (X509Certificate[])Arrays.stream(objectArray).filter(object -> object instanceof X509Certificate).map(object -> (X509Certificate)object).toArray(X509Certificate[]::new);
    }

    public static void checkClass(Class<?> clazz) throws SecurityException {
        LauncherTrustManager launcherTrustManager = Launcher.getConfig().trustManager;
        if (launcherTrustManager == null) {
            return;
        }
        X509Certificate[] x509CertificateArray = LauncherEngine.getCertificates(clazz);
        if (x509CertificateArray == null) {
            throw new SecurityException(String.format("Class %s not signed", clazz.getName()));
        }
        try {
            launcherTrustManager.checkCertificatesSuccess(x509CertificateArray, launcherTrustManager::stdCertificateChecker);
        }
        catch (Exception exception) {
            throw new SecurityException(exception);
        }
    }

    public static void beforeExit(int n) {
        try {
            modulesManager.invokeEvent(new ClientExitPhase(n));
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static void forceExit(int n) {
        try {
            System.exit(n);
        }
        catch (Throwable throwable) {
            NativeJVMHalt.haltA(n);
        }
    }

    public static void exitLauncher(int n) {
        LauncherEngine.beforeExit(n);
        LauncherEngine.forceExit(n);
    }

    public static boolean contains(String[] stringArray, String string) {
        for (String string2 : stringArray) {
            if (!string2.equals(string)) continue;
            return true;
        }
        return false;
    }

    public static void main(String ... stringArray) throws Throwable {
        JVMHelper.checkStackTrace(LauncherEngineWrapper.class);
        JVMHelper.verifySystemProperties(Launcher.class, false);
        LauncherEngine.checkClass(LauncherEngine.class.getClassLoader().getClass());
        EnvHelper.checkDangerousParams();
        LauncherEngine.verifyNoAgent();
        if (LauncherEngine.contains(stringArray, "--log-output") && Launcher.getConfig().environment != LauncherConfig.LauncherEnvironment.PROD) {
            LogHelper.addOutput(Paths.get("Launcher.log", new String[0]));
        }
        LogHelper.printVersion("Launcher");
        LogHelper.printLicense("Launcher");
        LauncherEngine.checkClass(LauncherEngineWrapper.class);
        LauncherEngine.checkClass(LauncherEngine.class);
        LauncherEngine.checkClass(ClientLauncherEntryPoint.class);
        modulesManager = new RuntimeModuleManager();
        modulesManager.loadModule(new RuntimeLauncherCoreModule());
        LauncherConfig.initModules(modulesManager);
        modulesManager.initModules(null);
        LauncherEngine.initGson(modulesManager);
        ConsoleManager.initConsole();
        modulesManager.invokeEvent(new PreConfigPhase());
        Launcher.getConfig();
        long l = System.currentTimeMillis();
        try {
            LauncherEngine.newInstance(false).start(stringArray);
        }
        catch (Exception exception) {
            LogHelper.error(exception);
            return;
        }
        long l2 = System.currentTimeMillis();
        LogHelper.debug("Launcher started in %dms", l2 - l);
        LauncherEngine.exitLauncher(0);
    }

    public static void initGson(RuntimeModuleManager runtimeModuleManager) {
        AuthRequest.registerProviders();
        GetAvailabilityAuthRequest.registerProviders();
        OptionalAction.registerProviders();
        OptionalTrigger.registerProviders();
        Launcher.gsonManager = new RuntimeGsonManager(runtimeModuleManager);
        Launcher.gsonManager.initGson();
    }

    public static void verifyNoAgent() {
        if (JVMHelper.RUNTIME_MXBEAN.getInputArguments().stream().filter(string -> string != null && !string.isEmpty()).anyMatch(string -> string.contains("javaagent"))) {
            throw new SecurityException("JavaAgent found");
        }
    }

    public static RequestService initOffline() {
        OfflineRequestService offlineRequestService = new OfflineRequestService();
        ClientLauncherMethods.applyBasicOfflineProcessors(offlineRequestService);
        OfflineModeEvent offlineModeEvent = new OfflineModeEvent(offlineRequestService);
        modulesManager.invokeEvent(offlineModeEvent);
        return offlineModeEvent.service;
    }

    public static LauncherEngine newInstance(boolean bl) {
        return new LauncherEngine(bl, NoRuntimeProvider.class);
    }

    public static LauncherEngine newInstance(boolean bl, Class<? extends RuntimeProvider> clazz) {
        return new LauncherEngine(bl, clazz);
    }

    public ECPublicKey getClientPublicKey() {
        return this.publicKey;
    }

    public byte[] sign(byte[] byArray) {
        return SecurityHelper.sign(byArray, this.privateKey);
    }

    public void readKeys() throws IOException, InvalidKeySpecException {
        if (this.privateKey != null || this.publicKey != null) {
            return;
        }
        Path path = DirBridge.dir;
        Path path2 = path.resolve("public.key");
        Path path3 = path.resolve("private.key");
        if (IOHelper.isFile(path2) && IOHelper.isFile(path3)) {
            LogHelper.info("Reading EC keypair");
            this.publicKey = SecurityHelper.toPublicECDSAKey(IOHelper.read(path2));
            this.privateKey = SecurityHelper.toPrivateECDSAKey(IOHelper.read(path3));
        } else {
            LogHelper.info("Generating EC keypair");
            KeyPair keyPair = SecurityHelper.genECDSAKeyPair(new SecureRandom());
            this.publicKey = (ECPublicKey)keyPair.getPublic();
            this.privateKey = (ECPrivateKey)keyPair.getPrivate();
            LogHelper.info("Writing EC keypair list");
            IOHelper.write(path2, this.publicKey.getEncoded());
            IOHelper.write(path3, this.privateKey.getEncoded());
        }
    }

    public void start(String ... stringArray) throws Throwable {
        ClientPreGuiPhase clientPreGuiPhase = new ClientPreGuiPhase(null);
        modulesManager.invokeEvent(clientPreGuiPhase);
        this.runtimeProvider = clientPreGuiPhase.runtimeProvider;
        if (this.runtimeProvider == null) {
            this.runtimeProvider = this.basicRuntimeProvider.getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        this.runtimeProvider.init(this.clientInstance);
        if (!Request.isAvailable()) {
            RequestService requestService;
            String string = Launcher.getConfig().address;
            LogHelper.debug("Start async connection to %s", string);
            try {
                requestService = StdWebSocketService.initWebSockets(string).get();
            }
            catch (Throwable throwable) {
                if (LogHelper.isDebugEnabled()) {
                    LogHelper.error(throwable);
                }
                LogHelper.warning("Launcher in offline mode");
                requestService = LauncherEngine.initOffline();
            }
            Request.setRequestService(requestService);
            if (requestService instanceof StdWebSocketService) {
                ((StdWebSocketService)requestService).reconnectCallback = () -> {
                    LogHelper.debug("WebSocket connect closed. Try reconnect");
                    try {
                        Request.reconnect();
                    }
                    catch (Exception exception) {
                        LogHelper.error(exception);
                        throw new RequestException("Connection failed", exception);
                    }
                };
            }
        }
        Request.startAutoRefresh();
        Request.getRequestService().registerEventHandler(new BasicLauncherEventHandler());
        Objects.requireNonNull(stringArray, "args");
        if (this.started.getAndSet(true)) {
            throw new IllegalStateException("Launcher has been already started");
        }
        this.readKeys();
        this.registerCommands();
        modulesManager.invokeEvent(new ClientEngineInitPhase(this));
        this.runtimeProvider.preLoad();
        LogHelper.debug("Dir: %s", DirBridge.dir);
        this.runtimeProvider.run(stringArray);
    }

    private void registerCommands() {
        ConsoleManager.handler.registerCommand("getpublickey", new GetPublicKeyCommand(this));
        ConsoleManager.handler.registerCommand("signdata", new SignDataCommand(this));
        ConsoleManager.handler.registerCommand("modules", new ModulesCommand());
    }
}

