/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launcher.runtime.client;

import java.io.File;
import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketAddress;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.crypto.CipherOutputStream;
import pro.gravit.launcher.base.Launcher;
import pro.gravit.launcher.base.LauncherConfig;
import pro.gravit.launcher.base.profiles.ClientProfile;
import pro.gravit.launcher.base.profiles.PlayerProfile;
import pro.gravit.launcher.base.profiles.optional.OptionalView;
import pro.gravit.launcher.base.profiles.optional.actions.OptionalAction;
import pro.gravit.launcher.base.profiles.optional.actions.OptionalActionJvmArgs;
import pro.gravit.launcher.base.request.Request;
import pro.gravit.launcher.client.ClientLauncherEntryPoint;
import pro.gravit.launcher.client.ClientParams;
import pro.gravit.launcher.core.hasher.HashedDir;
import pro.gravit.launcher.core.serialize.HOutput;
import pro.gravit.launcher.runtime.LauncherEngine;
import pro.gravit.launcher.runtime.client.events.ClientProcessBuilderCreateEvent;
import pro.gravit.launcher.runtime.client.events.ClientProcessBuilderLaunchedEvent;
import pro.gravit.launcher.runtime.client.events.ClientProcessBuilderParamsWrittedEvent;
import pro.gravit.launcher.runtime.client.events.ClientProcessBuilderPreLaunchEvent;
import pro.gravit.utils.helper.EnvHelper;
import pro.gravit.utils.helper.IOHelper;
import pro.gravit.utils.helper.JVMHelper;
import pro.gravit.utils.helper.JavaHelper;
import pro.gravit.utils.helper.LogHelper;
import pro.gravit.utils.helper.SecurityHelper;
import pro.gravit.utils.launch.LaunchOptions;

public class ClientLauncherProcess {
    public final List<String> pre = new LinkedList<String>();
    public final ClientParams params = new ClientParams();
    public final List<String> jvmArgs = new LinkedList<String>();
    public final List<String> jvmModules = new LinkedList<String>();
    public final List<String> jvmModulesPaths = new LinkedList<String>();
    public final List<String> systemClientArgs = new LinkedList<String>();
    public final List<String> systemClassPath = new LinkedList<String>();
    public final Map<String, String> systemEnv = new HashMap<String, String>();
    public final String mainClass;
    private final transient Boolean[] waitWriteParams = new Boolean[]{false};
    public Path executeFile;
    public Path workDir;
    public JavaHelper.JavaVersion javaVersion;
    public boolean useLegacyJavaClassPathProperty;
    public boolean isStarted;
    private transient Process process;

    public ClientLauncherProcess(Path path, Path path2, JavaHelper.JavaVersion javaVersion, String string) {
        this.executeFile = path;
        this.workDir = path2;
        this.javaVersion = javaVersion;
        this.mainClass = string;
    }

    public ClientLauncherProcess(Path path, Path path2, JavaHelper.JavaVersion javaVersion, ClientProfile clientProfile, PlayerProfile playerProfile, String string, HashedDir hashedDir, HashedDir hashedDir2, HashedDir hashedDir3) {
        this(path, path2, javaVersion, path.resolve("resourcepacks"), clientProfile, playerProfile, null, string, hashedDir, hashedDir2, hashedDir3);
    }

    public ClientLauncherProcess(Path path, Path path2, ClientProfile clientProfile, PlayerProfile playerProfile, String string, HashedDir hashedDir, HashedDir hashedDir2, HashedDir hashedDir3) {
        this(path, path2, JavaHelper.JavaVersion.getCurrentJavaVersion(), path.resolve("resourcepacks"), clientProfile, playerProfile, null, string, hashedDir, hashedDir2, hashedDir3);
    }

    public ClientLauncherProcess(Path path, Path path2, JavaHelper.JavaVersion javaVersion, Path path3, ClientProfile clientProfile, PlayerProfile playerProfile, OptionalView optionalView, String string, HashedDir hashedDir, HashedDir hashedDir2, HashedDir hashedDir3) {
        this.javaVersion = javaVersion;
        this.workDir = path.toAbsolutePath();
        this.executeFile = IOHelper.resolveJavaBin(this.javaVersion.jvmDir);
        this.mainClass = ClientLauncherEntryPoint.class.getName();
        this.params.clientDir = this.workDir.toString();
        this.params.resourcePackDir = path3.toAbsolutePath().toString();
        this.params.assetDir = path2.toAbsolutePath().toString();
        this.params.timestamp = System.currentTimeMillis();
        Path path4 = clientProfile.hasFlag(ClientProfile.CompatibilityFlags.LEGACY_NATIVES_DIR) ? this.workDir.resolve("natives") : this.workDir.resolve("natives").resolve(JVMHelper.OS_TYPE.name).resolve(javaVersion.arch.name);
        if (!Files.isDirectory(path4, new LinkOption[0])) {
            throw new RuntimeException(String.format("Natives dir %s not exist! Your operating system or architecture not supported", path4.toAbsolutePath()));
        }
        this.params.nativesDir = path4.toString();
        this.params.profile = clientProfile;
        this.params.playerProfile = playerProfile;
        this.params.accessToken = string;
        this.params.assetHDir = hashedDir2;
        this.params.clientHDir = hashedDir;
        this.params.javaHDir = hashedDir3;
        if (optionalView != null) {
            this.params.actions = optionalView.getEnabledActions();
        }
        this.applyClientProfile();
    }

    public static String getPathSeparator() {
        if (JVMHelper.OS_TYPE == JVMHelper.OS.MUSTDIE) {
            return ";";
        }
        return ":";
    }

    private void applyClientProfile() {
        this.systemClassPath.add(IOHelper.getCodeSource(ClientLauncherEntryPoint.class).toAbsolutePath().toString());
        this.jvmArgs.addAll(this.params.profile.getJvmArgs());
        for (OptionalAction optionalAction : this.params.actions) {
            if (!(optionalAction instanceof OptionalActionJvmArgs)) continue;
            this.jvmArgs.addAll(((OptionalActionJvmArgs)optionalAction).args);
        }
        this.systemEnv.put("JAVA_HOME", this.javaVersion.jvmDir.toString());
        this.systemClassPath.addAll(this.params.profile.getAlternativeClassPath());
        if (this.params.ram > 0) {
            this.jvmArgs.add("-Xmx" + this.params.ram + "M");
        }
        this.params.oauth = Request.getOAuth();
        if (this.params.oauth == null) {
            throw new UnsupportedOperationException("Legacy session not supported");
        }
        this.params.authId = Request.getAuthId();
        this.params.oauthExpiredTime = Request.getTokenExpiredTime();
        this.params.extendedTokens = Request.getExtendedTokens();
        LauncherEngine.modulesManager.invokeEvent(new ClientProcessBuilderCreateEvent(this));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start(boolean bl) throws IOException, InterruptedException {
        Object object;
        Object object2;
        if (this.isStarted) {
            throw new IllegalStateException("Process already started");
        }
        LauncherEngine.modulesManager.invokeEvent(new ClientProcessBuilderPreLaunchEvent(this));
        LinkedList<String> linkedList = new LinkedList<String>(this.pre);
        linkedList.add(this.executeFile.toString());
        linkedList.addAll(this.jvmArgs);
        if (this.javaVersion.version >= 9) {
            this.applyJava9Params(linkedList);
        }
        linkedList.add(JVMHelper.jvmProperty("java.library.path", this.params.nativesDir));
        if (this.params.profile.getClassLoaderConfig() == ClientProfile.ClassLoaderConfig.SYSTEM_ARGS) {
            object2 = new HashSet();
            object = this.params.profile.getModuleConf();
            if (object != null) {
                if (((LaunchOptions.ModuleConf)object).modulePath != null && !((LaunchOptions.ModuleConf)object).modulePath.isEmpty()) {
                    linkedList.add("-p");
                    for (String object3 : ((LaunchOptions.ModuleConf)object).modulePath) {
                        object2.add(Path.of(object3, new String[0]));
                    }
                    linkedList.add(String.join((CharSequence)File.pathSeparator, ((LaunchOptions.ModuleConf)object).modulePath));
                }
                if (((LaunchOptions.ModuleConf)object).modules != null && !((LaunchOptions.ModuleConf)object).modules.isEmpty()) {
                    linkedList.add("--add-modules");
                    linkedList.add(String.join((CharSequence)",", ((LaunchOptions.ModuleConf)object).modules));
                }
                if (((LaunchOptions.ModuleConf)object).exports != null && !((LaunchOptions.ModuleConf)object).exports.isEmpty()) {
                    for (Map.Entry entry : ((LaunchOptions.ModuleConf)object).exports.entrySet()) {
                        linkedList.add("--add-exports");
                        linkedList.add(String.format("%s=%s", entry.getKey(), entry.getValue()));
                    }
                }
                if (((LaunchOptions.ModuleConf)object).opens != null && !((LaunchOptions.ModuleConf)object).opens.isEmpty()) {
                    for (Map.Entry entry : ((LaunchOptions.ModuleConf)object).opens.entrySet()) {
                        linkedList.add("--add-opens");
                        linkedList.add(String.format("%s=%s", entry.getKey(), entry.getValue()));
                    }
                }
                if (((LaunchOptions.ModuleConf)object).reads != null && !((LaunchOptions.ModuleConf)object).reads.isEmpty()) {
                    for (Map.Entry entry : ((LaunchOptions.ModuleConf)object).reads.entrySet()) {
                        linkedList.add("--add-reads");
                        linkedList.add(String.format("%s=%s", entry.getKey(), entry.getValue()));
                    }
                }
            }
            this.systemClassPath.addAll(ClientLauncherEntryPoint.resolveClassPath(object2, this.workDir, this.params.actions, this.params.profile).map(Path::toString).toList());
        }
        if (Launcher.getConfig().environment != LauncherConfig.LauncherEnvironment.PROD) {
            linkedList.add(JVMHelper.jvmProperty("launcher.dev", String.valueOf(LogHelper.isDevEnabled())));
            linkedList.add(JVMHelper.jvmProperty("launcher.debug", String.valueOf(LogHelper.isDebugEnabled())));
            linkedList.add(JVMHelper.jvmProperty("launcher.stacktrace", String.valueOf(LogHelper.isStacktraceEnabled())));
        }
        if (this.useLegacyJavaClassPathProperty) {
            linkedList.add("-Djava.class.path=".concat(String.join((CharSequence)ClientLauncherProcess.getPathSeparator(), this.systemClassPath)));
        } else {
            linkedList.add("-cp");
            linkedList.add(String.join((CharSequence)ClientLauncherProcess.getPathSeparator(), this.systemClassPath));
        }
        linkedList.add(this.mainClass);
        linkedList.addAll(this.systemClientArgs);
        object2 = this.waitWriteParams;
        synchronized (this.waitWriteParams) {
            if (!this.waitWriteParams[0].booleanValue()) {
                this.waitWriteParams.wait(1000L);
            }
            // ** MonitorExit[object2] (shouldn't be in output)
            if (LogHelper.isDebugEnabled()) {
                LogHelper.debug("Commandline: %s", Arrays.toString(linkedList.toArray()));
            }
            object2 = new ProcessBuilder(linkedList);
            EnvHelper.addEnv((ProcessBuilder)object2);
            if (JVMHelper.OS_TYPE == JVMHelper.OS.LINUX) {
                object = ((ProcessBuilder)object2).environment();
                object.put("__GL_THREADED_OPTIMIZATIONS", "0");
                if (this.params.lwjglGlfwWayland && !this.params.profile.hasFlag(ClientProfile.CompatibilityFlags.WAYLAND_USE_CUSTOM_GLFW)) {
                    object.remove("DISPLAY");
                }
            }
            ((ProcessBuilder)object2).environment().put("JAVA_HOME", this.javaVersion.jvmDir.toAbsolutePath().toString());
            ((ProcessBuilder)object2).environment().putAll(this.systemEnv);
            ((ProcessBuilder)object2).directory(this.workDir.toFile());
            ((ProcessBuilder)object2).inheritIO();
            if (bl) {
                ((ProcessBuilder)object2).redirectErrorStream(true);
                ((ProcessBuilder)object2).redirectOutput(ProcessBuilder.Redirect.PIPE);
            }
            this.process = ((ProcessBuilder)object2).start();
            LauncherEngine.modulesManager.invokeEvent(new ClientProcessBuilderLaunchedEvent(this));
            this.isStarted = true;
            return;
        }
    }

    private void applyJava9Params(List<String> list) {
        StringBuilder stringBuilder = new StringBuilder();
        StringBuilder stringBuilder2 = new StringBuilder();
        for (String string : this.jvmModules) {
            if (!stringBuilder2.isEmpty()) {
                stringBuilder2.append(",");
            }
            stringBuilder2.append(string);
        }
        for (String string : this.jvmModulesPaths) {
            if (!stringBuilder.isEmpty()) {
                stringBuilder.append(File.pathSeparator);
            }
            stringBuilder.append(string);
        }
        if (!stringBuilder2.isEmpty()) {
            list.add("--add-modules");
            list.add(stringBuilder2.toString());
        }
        if (!stringBuilder.isEmpty()) {
            list.add("--module-path");
            list.add(stringBuilder.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runWriteParams(SocketAddress socketAddress) throws IOException {
        try (ServerSocket serverSocket = new ServerSocket();){
            serverSocket.bind(socketAddress);
            Object object = this.waitWriteParams;
            synchronized (this.waitWriteParams) {
                this.waitWriteParams[0] = true;
                this.waitWriteParams.notifyAll();
                // ** MonitorExit[var3_3] (shouldn't be in output)
                object = serverSocket.accept();
                try (HOutput hOutput = new HOutput(new CipherOutputStream(((Socket)object).getOutputStream(), SecurityHelper.newAESEncryptCipher(SecurityHelper.fromHex(Launcher.getConfig().secretKeyClient))));){
                    byte[] byArray = IOHelper.encode(Launcher.gsonManager.gson.toJson(this.params));
                    hOutput.writeByteArray(byArray, 0);
                    this.params.clientHDir.write(hOutput);
                    this.params.assetHDir.write(hOutput);
                    if (this.params.javaHDir == null || this.params.javaHDir == this.params.assetHDir) {
                        hOutput.writeBoolean(false);
                    } else {
                        hOutput.writeBoolean(true);
                        this.params.javaHDir.write(hOutput);
                    }
                }
                catch (Exception exception) {
                    throw new IOException(exception);
                }
            }
        }
        {
            LauncherEngine.modulesManager.invokeEvent(new ClientProcessBuilderParamsWrittedEvent(this));
            return;
        }
    }

    public Process getProcess() {
        return this.process;
    }
}

