/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launcher.runtime.console;

import pro.gravit.launcher.runtime.managers.ConsoleManager;
import pro.gravit.launcher.runtime.managers.SettingsManager;
import pro.gravit.utils.command.Command;
import pro.gravit.utils.helper.LogHelper;

public class UnlockCommand
extends Command {
    @Override
    public String getArgsDescription() {
        return "[key]";
    }

    @Override
    public String getUsageDescription() {
        return "Unlock console commands";
    }

    @Override
    public void invoke(String ... stringArray) throws Exception {
        this.verifyArgs(stringArray, 1);
        if (ConsoleManager.checkUnlockKey(stringArray[0])) {
            LogHelper.info("Unlock successful");
            if (!ConsoleManager.unlock()) {
                LogHelper.error("Console unlock canceled");
                return;
            }
            LogHelper.info("Write unlock key");
            SettingsManager.settings.consoleUnlockKey = stringArray[0];
        } else {
            LogHelper.error("Unlock key incorrect");
        }
    }
}

