/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launcher.runtime.debug;

import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.InvocationTargetException;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import pro.gravit.launcher.base.Launcher;
import pro.gravit.launcher.base.LauncherConfig;
import pro.gravit.launcher.base.modules.LauncherModule;
import pro.gravit.launcher.base.modules.events.OfflineModeEvent;
import pro.gravit.launcher.base.modules.events.PreConfigPhase;
import pro.gravit.launcher.base.request.Request;
import pro.gravit.launcher.base.request.RequestService;
import pro.gravit.launcher.base.request.websockets.OfflineRequestService;
import pro.gravit.launcher.base.request.websockets.StdWebSocketService;
import pro.gravit.launcher.client.ClientLauncherMethods;
import pro.gravit.launcher.client.RuntimeLauncherCoreModule;
import pro.gravit.launcher.runtime.LauncherEngine;
import pro.gravit.launcher.runtime.debug.ClientRuntimeProvider;
import pro.gravit.launcher.runtime.debug.DebugLauncherTrustManager;
import pro.gravit.launcher.runtime.managers.ConsoleManager;
import pro.gravit.launcher.start.RuntimeModuleManager;
import pro.gravit.utils.helper.LogHelper;

public class DebugMain {
    public static final AtomicBoolean IS_DEBUG = new AtomicBoolean(false);
    public static String webSocketURL = System.getProperty("launcherdebug.websocket", "ws://localhost:9274/api");
    public static String projectName = System.getProperty("launcherdebug.projectname", "Minecraft");
    public static String unlockSecret = System.getProperty("launcherdebug.unlocksecret", "");
    public static boolean offlineMode = Boolean.getBoolean("launcherdebug.offlinemode");
    public static boolean disableAutoRefresh = Boolean.getBoolean("launcherdebug.disableautorefresh");
    public static String[] moduleClasses = System.getProperty("launcherdebug.modules", "").split(",");
    public static String[] moduleFiles = System.getProperty("launcherdebug.modulefiles", "").split(",");
    public static LauncherConfig.LauncherEnvironment environment = LauncherConfig.LauncherEnvironment.valueOf(System.getProperty("launcherdebug.env", "STD"));

    /*
     * WARNING - void declaration
     */
    public static void main(String[] stringArray) throws Throwable {
        void var2_6;
        LogHelper.printVersion("Launcher");
        LogHelper.printLicense("Launcher");
        IS_DEBUG.set(true);
        LogHelper.info("Launcher start in DEBUG mode (Only for developers)");
        LogHelper.debug("Initialization LauncherConfig");
        LauncherConfig launcherConfig = new LauncherConfig(webSocketURL, new HashMap<String, byte[]>(), projectName, environment, new DebugLauncherTrustManager(DebugLauncherTrustManager.TrustDebugMode.TRUST_ALL));
        launcherConfig.unlockSecret = unlockSecret;
        Launcher.setConfig(launcherConfig);
        Launcher.applyLauncherEnv(environment);
        LauncherEngine.modulesManager = new RuntimeModuleManager();
        LauncherEngine.modulesManager.loadModule(new RuntimeLauncherCoreModule());
        for (String string : moduleClasses) {
            if (string.isEmpty()) continue;
            LauncherEngine.modulesManager.loadModule(DebugMain.newModule(string));
        }
        for (String string : moduleFiles) {
            if (string.isEmpty()) continue;
            LauncherEngine.modulesManager.loadModule(Paths.get(string, new String[0]));
        }
        LauncherEngine.modulesManager.initModules(null);
        LauncherEngine.initGson(LauncherEngine.modulesManager);
        ConsoleManager.initConsole();
        LauncherEngine.modulesManager.invokeEvent(new PreConfigPhase());
        if (offlineMode) {
            OfflineRequestService offlineRequestService = new OfflineRequestService();
            ClientLauncherMethods.applyBasicOfflineProcessors(offlineRequestService);
            OfflineModeEvent offlineModeEvent = new OfflineModeEvent(offlineRequestService);
            LauncherEngine.modulesManager.invokeEvent(offlineModeEvent);
            RequestService requestService = offlineModeEvent.service;
        } else {
            RequestService requestService = StdWebSocketService.initWebSockets(webSocketURL).get();
        }
        Request.setRequestService((RequestService)var2_6);
        if (!disableAutoRefresh) {
            Request.startAutoRefresh();
        }
        LogHelper.debug("Initialization LauncherEngine");
        LauncherEngine launcherEngine = LauncherEngine.newInstance(false, ClientRuntimeProvider.class);
        launcherEngine.start(stringArray);
        LauncherEngine.exitLauncher(0);
    }

    public static LauncherModule newModule(String string) throws ClassNotFoundException, InvocationTargetException {
        Class<?> clazz = Class.forName(string);
        try {
            return MethodHandles.publicLookup().findConstructor(clazz, MethodType.methodType(Void.TYPE)).invoke();
        }
        catch (Throwable throwable) {
            throw new InvocationTargetException(throwable);
        }
    }
}

