/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launcher.runtime.utils;

import java.util.Iterator;
import java.util.List;
import oshi.SystemInfo;
import oshi.hardware.Display;
import oshi.hardware.GraphicsCard;
import oshi.hardware.HWDiskStore;
import oshi.hardware.HardwareAbstractionLayer;
import oshi.hardware.PowerSource;
import oshi.software.os.OperatingSystem;
import pro.gravit.launcher.base.request.secure.HardwareReportRequest;

public class HWIDProvider {
    public final SystemInfo systemInfo = new SystemInfo();
    public final OperatingSystem system = this.systemInfo.getOperatingSystem();
    public final HardwareAbstractionLayer hardware = this.systemInfo.getHardware();

    public int getBitness() {
        return this.system.getBitness();
    }

    public long getTotalMemory() {
        return this.hardware.getMemory().getTotal();
    }

    public long getProcessorMaxFreq() {
        return this.hardware.getProcessor().getMaxFreq();
    }

    public int getProcessorPhysicalCount() {
        return this.hardware.getProcessor().getPhysicalProcessorCount();
    }

    public int getProcessorLogicalCount() {
        return this.hardware.getProcessor().getLogicalProcessorCount();
    }

    public boolean isBattery() {
        List<PowerSource> list = this.hardware.getPowerSources();
        return list != null && !list.isEmpty();
    }

    public String getHWDiskID() {
        List<HWDiskStore> list = this.hardware.getDiskStores();
        long l = 0L;
        HWDiskStore hWDiskStore = null;
        for (HWDiskStore hWDiskStore2 : list) {
            if (hWDiskStore2.getSize() <= l) continue;
            hWDiskStore = hWDiskStore2;
            l = hWDiskStore2.getSize();
        }
        if (hWDiskStore != null) {
            return hWDiskStore.getSerial();
        }
        return null;
    }

    public GraphicsCard getGraphicCard() {
        List<GraphicsCard> list = this.hardware.getGraphicsCards();
        GraphicsCard graphicsCard = null;
        long l = 0L;
        for (GraphicsCard graphicsCard2 : list) {
            long l2 = graphicsCard2.getVRam();
            if (l2 <= l) continue;
            graphicsCard = graphicsCard2;
            l = l2;
        }
        return graphicsCard;
    }

    public String getGraphicCardName() {
        GraphicsCard graphicsCard = this.getGraphicCard();
        if (graphicsCard == null) {
            return null;
        }
        return graphicsCard.getName();
    }

    public long getGraphicCardMemory() {
        GraphicsCard graphicsCard = this.getGraphicCard();
        if (graphicsCard == null) {
            return 0L;
        }
        return graphicsCard.getVRam();
    }

    public byte[] getDisplayID() {
        List<Display> list = this.hardware.getDisplays();
        if (list == null || list.isEmpty()) {
            return null;
        }
        Iterator<Display> iterator = list.iterator();
        if (iterator.hasNext()) {
            Display display = iterator.next();
            return display.getEdid();
        }
        return null;
    }

    public String getBaseboardSerialNumber() {
        return this.hardware.getComputerSystem().getBaseboard().getSerialNumber();
    }

    public HardwareReportRequest.HardwareInfo getHardwareInfo(boolean bl) {
        HardwareReportRequest.HardwareInfo hardwareInfo = new HardwareReportRequest.HardwareInfo();
        hardwareInfo.bitness = this.getBitness();
        hardwareInfo.logicalProcessors = this.getProcessorLogicalCount();
        hardwareInfo.physicalProcessors = this.getProcessorPhysicalCount();
        hardwareInfo.processorMaxFreq = this.getProcessorMaxFreq();
        hardwareInfo.totalMemory = this.getTotalMemory();
        hardwareInfo.battery = this.isBattery();
        hardwareInfo.graphicCard = this.getGraphicCardName();
        if (bl) {
            hardwareInfo.hwDiskId = this.getHWDiskID();
            hardwareInfo.displayId = this.getDisplayID();
            hardwareInfo.baseboardSerialNumber = this.getBaseboardSerialNumber();
        }
        return hardwareInfo;
    }
}

