/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launcher.start;

import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JOptionPane;
import pro.gravit.launcher.base.Launcher;
import pro.gravit.launcher.base.LauncherConfig;
import pro.gravit.launcher.start.RuntimeModuleManager;
import pro.gravit.utils.Version;
import pro.gravit.utils.helper.EnvHelper;
import pro.gravit.utils.helper.IOHelper;
import pro.gravit.utils.helper.JVMHelper;
import pro.gravit.utils.helper.JavaHelper;
import pro.gravit.utils.helper.LogHelper;

public class ClientLauncherWrapper {
    public static final String MAGIC_ARG = "-Djdk.attach.allowAttachSelf";
    public static final String WAIT_PROCESS_PROPERTY = "launcher.waitProcess";
    public static final String NO_JAVA_CHECK_PROPERTY = "launcher.noJavaCheck";
    public static boolean noJavaCheck = Boolean.getBoolean("launcher.noJavaCheck");
    public static boolean waitProcess = Boolean.getBoolean("launcher.waitProcess");
    public static int launcherMemoryLimit = 256;
    public static List<String> customJvmOptions;
    public static RuntimeModuleManager modulesManager;

    public static boolean contains(String[] stringArray, String string) {
        for (String string2 : stringArray) {
            if (!string2.equals(string)) continue;
            return true;
        }
        return false;
    }

    public static void main(String[] stringArray) throws IOException, InterruptedException {
        Object object;
        Object object2;
        Object object3;
        LogHelper.printVersion("Launcher");
        LogHelper.printLicense("Launcher");
        JVMHelper.checkStackTrace(ClientLauncherWrapper.class);
        JVMHelper.verifySystemProperties(Launcher.class, true);
        EnvHelper.checkDangerousParams();
        LauncherConfig launcherConfig = Launcher.getConfig();
        modulesManager = new RuntimeModuleManager();
        LauncherConfig.initModules(modulesManager);
        LogHelper.info("Launcher for project %s", launcherConfig.projectName);
        if (launcherConfig.environment.equals((Object)LauncherConfig.LauncherEnvironment.PROD)) {
            if (System.getProperty("launcher.debug") != null) {
                LogHelper.warning("Found -Dlauncher.debug=true");
            }
            if (System.getProperty("launcher.stacktrace") != null) {
                LogHelper.warning("Found -Dlauncher.stacktrace=true");
            }
            LogHelper.info("Debug mode disabled (found env PRODUCTION)");
        } else {
            LogHelper.info("If need debug output use -Dlauncher.debug=true");
            LogHelper.info("If need stacktrace output use -Dlauncher.stacktrace=true");
            if (ClientLauncherWrapper.contains(stringArray, "--debug")) {
                LogHelper.setDebugEnabled(true);
                LogHelper.setStacktraceEnabled(true);
            }
            if (LogHelper.isDebugEnabled()) {
                waitProcess = true;
            }
        }
        LogHelper.info("Restart Launcher with JavaAgent...");
        ClientLauncherWrapperContext clientLauncherWrapperContext = new ClientLauncherWrapperContext();
        clientLauncherWrapperContext.processBuilder = new ProcessBuilder(new String[0]);
        if (waitProcess) {
            clientLauncherWrapperContext.processBuilder.inheritIO();
        }
        clientLauncherWrapperContext.javaVersion = null;
        try {
            if (!noJavaCheck) {
                object3 = JavaHelper.findJava();
                object2 = object3.iterator();
                while (object2.hasNext()) {
                    object = object2.next();
                    LogHelper.debug("Found Java %d b%d in %s javafx %s", ((JavaHelper.JavaVersion)object).version, ((JavaHelper.JavaVersion)object).build, ((JavaHelper.JavaVersion)object).jvmDir.toString(), ((JavaHelper.JavaVersion)object).enabledJavaFX ? "supported" : "not supported");
                    if (clientLauncherWrapperContext.javaVersion == null) {
                        clientLauncherWrapperContext.javaVersion = object;
                        continue;
                    }
                    if (((JavaHelper.JavaVersion)object).enabledJavaFX && !clientLauncherWrapperContext.javaVersion.enabledJavaFX) {
                        clientLauncherWrapperContext.javaVersion = object;
                        continue;
                    }
                    if (((JavaHelper.JavaVersion)object).enabledJavaFX != clientLauncherWrapperContext.javaVersion.enabledJavaFX) continue;
                    if (clientLauncherWrapperContext.javaVersion.version < ((JavaHelper.JavaVersion)object).version) {
                        clientLauncherWrapperContext.javaVersion = object;
                        continue;
                    }
                    if (clientLauncherWrapperContext.javaVersion.version != ((JavaHelper.JavaVersion)object).version || clientLauncherWrapperContext.javaVersion.build >= ((JavaHelper.JavaVersion)object).build) continue;
                    clientLauncherWrapperContext.javaVersion = object;
                }
            }
        }
        catch (Throwable throwable) {
            LogHelper.error(throwable);
        }
        if (clientLauncherWrapperContext.javaVersion == null) {
            clientLauncherWrapperContext.javaVersion = JavaHelper.JavaVersion.getCurrentJavaVersion();
        }
        if (clientLauncherWrapperContext.javaVersion.version < 17) {
            object3 = String.format("GravitLauncher v%s required Java 17 or higher", Version.getVersion());
            LogHelper.error((String)object3);
            JOptionPane.showMessageDialog(null, object3, "GravitLauncher", 0);
            System.exit(0);
        }
        clientLauncherWrapperContext.executePath = IOHelper.resolveJavaBin(clientLauncherWrapperContext.javaVersion.jvmDir);
        object3 = IOHelper.getCodeSource(ClientLauncherWrapper.class).toString();
        clientLauncherWrapperContext.mainClass = "pro.gravit.launcher.runtime.LauncherEngineWrapper";
        clientLauncherWrapperContext.memoryLimit = launcherMemoryLimit;
        clientLauncherWrapperContext.classpath.add((String)object3);
        clientLauncherWrapperContext.jvmProperties.put("launcher.debug", Boolean.toString(LogHelper.isDebugEnabled()));
        clientLauncherWrapperContext.jvmProperties.put("launcher.stacktrace", Boolean.toString(LogHelper.isStacktraceEnabled()));
        clientLauncherWrapperContext.jvmProperties.put("launcher.dev", Boolean.toString(LogHelper.isDevEnabled()));
        clientLauncherWrapperContext.jvmModules.add("javafx.base");
        clientLauncherWrapperContext.jvmModules.add("javafx.graphics");
        clientLauncherWrapperContext.jvmModules.add("javafx.fxml");
        clientLauncherWrapperContext.jvmModules.add("javafx.controls");
        clientLauncherWrapperContext.jvmModules.add("javafx.media");
        clientLauncherWrapperContext.jvmModules.add("javafx.web");
        clientLauncherWrapperContext.args.add(MAGIC_ARG);
        clientLauncherWrapperContext.args.add("-XX:+DisableAttachMechanism");
        clientLauncherWrapperContext.clientArgs.addAll(Arrays.asList(stringArray));
        EnvHelper.addEnv(clientLauncherWrapperContext.processBuilder);
        modulesManager.callWrapper(clientLauncherWrapperContext);
        object2 = new ArrayList(16);
        object2.add(clientLauncherWrapperContext.executePath.toAbsolutePath().toString());
        object2.addAll(clientLauncherWrapperContext.args);
        clientLauncherWrapperContext.jvmProperties.forEach((arg_0, arg_1) -> ClientLauncherWrapper.lambda$main$0((List)object2, arg_0, arg_1));
        if (clientLauncherWrapperContext.memoryLimit != 0) {
            object2.add(String.format("-Xmx%dM", clientLauncherWrapperContext.memoryLimit));
        }
        if (customJvmOptions != null) {
            object2.addAll(customJvmOptions);
        }
        if (clientLauncherWrapperContext.useLegacyClasspathProperty) {
            object2.add(String.format("-Djava.class.path=%s", String.join((CharSequence)IOHelper.PLATFORM_SEPARATOR, clientLauncherWrapperContext.classpath)));
        } else {
            object2.add("-cp");
            object2.add(String.join((CharSequence)IOHelper.PLATFORM_SEPARATOR, clientLauncherWrapperContext.classpath));
        }
        object2.add(clientLauncherWrapperContext.mainClass);
        object2.addAll(clientLauncherWrapperContext.clientArgs);
        LogHelper.debug("Commandline: " + String.valueOf(object2));
        clientLauncherWrapperContext.processBuilder.command((List<String>)object2);
        object = clientLauncherWrapperContext.processBuilder.start();
        if (!waitProcess) {
            Thread.sleep(3000L);
            if (!((Process)object).isAlive()) {
                int n = ((Process)object).exitValue();
                if (n != 0) {
                    LogHelper.error("Process exit with error code: %d", n);
                } else {
                    LogHelper.info("Process exit with code 0");
                }
            } else {
                LogHelper.debug("Process started success");
            }
        } else {
            ((Process)object).waitFor();
        }
    }

    private static /* synthetic */ void lambda$main$0(List list, String string, String string2) {
        list.add(String.format("-D%s=%s", string, string2));
    }

    static {
        ArrayList<String> arrayList = new ArrayList<String>(1);
        arrayList.add("-Dfile.encoding=UTF-8");
        customJvmOptions = arrayList;
    }

    public static class ClientLauncherWrapperContext {
        public JavaHelper.JavaVersion javaVersion;
        public Path executePath;
        public String mainClass;
        public int memoryLimit;
        public boolean useLegacyClasspathProperty;
        public ProcessBuilder processBuilder;
        public List<String> args = new ArrayList<String>(8);
        public Map<String, String> jvmProperties = new HashMap<String, String>();
        public List<String> classpath = new ArrayList<String>();
        public List<String> jvmModules = new ArrayList<String>();
        public List<String> clientArgs = new ArrayList<String>();
        public List<Path> javaFXPaths = new ArrayList<Path>();

        public void addSystemProperty(String string) {
            String string2 = System.getProperty(string);
            if (string2 != null) {
                this.jvmProperties.put(string, string2);
            }
        }
    }
}

