/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.utils;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;
import pro.gravit.utils.ProviderMap;
import pro.gravit.utils.TypeSerializeInterface;

public class UniversalJsonAdapter<R>
implements JsonSerializer<R>,
JsonDeserializer<R> {
    public final ProviderMap<R> providerMap;
    public final String name;
    public final String PROP_NAME;
    public Class<? extends R> defaultClass;

    public UniversalJsonAdapter(ProviderMap<R> providerMap) {
        this.providerMap = providerMap;
        this.name = providerMap.getName();
        this.PROP_NAME = "type";
    }

    public UniversalJsonAdapter(ProviderMap<R> providerMap, String string) {
        this.providerMap = providerMap;
        this.name = providerMap.getName();
        this.PROP_NAME = string;
    }

    public UniversalJsonAdapter(ProviderMap<R> providerMap, String string, Class<? extends R> clazz) {
        this.providerMap = providerMap;
        this.name = string;
        this.defaultClass = clazz;
        this.PROP_NAME = "type";
    }

    public UniversalJsonAdapter(ProviderMap<R> providerMap, Class<? extends R> clazz) {
        this.providerMap = providerMap;
        this.defaultClass = clazz;
        this.name = providerMap.getName();
        this.PROP_NAME = "type";
    }

    public UniversalJsonAdapter(ProviderMap<R> providerMap, String string, String string2, Class<? extends R> clazz) {
        this.providerMap = providerMap;
        this.name = string;
        this.PROP_NAME = string2;
        this.defaultClass = clazz;
    }

    @Override
    public R deserialize(JsonElement jsonElement, Type type, JsonDeserializationContext jsonDeserializationContext) throws JsonParseException {
        String string = jsonElement.getAsJsonObject().getAsJsonPrimitive(this.PROP_NAME).getAsString();
        if (string == null) {
            throw new JsonParseException(String.format("%s: missing type property", this.name));
        }
        Class<R> clazz = this.providerMap.getClass(string);
        if (clazz == null) {
            if (this.defaultClass != null) {
                return (R)jsonDeserializationContext.deserialize(jsonElement, this.defaultClass);
            }
            throw new JsonParseException(String.format("%s: type %s not registered", this.name, string));
        }
        return (R)jsonDeserializationContext.deserialize(jsonElement, clazz);
    }

    @Override
    public JsonElement serialize(R r, Type type, JsonSerializationContext jsonSerializationContext) {
        JsonObject jsonObject = jsonSerializationContext.serialize(r).getAsJsonObject();
        String string = this.providerMap.getName(r.getClass());
        if (string == null && r instanceof TypeSerializeInterface) {
            string = ((TypeSerializeInterface)r).getType();
        }
        if (string == null) {
            throw new JsonParseException(String.format("Class %s not registered", r.getClass().getName()));
        }
        jsonObject.add(this.PROP_NAME, new JsonPrimitive(string));
        return jsonObject;
    }
}

