/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.utils.command;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import pro.gravit.utils.command.BaseCommandCategory;
import pro.gravit.utils.command.Command;
import pro.gravit.utils.command.CommandCategory;
import pro.gravit.utils.command.CommandException;
import pro.gravit.utils.helper.CommonHelper;
import pro.gravit.utils.helper.LogHelper;

public abstract class CommandHandler
implements Runnable {
    protected final List<Category> categories;
    protected final CommandCategory baseCategory;

    public CommandHandler() {
        this.categories = new ArrayList<Category>();
        this.baseCategory = new BaseCommandCategory();
    }

    protected CommandHandler(List<Category> list, CommandCategory commandCategory) {
        this.categories = list;
        this.baseCategory = commandCategory;
    }

    public void eval(String string, boolean bl) {
        LogHelper.info("Command '%s'", string);
        try {
            this.evalNative(string, bl);
        }
        catch (Exception exception) {
            LogHelper.error(exception);
        }
    }

    public void evalNative(String string, boolean bl) throws Exception {
        String[] stringArray = CommonHelper.parseCommand(string);
        if (stringArray.length > 0) {
            stringArray[0] = stringArray[0].toLowerCase();
        }
        this.eval(stringArray, bl);
    }

    public void eval(String[] stringArray, boolean bl) throws Exception {
        if (stringArray.length == 0) {
            return;
        }
        long l = System.currentTimeMillis();
        this.lookup(stringArray[0]).invoke(Arrays.copyOfRange(stringArray, 1, stringArray.length));
        long l2 = System.currentTimeMillis();
        if (bl && l2 - l >= 5000L) {
            this.bell();
        }
    }

    public Command lookup(String string) throws CommandException {
        Command command = this.findCommand(string);
        if (command == null) {
            throw new CommandException(String.format("Unknown command: '%s'", string));
        }
        return command;
    }

    public Command findCommand(String string) {
        Command command = this.baseCategory.findCommand(string);
        if (command == null) {
            for (Category category : this.categories) {
                command = category.category.findCommand(string);
                if (command == null) continue;
                return command;
            }
        }
        return command;
    }

    public abstract String readLine() throws IOException;

    private void readLoop() throws IOException {
        String string = this.readLine();
        while (string != null) {
            this.eval(string, true);
            string = this.readLine();
        }
    }

    public void registerCommand(String string, Command command) {
        this.baseCategory.registerCommand(string, command);
    }

    public void registerCategory(Category category) {
        this.categories.add(category);
    }

    public void unregisterCategory(Category category) {
        this.categories.remove(category);
    }

    public Category findCategory(String string) {
        for (Category category : this.categories) {
            if (!category.name.equals(string)) continue;
            return category;
        }
        return null;
    }

    public Command unregisterCommand(String string) {
        return this.baseCategory.unregisterCommand(string);
    }

    @Override
    public void run() {
        try {
            this.readLoop();
        }
        catch (IOException iOException) {
            LogHelper.error(iOException);
        }
    }

    public void walk(CommandWalk commandWalk) {
        for (Category object : this.getCategories()) {
            for (Map.Entry<String, Command> entry : object.category.commandsMap().entrySet()) {
                commandWalk.walk(object, entry.getKey(), entry.getValue());
            }
        }
        for (Map.Entry entry : this.getBaseCategory().commandsMap().entrySet()) {
            commandWalk.walk(null, (String)entry.getKey(), (Command)entry.getValue());
        }
    }

    public CommandCategory getBaseCategory() {
        return this.baseCategory;
    }

    public List<Category> getCategories() {
        return this.categories;
    }

    public abstract void bell();

    public abstract void clear() throws IOException;

    public static class Category {
        public final CommandCategory category;
        public final String name;
        public String description;

        public Category(CommandCategory commandCategory, String string) {
            this.category = commandCategory;
            this.name = string;
        }

        public Category(CommandCategory commandCategory, String string, String string2) {
            this.category = commandCategory;
            this.name = string;
            this.description = string2;
        }
    }

    @FunctionalInterface
    public static interface CommandWalk {
        public void walk(Category var1, String var2, Command var3);
    }
}

