/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.utils.command;

import java.io.IOException;
import java.util.List;
import org.jline.reader.Candidate;
import org.jline.reader.Completer;
import org.jline.reader.LineReader;
import org.jline.reader.LineReaderBuilder;
import org.jline.reader.ParsedLine;
import org.jline.reader.UserInterruptException;
import org.jline.terminal.Terminal;
import org.jline.terminal.TerminalBuilder;
import org.jline.utils.InfoCmp;
import pro.gravit.utils.command.Command;
import pro.gravit.utils.command.CommandHandler;

public class JLineCommandHandler
extends CommandHandler {
    private final Terminal terminal;
    private final LineReader reader;

    public JLineCommandHandler() throws IOException {
        TerminalBuilder terminalBuilder = TerminalBuilder.builder();
        this.terminal = terminalBuilder.build();
        JLineConsoleCompleter jLineConsoleCompleter = new JLineConsoleCompleter();
        this.reader = LineReaderBuilder.builder().terminal(this.terminal).completer((Completer)jLineConsoleCompleter).build();
    }

    @Override
    public void bell() {
        this.terminal.puts(InfoCmp.Capability.bell, new Object[0]);
    }

    @Override
    public void clear() {
        this.terminal.puts(InfoCmp.Capability.clear_screen, new Object[0]);
    }

    @Override
    public String readLine() {
        try {
            return this.reader.readLine();
        }
        catch (UserInterruptException userInterruptException) {
            System.exit(0);
            return null;
        }
    }

    public class JLineConsoleCompleter
    implements Completer {
        public void complete(LineReader lineReader, ParsedLine parsedLine, List<Candidate> list) {
            String string = parsedLine.word();
            if (parsedLine.wordIndex() == 0) {
                JLineCommandHandler.this.walk((category, string2, command) -> {
                    if (string2.startsWith(string)) {
                        list.add(command.buildCandidate(category, string2));
                    }
                });
            } else {
                Command command2 = JLineCommandHandler.this.findCommand((String)parsedLine.words().get(0));
                if (command2 == null) {
                    return;
                }
                List list2 = parsedLine.words();
                List<Candidate> list3 = command2.complete(list2.subList(1, list2.size()), parsedLine.wordIndex() - 1, string);
                list.addAll(list3);
            }
        }
    }
}

