/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.utils.command;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import pro.gravit.utils.command.CommandCategory;
import pro.gravit.utils.command.CommandHandler;
import pro.gravit.utils.helper.IOHelper;
import pro.gravit.utils.helper.JVMHelper;

public class StdCommandHandler
extends CommandHandler {
    private final BufferedReader reader;

    public StdCommandHandler(boolean bl) {
        this.reader = bl ? IOHelper.newReader(System.in) : null;
    }

    public StdCommandHandler(InputStream inputStream) {
        this.reader = IOHelper.newReader(inputStream);
    }

    public StdCommandHandler(BufferedReader bufferedReader) {
        this.reader = bufferedReader;
    }

    protected StdCommandHandler(List<CommandHandler.Category> list, CommandCategory commandCategory, boolean bl) {
        super(list, commandCategory);
        this.reader = bl ? IOHelper.newReader(System.in) : null;
    }

    protected StdCommandHandler(List<CommandHandler.Category> list, CommandCategory commandCategory, InputStream inputStream) {
        super(list, commandCategory);
        this.reader = IOHelper.newReader(inputStream);
    }

    protected StdCommandHandler(List<CommandHandler.Category> list, CommandCategory commandCategory, BufferedReader bufferedReader) {
        super(list, commandCategory);
        this.reader = bufferedReader;
    }

    @Override
    public void bell() {
    }

    @Override
    public void clear() throws IOException {
        System.out.flush();
        if (JVMHelper.OS_TYPE == JVMHelper.OS.MUSTDIE) {
            try {
                new ProcessBuilder("cmd", "/c", "cls").inheritIO().start().waitFor();
            }
            catch (InterruptedException interruptedException) {
                throw new IOException(interruptedException);
            }
        } else {
            System.out.print("\u001b[H\u001b[2J");
            System.out.flush();
        }
    }

    @Override
    public String readLine() throws IOException {
        return this.reader == null ? null : this.reader.readLine();
    }

    public StdCommandHandler ofHandler(CommandHandler commandHandler, boolean bl) {
        return new StdCommandHandler(commandHandler.categories, commandHandler.baseCategory, bl);
    }

    public StdCommandHandler ofHandler(CommandHandler commandHandler, InputStream inputStream) {
        return new StdCommandHandler(commandHandler.categories, commandHandler.baseCategory, inputStream);
    }

    public StdCommandHandler ofHandler(CommandHandler commandHandler, BufferedReader bufferedReader) {
        return new StdCommandHandler(commandHandler.categories, commandHandler.baseCategory, bufferedReader);
    }
}

