/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.utils.helper;

import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.script.ScriptEngine;
import pro.gravit.utils.command.CommandException;
import pro.gravit.utils.launch.LaunchOptions;

public final class CommonHelper {
    private CommonHelper() {
    }

    public static String low(String string) {
        return string.toLowerCase(Locale.US);
    }

    public static boolean multiMatches(Pattern[] patternArray, String string) {
        for (Pattern pattern : patternArray) {
            if (!pattern.matcher(string).matches()) continue;
            return true;
        }
        return false;
    }

    public static String multiReplace(Pattern[] patternArray, String string, String string2) {
        String string3 = null;
        for (Pattern pattern : patternArray) {
            Matcher matcher = pattern.matcher(string);
            if (!matcher.matches()) continue;
            string3 = matcher.replaceAll(string2);
        }
        return string3 != null ? string3 : string;
    }

    @Deprecated
    public static ScriptEngine newScriptEngine() {
        throw new UnsupportedOperationException("ScriptEngine not supported");
    }

    public static Thread newThread(String string, boolean bl, Runnable runnable) {
        Thread thread = new Thread(runnable);
        thread.setDaemon(bl);
        if (string != null) {
            thread.setName(string);
        }
        return thread;
    }

    public static String replace(String string, String ... stringArray) {
        for (int i = 0; i < stringArray.length; i += 2) {
            string = string.replace("%" + stringArray[i] + "%", stringArray[i + 1]);
        }
        return string;
    }

    public static String replace(Map<String, String> map, String string) {
        for (Map.Entry<String, String> entry : map.entrySet()) {
            string = string.replace(entry.getKey(), entry.getValue());
        }
        return string;
    }

    public static List<String> replace(Map<String, String> map, List<String> list) {
        ArrayList<String> arrayList = new ArrayList<String>(list.size());
        for (String string : list) {
            arrayList.add(CommonHelper.replace(map, string));
        }
        return arrayList;
    }

    public static String[] parseCommand(CharSequence charSequence) throws CommandException {
        boolean bl = false;
        boolean bl2 = false;
        LinkedList<String> linkedList = new LinkedList<String>();
        StringBuilder stringBuilder = new StringBuilder(100);
        block4: for (int i = 0; i <= charSequence.length(); ++i) {
            char c;
            boolean bl3 = i >= charSequence.length();
            char c2 = c = bl3 ? (char)'\u0000' : charSequence.charAt(i);
            if (bl3 || !bl && Character.isWhitespace(c)) {
                if (bl3 && bl) {
                    throw new CommandException("Quotes wasn't closed");
                }
                if (bl2 || !stringBuilder.isEmpty()) {
                    linkedList.add(stringBuilder.toString());
                }
                bl2 = false;
                stringBuilder.setLength(0);
                continue;
            }
            switch (c) {
                case '\"': {
                    bl = !bl;
                    bl2 = true;
                    continue block4;
                }
                case '\\': {
                    if (i + 1 >= charSequence.length()) {
                        throw new CommandException("Escape character is not specified");
                    }
                    char c3 = charSequence.charAt(i + 1);
                    stringBuilder.append(c3);
                    ++i;
                    continue block4;
                }
                default: {
                    stringBuilder.append(c);
                }
            }
        }
        return linkedList.toArray(new String[0]);
    }

    public static GsonBuilder newBuilder() {
        return new GsonBuilder().registerTypeHierarchyAdapter(byte[].class, ByteArrayToBase64TypeAdapter.INSTANCE);
    }

    public static ArgsParseResult parseJavaArgs(List<String> list) {
        ArrayList<String> arrayList = new ArrayList<String>();
        ArrayList<String> arrayList2 = new ArrayList<String>();
        ArrayList<String> arrayList3 = new ArrayList<String>();
        String string = null;
        String string2 = null;
        String string3 = null;
        LaunchOptions.ModuleConf moduleConf = new LaunchOptions.ModuleConf();
        PrevArgType prevArgType = PrevArgType.NONE;
        boolean bl = false;
        boolean bl2 = false;
        block12: for (String string4 : list) {
            if (bl) {
                arrayList3.add(string4);
                continue;
            }
            if (!bl2) {
                if (!string4.startsWith("-")) continue;
                bl2 = true;
            }
            switch (prevArgType.ordinal()) {
                case 0: {
                    break;
                }
                case 1: {
                    char c = ':';
                    int n = string4.indexOf(c);
                    if (n < 0) {
                        c = ';';
                    }
                    String[] stringArray = string4.split(Character.toString(c));
                    moduleConf.modulePath.addAll(Arrays.asList(stringArray));
                    prevArgType = PrevArgType.NONE;
                    continue block12;
                }
                case 6: {
                    char c = ':';
                    int n = string4.indexOf(c);
                    if (n < 0) {
                        c = ';';
                    }
                    String[] stringArray = string4.split(Character.toString(c));
                    arrayList.addAll(Arrays.asList(stringArray));
                    prevArgType = PrevArgType.POST_CLASSPATH;
                    continue block12;
                }
                case 2: {
                    String[] stringArray = string4.split(",");
                    moduleConf.modules.addAll(Arrays.asList(stringArray));
                    prevArgType = PrevArgType.NONE;
                    continue block12;
                }
                case 3: {
                    String[] stringArray = string4.split("=");
                    moduleConf.opens.put(stringArray[0], stringArray[1]);
                    prevArgType = PrevArgType.NONE;
                    continue block12;
                }
                case 4: {
                    String[] stringArray = string4.split("=");
                    moduleConf.exports.put(stringArray[0], stringArray[1]);
                    prevArgType = PrevArgType.NONE;
                    continue block12;
                }
                case 5: {
                    String[] stringArray = string4.split("=");
                    if (stringArray.length != 2) continue block12;
                    moduleConf.reads.put(stringArray[0], stringArray[1]);
                    prevArgType = PrevArgType.NONE;
                    continue block12;
                }
                case 10: {
                    String[] stringArray = string4.split("/");
                    string3 = stringArray[0];
                    string2 = stringArray[1];
                    bl = true;
                    prevArgType = PrevArgType.NONE;
                    continue block12;
                }
                case 7: {
                    string2 = string4;
                    bl = true;
                    prevArgType = PrevArgType.NONE;
                    continue block12;
                }
                case 8: {
                    string = string4;
                    bl = true;
                    prevArgType = PrevArgType.NONE;
                    continue block12;
                }
            }
            if (string4.equals("--module-path") || string4.equals("-p")) {
                prevArgType = PrevArgType.MODULE_PATH;
                continue;
            }
            if (string4.equals("--classpath") || string4.equals("-cp")) {
                prevArgType = PrevArgType.CLASSPATH;
                continue;
            }
            if (string4.equals("--add-modules")) {
                prevArgType = PrevArgType.ADD_MODULES;
                continue;
            }
            if (string4.equals("--add-opens")) {
                prevArgType = PrevArgType.ADD_OPENS;
                continue;
            }
            if (string4.equals("--add-exports")) {
                prevArgType = PrevArgType.ADD_EXPORTS;
                continue;
            }
            if (string4.equals("--add-reads")) {
                prevArgType = PrevArgType.ADD_READS;
                continue;
            }
            if (string4.equals("--module") || string4.equals("-m")) {
                prevArgType = PrevArgType.MODULE;
                continue;
            }
            if (string4.equals("-jar")) {
                prevArgType = PrevArgType.JAR;
                continue;
            }
            arrayList2.add(string4);
        }
        return new ArgsParseResult(moduleConf, arrayList, arrayList2, string2, string3, string, list);
    }

    public static <K, V> V multimapFirstOrNullValue(K k, Map<K, List<V>> map) {
        List list = map.getOrDefault(k, Collections.emptyList());
        if (list.isEmpty()) {
            return null;
        }
        return (V)list.getFirst();
    }

    private static class ByteArrayToBase64TypeAdapter
    implements JsonSerializer<byte[]>,
    JsonDeserializer<byte[]> {
        private static final ByteArrayToBase64TypeAdapter INSTANCE = new ByteArrayToBase64TypeAdapter();
        private final Base64.Decoder decoder = Base64.getUrlDecoder();
        private final Base64.Encoder encoder = Base64.getUrlEncoder();

        private ByteArrayToBase64TypeAdapter() {
        }

        @Override
        public byte[] deserialize(JsonElement jsonElement, Type type, JsonDeserializationContext jsonDeserializationContext) throws JsonParseException {
            if (jsonElement.isJsonArray()) {
                JsonArray jsonArray = jsonElement.getAsJsonArray();
                byte[] byArray = new byte[jsonArray.size()];
                for (int i = 0; i < byArray.length; ++i) {
                    byArray[i] = jsonArray.get(i).getAsByte();
                }
                return byArray;
            }
            return this.decoder.decode(jsonElement.getAsString());
        }

        @Override
        public JsonElement serialize(byte[] byArray, Type type, JsonSerializationContext jsonSerializationContext) {
            return new JsonPrimitive(this.encoder.encodeToString(byArray));
        }
    }

    private static enum PrevArgType {
        NONE,
        MODULE_PATH,
        ADD_MODULES,
        ADD_OPENS,
        ADD_EXPORTS,
        ADD_READS,
        CLASSPATH,
        POST_CLASSPATH,
        JAR,
        MAINCLASS,
        MODULE;

    }

    public record ArgsParseResult(LaunchOptions.ModuleConf conf, List<String> classpath, List<String> jvmArgs, String mainClass, String mainModule, String jarFile, List<String> args) {
    }
}

