/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.utils.helper;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.file.Path;
import java.util.Collections;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import java.util.function.Supplier;
import pro.gravit.utils.helper.IOHelper;
import pro.gravit.utils.logging.LogHelperAppender;
import pro.gravit.utils.logging.SimpleLogHelperImpl;
import pro.gravit.utils.logging.Slf4jLogHelperImpl;

public final class LogHelper {
    public static final String DEBUG_PROPERTY = "launcher.debug";
    public static final String DEV_PROPERTY = "launcher.dev";
    public static final String STACKTRACE_PROPERTY = "launcher.stacktrace";
    public static final String NO_JANSI_PROPERTY = "launcher.noJAnsi";
    public static final String SLF4J_PROPERTY = "launcher.useSlf4j";
    private static final Set<Consumer<Throwable>> EXCEPTIONS_CALLBACKS = Collections.newSetFromMap(new ConcurrentHashMap(2));
    private static final LogHelperAppender impl;

    private LogHelper() {
    }

    public static void addOutput(OutputEnity outputEnity) {
        impl.addOutput(outputEnity);
    }

    public static void addExcCallback(Consumer<Throwable> consumer) {
        EXCEPTIONS_CALLBACKS.add(Objects.requireNonNull(consumer, "output"));
    }

    public static void addOutput(Output output, OutputTypes outputTypes) {
        LogHelper.addOutput(new OutputEnity(Objects.requireNonNull(output, "output"), outputTypes));
    }

    public static void addOutput(Path path) throws IOException {
        LogHelper.addOutput(IOHelper.newWriter(path, true));
    }

    public static void addOutput(Writer writer) {
        LogHelper.addOutput(new SimpleLogHelperImpl.WriterOutput(writer), OutputTypes.PLAIN);
    }

    public static void debug(String string) {
        if (LogHelper.isDebugEnabled()) {
            LogHelper.log(Level.DEBUG, string, false);
        }
    }

    public static void dev(String string) {
        if (LogHelper.isDevEnabled()) {
            LogHelper.log(Level.DEV, string, false);
        }
    }

    public static void debug(String string, Object ... objectArray) {
        LogHelper.debug(String.format(string, objectArray));
    }

    public static void dev(String string, Object ... objectArray) {
        if (LogHelper.isDevEnabled()) {
            LogHelper.dev(String.format(string, objectArray));
        }
    }

    public static void error(Throwable throwable) {
        EXCEPTIONS_CALLBACKS.forEach(consumer -> consumer.accept(throwable));
        LogHelper.error(LogHelper.isStacktraceEnabled() ? LogHelper.toString(throwable) : throwable.toString());
    }

    public static void error(String string) {
        LogHelper.log(Level.ERROR, string, false);
    }

    public static void error(String string, Object ... objectArray) {
        LogHelper.error(String.format(string, objectArray));
    }

    public static void info(String string) {
        LogHelper.log(Level.INFO, string, false);
    }

    public static void info(String string, Object ... objectArray) {
        LogHelper.info(String.format(string, objectArray));
    }

    public static boolean isDebugEnabled() {
        return impl.isDebugEnabled();
    }

    public static void setDebugEnabled(boolean bl) {
        impl.setDebugEnabled(bl);
    }

    public static boolean isStacktraceEnabled() {
        return impl.isStacktraceEnabled();
    }

    public static void setStacktraceEnabled(boolean bl) {
        impl.setStacktraceEnabled(bl);
    }

    public static boolean isDevEnabled() {
        return impl.isDevEnabled();
    }

    public static void setDevEnabled(boolean bl) {
        impl.setDevEnabled(bl);
    }

    public static void log(Level level, String string, boolean bl) {
        impl.log(level, string, bl);
    }

    public static void logJAnsi(Level level, Supplier<String> supplier, Supplier<String> supplier2, boolean bl) {
        impl.logJAnsi(level, supplier, supplier2, bl);
    }

    public static void printVersion(String string) {
        impl.printVersion(string);
    }

    public static void printLicense(String string) {
        impl.printLicense(string);
    }

    public static boolean removeOutput(OutputEnity outputEnity) {
        return impl.removeOutput(outputEnity);
    }

    public static void subDebug(String string) {
        if (LogHelper.isDebugEnabled()) {
            LogHelper.log(Level.DEBUG, string, true);
        }
    }

    public static void subDebug(String string, Object ... objectArray) {
        LogHelper.subDebug(String.format(string, objectArray));
    }

    public static void subInfo(String string) {
        LogHelper.log(Level.INFO, string, true);
    }

    public static void subInfo(String string, Object ... objectArray) {
        LogHelper.subInfo(String.format(string, objectArray));
    }

    public static void subWarning(String string) {
        LogHelper.log(Level.WARNING, string, true);
    }

    public static void subWarning(String string, Object ... objectArray) {
        LogHelper.subWarning(String.format(string, objectArray));
    }

    public static String toString(Throwable throwable) {
        StringWriter stringWriter = new StringWriter();
        throwable.printStackTrace(new PrintWriter(stringWriter));
        return stringWriter.toString();
    }

    public static void warning(String string) {
        LogHelper.log(Level.WARNING, string, false);
    }

    public static void warning(String string, Object ... objectArray) {
        LogHelper.warning(String.format(string, objectArray));
    }

    static {
        boolean bl = false;
        try {
            Class.forName("org.slf4j.Logger", false, LogHelper.class.getClassLoader());
            bl = Boolean.getBoolean(SLF4J_PROPERTY);
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        impl = bl ? new Slf4jLogHelperImpl() : new SimpleLogHelperImpl();
    }

    public static class OutputEnity {
        public final Output output;
        public final OutputTypes type;

        public OutputEnity(Output output, OutputTypes outputTypes) {
            this.output = output;
            this.type = outputTypes;
        }
    }

    @FunctionalInterface
    public static interface Output {
        public void println(String var1);
    }

    public static enum OutputTypes {
        PLAIN,
        JANSI;

    }

    public static enum Level {
        DEV("DEV"),
        DEBUG("DEBUG"),
        INFO("INFO"),
        WARNING("WARN"),
        ERROR("ERROR");

        public final String name;

        private Level(String string2) {
            this.name = string2;
        }

        public String toString() {
            return this.name;
        }
    }
}

