/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.utils.helper;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.file.Path;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.SecureRandom;
import java.security.Signature;
import java.security.SignatureException;
import java.security.interfaces.ECPrivateKey;
import java.security.interfaces.ECPublicKey;
import java.security.interfaces.RSAKey;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.ECGenParameterSpec;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import pro.gravit.utils.helper.IOHelper;
import pro.gravit.utils.helper.VerifyHelper;

public final class SecurityHelper {
    public static final String EC_ALGO = "EC";
    public static final String EC_CURVE = "secp256r1";
    public static final String EC_SIGN_ALGO = "SHA256withECDSA";
    public static final int TOKEN_LENGTH = 16;
    public static final String RSA_ALGO = "RSA";
    public static final String RSA_SIGN_ALGO = "SHA256withRSA";
    public static final String RSA_CIPHER_ALGO = "RSA/ECB/PKCS1Padding";
    public static final String AES_CIPHER_ALGO = "AES/ECB/PKCS5Padding";
    public static final int AES_KEY_LENGTH = 16;
    public static final int TOKEN_STRING_LENGTH = 32;
    public static final int RSA_KEY_LENGTH_BITS = 2048;
    public static final int RSA_KEY_LENGTH = 256;
    public static final int CRYPTO_MAX_LENGTH = 2048;
    public static final String HEX = "0123456789abcdef";

    private SecurityHelper() {
    }

    public static byte[] digest(DigestAlgorithm digestAlgorithm, byte[] byArray) {
        return SecurityHelper.newDigest(digestAlgorithm).digest(byArray);
    }

    public static byte[] digest(DigestAlgorithm digestAlgorithm, InputStream inputStream) throws IOException {
        byte[] byArray = IOHelper.newBuffer();
        MessageDigest messageDigest = SecurityHelper.newDigest(digestAlgorithm);
        int n = inputStream.read(byArray);
        while (n != -1) {
            messageDigest.update(byArray, 0, n);
            n = inputStream.read(byArray);
        }
        return messageDigest.digest();
    }

    public static byte[] digest(DigestAlgorithm digestAlgorithm, Path path) throws IOException {
        try (InputStream inputStream = IOHelper.newInput(path);){
            byte[] byArray = SecurityHelper.digest(digestAlgorithm, inputStream);
            return byArray;
        }
    }

    public static byte[] digest(DigestAlgorithm digestAlgorithm, String string) {
        return SecurityHelper.digest(digestAlgorithm, IOHelper.encode(string));
    }

    public static byte[] digest(DigestAlgorithm digestAlgorithm, URL uRL) throws IOException {
        try (InputStream inputStream = IOHelper.newInput(uRL);){
            byte[] byArray = SecurityHelper.digest(digestAlgorithm, inputStream);
            return byArray;
        }
    }

    public static KeyPair genECDSAKeyPair(SecureRandom secureRandom) {
        try {
            KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance(EC_ALGO);
            keyPairGenerator.initialize(new ECGenParameterSpec(EC_CURVE), secureRandom);
            return keyPairGenerator.genKeyPair();
        }
        catch (InvalidAlgorithmParameterException | NoSuchAlgorithmException generalSecurityException) {
            throw new InternalError(generalSecurityException);
        }
    }

    public static KeyPair genRSAKeyPair(SecureRandom secureRandom) {
        try {
            KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance(RSA_ALGO);
            keyPairGenerator.initialize(2048, secureRandom);
            return keyPairGenerator.genKeyPair();
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new InternalError(noSuchAlgorithmException);
        }
    }

    public static boolean isValidSign(byte[] byArray, byte[] byArray2, ECPublicKey eCPublicKey) throws SignatureException {
        Signature signature = SecurityHelper.newECVerifySignature(eCPublicKey);
        try {
            signature.update(byArray);
        }
        catch (SignatureException signatureException) {
            throw new InternalError(signatureException);
        }
        return signature.verify(byArray2);
    }

    public static boolean isValidSign(InputStream inputStream, byte[] byArray, ECPublicKey eCPublicKey) throws IOException, SignatureException {
        Signature signature = SecurityHelper.newECVerifySignature(eCPublicKey);
        SecurityHelper.updateSignature(inputStream, signature);
        return signature.verify(byArray);
    }

    public static boolean isValidSign(byte[] byArray, byte[] byArray2, RSAPublicKey rSAPublicKey) throws SignatureException {
        Signature signature = SecurityHelper.newRSAVerifySignature(rSAPublicKey);
        try {
            signature.update(byArray);
        }
        catch (SignatureException signatureException) {
            throw new InternalError(signatureException);
        }
        return signature.verify(byArray2);
    }

    public static boolean isValidSign(InputStream inputStream, byte[] byArray, RSAPublicKey rSAPublicKey) throws IOException, SignatureException {
        Signature signature = SecurityHelper.newRSAVerifySignature(rSAPublicKey);
        SecurityHelper.updateSignature(inputStream, signature);
        return signature.verify(byArray);
    }

    public static boolean isValidToken(CharSequence charSequence) {
        return charSequence.length() == 32 && charSequence.chars().allMatch(n -> HEX.indexOf(n) >= 0);
    }

    public static Cipher newCipher(String string) {
        try {
            return Cipher.getInstance(string);
        }
        catch (NoSuchAlgorithmException | NoSuchPaddingException generalSecurityException) {
            throw new InternalError(generalSecurityException);
        }
    }

    private static Cipher newBCCipher(String string) {
        try {
            return Cipher.getInstance(string, "BC");
        }
        catch (NoSuchAlgorithmException | NoSuchProviderException | NoSuchPaddingException generalSecurityException) {
            throw new InternalError(generalSecurityException);
        }
    }

    public static MessageDigest newDigest(DigestAlgorithm digestAlgorithm2) {
        VerifyHelper.verify(digestAlgorithm2, digestAlgorithm -> digestAlgorithm != DigestAlgorithm.PLAIN, "PLAIN digest");
        try {
            return MessageDigest.getInstance(digestAlgorithm2.name);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new InternalError(noSuchAlgorithmException);
        }
    }

    public static SecureRandom newRandom() {
        return new SecureRandom();
    }

    private static Cipher newRSACipher(int n, RSAKey rSAKey) {
        Cipher cipher = SecurityHelper.newCipher(RSA_CIPHER_ALGO);
        try {
            cipher.init(n, (Key)((Object)rSAKey));
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new InternalError(invalidKeyException);
        }
        return cipher;
    }

    private static Cipher newAESCipher(int n, byte[] byArray) {
        Cipher cipher = SecurityHelper.newCipher(AES_CIPHER_ALGO);
        try {
            cipher.init(n, new SecretKeySpec(byArray, "AES"));
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new InternalError(invalidKeyException);
        }
        return cipher;
    }

    private static KeyFactory newECDSAKeyFactory() {
        try {
            return KeyFactory.getInstance(EC_ALGO);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new InternalError(noSuchAlgorithmException);
        }
    }

    private static KeyFactory newRSAKeyFactory() {
        try {
            return KeyFactory.getInstance(RSA_ALGO);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new InternalError(noSuchAlgorithmException);
        }
    }

    private static Signature newECSignature() {
        try {
            return Signature.getInstance(EC_SIGN_ALGO);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new InternalError(noSuchAlgorithmException);
        }
    }

    private static Signature newRSASignature() {
        try {
            return Signature.getInstance(RSA_SIGN_ALGO);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new InternalError(noSuchAlgorithmException);
        }
    }

    public static Signature newECSignSignature(ECPrivateKey eCPrivateKey) {
        Signature signature = SecurityHelper.newECSignature();
        try {
            signature.initSign(eCPrivateKey);
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new InternalError(invalidKeyException);
        }
        return signature;
    }

    public static Signature newRSASignSignature(RSAPrivateKey rSAPrivateKey) {
        Signature signature = SecurityHelper.newRSASignature();
        try {
            signature.initSign(rSAPrivateKey);
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new InternalError(invalidKeyException);
        }
        return signature;
    }

    public static Signature newECVerifySignature(ECPublicKey eCPublicKey) {
        Signature signature = SecurityHelper.newECSignature();
        try {
            signature.initVerify(eCPublicKey);
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new InternalError(invalidKeyException);
        }
        return signature;
    }

    public static Signature newRSAVerifySignature(RSAPublicKey rSAPublicKey) {
        Signature signature = SecurityHelper.newRSASignature();
        try {
            signature.initVerify(rSAPublicKey);
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new InternalError(invalidKeyException);
        }
        return signature;
    }

    public static byte[] randomBytes(int n) {
        return SecurityHelper.randomBytes(SecurityHelper.newRandom(), n);
    }

    public static byte[] randomBytes(Random random, int n) {
        byte[] byArray = new byte[n];
        random.nextBytes(byArray);
        return byArray;
    }

    public static String randomStringToken() {
        return SecurityHelper.randomStringToken(SecurityHelper.newRandom());
    }

    public static String randomStringToken(Random random) {
        return SecurityHelper.toHex(SecurityHelper.randomToken(random));
    }

    public static byte[] randomToken() {
        return SecurityHelper.randomToken(SecurityHelper.newRandom());
    }

    public static byte[] randomToken(Random random) {
        return SecurityHelper.randomBytes(random, 16);
    }

    public static String randomStringAESKey() {
        return SecurityHelper.toHex(SecurityHelper.randomAESKey(SecurityHelper.newRandom()));
    }

    public static String randomStringAESKey(Random random) {
        return SecurityHelper.toHex(SecurityHelper.randomAESKey(random));
    }

    public static byte[] randomAESKey() {
        return SecurityHelper.randomAESKey(SecurityHelper.newRandom());
    }

    public static byte[] randomAESKey(Random random) {
        return SecurityHelper.randomBytes(random, 16);
    }

    public static byte[] sign(byte[] byArray, ECPrivateKey eCPrivateKey) {
        Signature signature = SecurityHelper.newECSignSignature(eCPrivateKey);
        try {
            signature.update(byArray);
            return signature.sign();
        }
        catch (SignatureException signatureException) {
            throw new InternalError(signatureException);
        }
    }

    public static byte[] sign(byte[] byArray, RSAPrivateKey rSAPrivateKey) {
        Signature signature = SecurityHelper.newRSASignSignature(rSAPrivateKey);
        try {
            signature.update(byArray);
            return signature.sign();
        }
        catch (SignatureException signatureException) {
            throw new InternalError(signatureException);
        }
    }

    public static String toHex(byte[] byArray) {
        if (byArray == null) {
            return null;
        }
        int n = 0;
        char[] cArray = new char[byArray.length << 1];
        for (byte by : byArray) {
            int n2 = Byte.toUnsignedInt(by);
            cArray[n] = HEX.charAt(n2 >>> 4);
            cArray[++n] = HEX.charAt(n2 & 0xF);
            ++n;
        }
        return new String(cArray);
    }

    public static ECPublicKey toPublicECDSAKey(byte[] byArray) throws InvalidKeySpecException {
        return (ECPublicKey)SecurityHelper.newECDSAKeyFactory().generatePublic(new X509EncodedKeySpec(byArray));
    }

    public static ECPrivateKey toPrivateECDSAKey(byte[] byArray) throws InvalidKeySpecException {
        return (ECPrivateKey)SecurityHelper.newECDSAKeyFactory().generatePrivate(new PKCS8EncodedKeySpec(byArray));
    }

    public static RSAPublicKey toPublicRSAKey(byte[] byArray) throws InvalidKeySpecException {
        return (RSAPublicKey)SecurityHelper.newRSAKeyFactory().generatePublic(new X509EncodedKeySpec(byArray));
    }

    public static RSAPrivateKey toPrivateRSAKey(byte[] byArray) throws InvalidKeySpecException {
        return (RSAPrivateKey)SecurityHelper.newRSAKeyFactory().generatePrivate(new PKCS8EncodedKeySpec(byArray));
    }

    private static void updateSignature(InputStream inputStream, Signature signature) throws IOException {
        byte[] byArray = IOHelper.newBuffer();
        int n = inputStream.read(byArray);
        while (n >= 0) {
            try {
                signature.update(byArray, 0, n);
            }
            catch (SignatureException signatureException) {
                throw new InternalError(signatureException);
            }
            n = inputStream.read(byArray);
        }
    }

    public static void verifySign(byte[] byArray, byte[] byArray2, ECPublicKey eCPublicKey) throws SignatureException {
        if (!SecurityHelper.isValidSign(byArray, byArray2, eCPublicKey)) {
            throw new SignatureException("Invalid sign");
        }
    }

    public static void verifySign(InputStream inputStream, byte[] byArray, ECPublicKey eCPublicKey) throws SignatureException, IOException {
        if (!SecurityHelper.isValidSign(inputStream, byArray, eCPublicKey)) {
            throw new SignatureException("Invalid stream sign");
        }
    }

    public static void verifySign(byte[] byArray, byte[] byArray2, RSAPublicKey rSAPublicKey) throws SignatureException {
        if (!SecurityHelper.isValidSign(byArray, byArray2, rSAPublicKey)) {
            throw new SignatureException("Invalid sign");
        }
    }

    public static void verifySign(InputStream inputStream, byte[] byArray, RSAPublicKey rSAPublicKey) throws SignatureException, IOException {
        if (!SecurityHelper.isValidSign(inputStream, byArray, rSAPublicKey)) {
            throw new SignatureException("Invalid stream sign");
        }
    }

    public static String verifyToken(String string) {
        return VerifyHelper.verify(string, SecurityHelper::isValidToken, String.format("Invalid token: '%s'", string));
    }

    public static Cipher newRSADecryptCipher(RSAPrivateKey rSAPrivateKey) {
        try {
            return SecurityHelper.newRSACipher(2, rSAPrivateKey);
        }
        catch (SecurityException securityException) {
            throw new InternalError(securityException);
        }
    }

    public static Cipher newRSAEncryptCipher(RSAPublicKey rSAPublicKey) {
        try {
            return SecurityHelper.newRSACipher(1, rSAPublicKey);
        }
        catch (SecurityException securityException) {
            throw new InternalError(securityException);
        }
    }

    public static Cipher newAESDecryptCipher(byte[] byArray) {
        try {
            return SecurityHelper.newAESCipher(2, byArray);
        }
        catch (SecurityException securityException) {
            throw new InternalError(securityException);
        }
    }

    public static Cipher newAESEncryptCipher(byte[] byArray) {
        try {
            return SecurityHelper.newAESCipher(1, byArray);
        }
        catch (SecurityException securityException) {
            throw new InternalError(securityException);
        }
    }

    public static byte[] encrypt(String string, byte[] byArray) throws Exception {
        byte[] byArray2 = SecurityHelper.getAESKey(IOHelper.encode(string));
        return SecurityHelper.encrypt(byArray2, byArray);
    }

    public static byte[] encrypt(String string, String string2) throws Exception {
        return SecurityHelper.encrypt(string, IOHelper.encode(string2));
    }

    public static byte[] getAESKey(byte[] byArray) throws Exception {
        KeyGenerator keyGenerator = KeyGenerator.getInstance("AES");
        SecureRandom secureRandom = SecureRandom.getInstance("SHA1PRNG");
        secureRandom.setSeed(byArray);
        keyGenerator.init(128, secureRandom);
        SecretKey secretKey = keyGenerator.generateKey();
        return secretKey.getEncoded();
    }

    public static byte[] encrypt(byte[] byArray, byte[] byArray2) throws Exception {
        SecretKeySpec secretKeySpec = new SecretKeySpec(byArray, "AES");
        Cipher cipher = Cipher.getInstance("AES");
        cipher.init(1, secretKeySpec);
        return cipher.doFinal(byArray2);
    }

    public static byte[] decrypt(byte[] byArray, byte[] byArray2) throws Exception {
        SecretKeySpec secretKeySpec = new SecretKeySpec(byArray, "AES");
        Cipher cipher = Cipher.getInstance("AES");
        cipher.init(2, secretKeySpec);
        return cipher.doFinal(byArray2);
    }

    public static byte[] decrypt(String string, byte[] byArray) throws Exception {
        return SecurityHelper.decrypt(SecurityHelper.getAESKey(IOHelper.encode(string)), byArray);
    }

    public static byte[] fromHex(String string) {
        int n = string.length() / 2;
        byte[] byArray = new byte[n];
        for (int i = 0; i < n; ++i) {
            byArray[i] = Integer.valueOf(string.substring(2 * i, 2 * i + 2), 16).byteValue();
        }
        return byArray;
    }

    public static final class DigestAlgorithm
    extends Enum<DigestAlgorithm> {
        public static final /* enum */ DigestAlgorithm PLAIN = new DigestAlgorithm("plain", -1);
        public static final /* enum */ DigestAlgorithm MD5 = new DigestAlgorithm("MD5", 128);
        public static final /* enum */ DigestAlgorithm SHA1 = new DigestAlgorithm("SHA-1", 160);
        public static final /* enum */ DigestAlgorithm SHA224 = new DigestAlgorithm("SHA-224", 224);
        public static final /* enum */ DigestAlgorithm SHA256 = new DigestAlgorithm("SHA-256", 256);
        public static final /* enum */ DigestAlgorithm SHA512 = new DigestAlgorithm("SHA-512", 512);
        private static final Map<String, DigestAlgorithm> ALGORITHMS;
        public final String name;
        public final int bits;
        public final int bytes;
        private static final /* synthetic */ DigestAlgorithm[] $VALUES;

        public static DigestAlgorithm[] values() {
            return (DigestAlgorithm[])$VALUES.clone();
        }

        public static DigestAlgorithm valueOf(String string) {
            return Enum.valueOf(DigestAlgorithm.class, string);
        }

        private DigestAlgorithm(String string2, int n2) {
            this.name = string2;
            this.bits = n2;
            this.bytes = n2 / 8;
            assert (n2 % 8 == 0);
        }

        public static DigestAlgorithm byName(String string) {
            return VerifyHelper.getMapValue(ALGORITHMS, string, String.format("Unknown digest algorithm: '%s'", string));
        }

        public String toString() {
            return this.name;
        }

        public byte[] verify(byte[] byArray) {
            if (byArray.length != this.bytes) {
                throw new IllegalArgumentException("Invalid digest length: " + byArray.length);
            }
            return byArray;
        }

        private static /* synthetic */ DigestAlgorithm[] $values() {
            return new DigestAlgorithm[]{PLAIN, MD5, SHA1, SHA224, SHA256, SHA512};
        }

        static {
            $VALUES = DigestAlgorithm.$values();
            DigestAlgorithm[] digestAlgorithmArray = DigestAlgorithm.values();
            ALGORITHMS = new HashMap<String, DigestAlgorithm>(digestAlgorithmArray.length);
            for (DigestAlgorithm digestAlgorithm : digestAlgorithmArray) {
                ALGORITHMS.put(digestAlgorithm.name, digestAlgorithm);
            }
        }
    }
}

