/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.utils.launch;

import java.io.File;
import java.io.IOException;
import java.lang.instrument.ClassFileTransformer;
import java.lang.instrument.IllegalClassFormatException;
import java.lang.instrument.Instrumentation;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.ProtectionDomain;
import java.util.Collection;
import java.util.List;
import java.util.jar.JarFile;
import pro.gravit.utils.helper.HackHelper;
import pro.gravit.utils.helper.JVMHelper;
import pro.gravit.utils.launch.ClassLoaderControl;
import pro.gravit.utils.launch.Launch;
import pro.gravit.utils.launch.LaunchOptions;

public class BasicLaunch
implements Launch {
    private Instrumentation instrumentation;
    private MethodHandles.Lookup hackLookup;

    public BasicLaunch(Instrumentation instrumentation) {
        this.instrumentation = instrumentation;
    }

    public BasicLaunch() {
    }

    @Override
    public ClassLoaderControl init(List<Path> list, String string, LaunchOptions launchOptions) {
        if (launchOptions.enableHacks) {
            this.hackLookup = HackHelper.createHackLookup(BasicLaunch.class);
        }
        return new BasicClassLoaderControl();
    }

    @Override
    public void launch(String string, String string2, Collection<String> collection) throws Throwable {
        Class<?> clazz = Class.forName(string);
        MethodHandle methodHandle = MethodHandles.lookup().findStatic(clazz, "main", MethodType.methodType(Void.TYPE, String[].class)).asFixedArity();
        JVMHelper.fullGC();
        methodHandle.asFixedArity().invokeWithArguments(new Object[]{collection.toArray(new String[0])});
    }

    private class BasicClassLoaderControl
    implements ClassLoaderControl {
        private BasicClassLoaderControl() {
        }

        @Override
        public void addLauncherPackage(String string) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void clearLauncherPackages() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void addTransformer(final ClassLoaderControl.ClassTransformer classTransformer) {
            if (BasicLaunch.this.instrumentation == null) {
                throw new UnsupportedOperationException();
            }
            BasicLaunch.this.instrumentation.addTransformer(new ClassFileTransformer(){

                @Override
                public byte[] transform(ClassLoader classLoader, String string, Class<?> clazz, ProtectionDomain protectionDomain, byte[] byArray) throws IllegalClassFormatException {
                    if (classTransformer.filter(null, string)) {
                        return classTransformer.transform(null, string, protectionDomain, byArray);
                    }
                    return byArray;
                }
            });
        }

        @Override
        public void addURL(URL uRL) {
            if (BasicLaunch.this.instrumentation == null) {
                throw new UnsupportedOperationException();
            }
            try {
                BasicLaunch.this.instrumentation.appendToSystemClassLoaderSearch(new JarFile(new File(uRL.toURI())));
            }
            catch (IOException | URISyntaxException exception) {
                throw new RuntimeException(exception);
            }
        }

        @Override
        public void addJar(Path path) {
            if (BasicLaunch.this.instrumentation == null) {
                throw new UnsupportedOperationException();
            }
            try {
                BasicLaunch.this.instrumentation.appendToSystemClassLoaderSearch(new JarFile(path.toFile()));
            }
            catch (IOException iOException) {
                throw new RuntimeException(iOException);
            }
        }

        @Override
        public URL[] getURLs() {
            String string = System.getProperty("java.class.path");
            String[] stringArray = string.split(File.pathSeparator);
            URL[] uRLArray = new URL[stringArray.length];
            try {
                for (int i = 0; i < stringArray.length; ++i) {
                    uRLArray[i] = Paths.get(stringArray[i], new String[0]).toAbsolutePath().toUri().toURL();
                }
            }
            catch (MalformedURLException malformedURLException) {
                throw new RuntimeException(malformedURLException);
            }
            return uRLArray;
        }

        @Override
        public Class<?> getClass(String string) throws ClassNotFoundException {
            return Class.forName(string);
        }

        @Override
        public ClassLoader getClassLoader() {
            return BasicLaunch.class.getClassLoader();
        }

        @Override
        public Object getJava9ModuleController() {
            return null;
        }

        @Override
        public MethodHandles.Lookup getHackLookup() {
            return BasicLaunch.this.hackLookup;
        }
    }
}

