/*
 * Decompiled with CFR 0.152.
 */
package net.minecrell.terminalconsole;

import java.util.List;
import net.minecrell.terminalconsole.TerminalConsoleAppender;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.layout.PatternLayout;
import org.apache.logging.log4j.core.pattern.ConverterKeys;
import org.apache.logging.log4j.core.pattern.LogEventPatternConverter;
import org.apache.logging.log4j.core.pattern.PatternFormatter;
import org.apache.logging.log4j.core.pattern.PatternParser;
import org.apache.logging.log4j.util.PerformanceSensitive;
import org.apache.logging.log4j.util.PropertiesUtil;
import org.checkerframework.checker.nullness.qual.Nullable;

@Plugin(name="minecraftFormatting", category="Converter")
@ConverterKeys(value={"minecraftFormatting"})
@PerformanceSensitive(value={"allocation"})
public final class MinecraftFormattingConverter
extends LogEventPatternConverter {
    public static final String KEEP_FORMATTING_PROPERTY = "terminal.keepMinecraftFormatting";
    private static final boolean KEEP_FORMATTING = PropertiesUtil.getProperties().getBooleanProperty("terminal.keepMinecraftFormatting");
    static final String ANSI_RESET = "\u001b[m";
    private static final char COLOR_CHAR = '\u00a7';
    private static final String LOOKUP = "0123456789abcdefklmnor";
    private static final String[] ansiCodes = new String[]{"\u001b[0;30m", "\u001b[0;34m", "\u001b[0;32m", "\u001b[0;36m", "\u001b[0;31m", "\u001b[0;35m", "\u001b[0;33m", "\u001b[0;37m", "\u001b[0;30;1m", "\u001b[0;34;1m", "\u001b[0;32;1m", "\u001b[0;36;1m", "\u001b[0;31;1m", "\u001b[0;35;1m", "\u001b[0;33;1m", "\u001b[0;37;1m", "\u001b[5m", "\u001b[21m", "\u001b[9m", "\u001b[4m", "\u001b[3m", "\u001b[m"};
    private final boolean ansi;
    private final List<PatternFormatter> formatters;

    protected MinecraftFormattingConverter(List<PatternFormatter> formatters, boolean strip) {
        super("minecraftFormatting", null);
        this.formatters = formatters;
        this.ansi = !strip;
    }

    public void format(LogEvent event, StringBuilder toAppendTo) {
        int start = toAppendTo.length();
        int size = this.formatters.size();
        for (int i = 0; i < size; ++i) {
            this.formatters.get(i).format(event, toAppendTo);
        }
        if (KEEP_FORMATTING || toAppendTo.length() == start) {
            return;
        }
        String content = toAppendTo.substring(start);
        MinecraftFormattingConverter.format(content, toAppendTo, start, this.ansi && TerminalConsoleAppender.isAnsiSupported());
    }

    static void format(String s, StringBuilder result, int start, boolean ansi) {
        int next = s.indexOf(167);
        int last = s.length() - 1;
        if (next == -1 || next == last) {
            return;
        }
        result.setLength(start + next);
        int pos = next;
        do {
            int format;
            if ((format = LOOKUP.indexOf(Character.toLowerCase(s.charAt(next + 1)))) != -1) {
                if (pos != next) {
                    result.append(s, pos, next);
                }
                if (ansi) {
                    result.append(ansiCodes[format]);
                }
                pos = next += 2;
                continue;
            }
            ++next;
        } while ((next = s.indexOf(167, next)) != -1 && next < last);
        result.append(s, pos, s.length());
        if (ansi) {
            result.append(ANSI_RESET);
        }
    }

    public static @Nullable MinecraftFormattingConverter newInstance(Configuration config, String[] options) {
        if (options.length < 1 || options.length > 2) {
            LOGGER.error("Incorrect number of options on minecraftFormatting. Expected at least 1, max 2 received " + options.length);
            return null;
        }
        if (options[0] == null) {
            LOGGER.error("No pattern supplied on minecraftFormatting");
            return null;
        }
        PatternParser parser = PatternLayout.createPatternParser((Configuration)config);
        List formatters = parser.parse(options[0]);
        boolean strip = options.length > 1 && "strip".equals(options[1]);
        return new MinecraftFormattingConverter(formatters, strip);
    }
}

