/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.util.freetype;

import java.nio.ByteBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class FT_Data
extends Struct<FT_Data>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int POINTER;
    public static final int LENGTH;

    protected FT_Data(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    protected FT_Data create(long address, @Nullable ByteBuffer container) {
        return new FT_Data(address, container);
    }

    public FT_Data(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), FT_Data.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="FT_Byte const *")
    public ByteBuffer pointer() {
        return FT_Data.npointer(this.address());
    }

    @NativeType(value="FT_UInt")
    public int length() {
        return FT_Data.nlength(this.address());
    }

    public FT_Data pointer(@NativeType(value="FT_Byte const *") ByteBuffer value) {
        FT_Data.npointer(this.address(), value);
        return this;
    }

    public FT_Data set(FT_Data src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static FT_Data malloc() {
        return new FT_Data(MemoryUtil.nmemAllocChecked((long)SIZEOF), null);
    }

    public static FT_Data calloc() {
        return new FT_Data(MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF), null);
    }

    public static FT_Data create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return new FT_Data(MemoryUtil.memAddress((ByteBuffer)container), container);
    }

    public static FT_Data create(long address) {
        return new FT_Data(address, null);
    }

    public static @Nullable FT_Data createSafe(long address) {
        return address == 0L ? null : new FT_Data(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked((long)FT_Data.__checkMalloc((int)capacity, (int)SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = FT_Data.__create((int)capacity, (int)SIZEOF);
        return new Buffer(MemoryUtil.memAddress((ByteBuffer)container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static FT_Data malloc(MemoryStack stack) {
        return new FT_Data(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static FT_Data calloc(MemoryStack stack) {
        return new FT_Data(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static ByteBuffer npointer(long struct) {
        return MemoryUtil.memByteBuffer((long)MemoryUtil.memGetAddress((long)(struct + (long)POINTER)), (int)FT_Data.nlength(struct));
    }

    public static int nlength(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)LENGTH));
    }

    public static void npointer(long struct, ByteBuffer value) {
        MemoryUtil.memPutAddress((long)(struct + (long)POINTER), (long)MemoryUtil.memAddress((ByteBuffer)value));
        FT_Data.nlength(struct, value.remaining());
    }

    public static void nlength(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)LENGTH), (int)value);
    }

    public static void validate(long struct) {
        Checks.check((long)MemoryUtil.memGetAddress((long)(struct + (long)POINTER)));
    }

    static {
        Struct.Layout layout = FT_Data.__struct((Struct.Member[])new Struct.Member[]{FT_Data.__member((int)POINTER_SIZE), FT_Data.__member((int)4)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        POINTER = layout.offsetof(0);
        LENGTH = layout.offsetof(1);
    }

    public static class Buffer
    extends StructBuffer<FT_Data, Buffer>
    implements NativeResource {
        private static final FT_Data ELEMENT_FACTORY = FT_Data.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        protected FT_Data getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="FT_Byte const *")
        public ByteBuffer pointer() {
            return FT_Data.npointer(this.address());
        }

        @NativeType(value="FT_UInt")
        public int length() {
            return FT_Data.nlength(this.address());
        }

        public Buffer pointer(@NativeType(value="FT_Byte const *") ByteBuffer value) {
            FT_Data.npointer(this.address(), value);
            return this;
        }
    }
}

