/*
 * Decompiled with CFR 0.152.
 */
package com.dks.client;

import com.dks.client.DKSModConfig;
import com.dks.client.KeyMappingAccess;
import com.google.common.collect.ImmutableSet;
import com.kbp.client.impl.IKeyMappingImpl;
import com.mojang.blaze3d.platform.InputConstants;
import com.mojang.datafixers.util.Pair;
import java.io.File;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.Options;
import net.minecraft.client.gui.screens.ConfirmScreen;
import net.minecraft.network.chat.Component;
import net.minecraftforge.client.ConfigScreenHandler;
import net.minecraftforge.client.event.ScreenEvent;
import net.minecraftforge.client.extensions.IForgeKeyMapping;
import net.minecraftforge.client.settings.KeyModifier;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.IExtensionPoint;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.config.ModConfigEvent;
import net.minecraftforge.fml.util.ObfuscationReflectionHelper;

@Mod(value="default_key_setup")
@Mod.EventBusSubscriber
public final class DKSMod {
    private static void __saveDefaultKeySetup() {
        boolean has_kbp_mod = ModList.get().isLoaded("key_binding_patch");
        BiConsumer<KeyMapping, StringBuilder> append_value = has_kbp_mod ? (km, builder) -> builder.append(km.m_90865_()) : (km, builder) -> {
            builder.append(km.m_90865_());
            builder.append(':');
            builder.append(km.getKeyModifier());
        };
        Minecraft mc = Minecraft.m_91087_();
        DKSModConfig.DEFAULT_KEY_SETUP.set(Arrays.stream(mc.f_91066_.f_92059_).map(km -> {
            StringBuilder builder = new StringBuilder(km.m_90860_());
            builder.append('=');
            append_value.accept((KeyMapping)km, builder);
            return builder.toString();
        }).toList());
        DKSModConfig.DEFAULT_KEY_SETUP.save();
    }

    private static void __applyDefaultKeySetup() {
        boolean has_kbp_mod = ModList.get().isLoaded("key_binding_patch");
        Map<String, String> data = ((List)DKSModConfig.DEFAULT_KEY_SETUP.get()).stream().map(s -> {
            int idx = s.indexOf(61);
            String name = s.substring(0, idx);
            String value = s.substring(idx + 1);
            return Pair.of((Object)name, (Object)value);
        }).collect(Collectors.toMap(Pair::getFirst, Pair::getSecond));
        Minecraft mc = Minecraft.m_91087_();
        for (KeyMapping km : mc.f_91066_.f_92059_) {
            String value = data.get(km.m_90860_());
            if (value == null) continue;
            String[] split = value.split(":");
            InputConstants.Key key = InputConstants.m_84851_((String)split[0]);
            KeyModifier modifier = KeyModifier.valueFromString((String)split[1]);
            KeyMappingAccess._setDefaultKey(km, key);
            KeyMappingAccess._setKeyModifierDefault(km, modifier);
            if (!has_kbp_mod) continue;
            ImmutableSet cmb_keys = split.length > 2 ? (ImmutableSet)Arrays.stream(split[2].split("\\+")).map(InputConstants::m_84851_).collect(ImmutableSet.toImmutableSet()) : IKeyMappingImpl.toCmbKeySet((KeyModifier)modifier);
            KeyMappingAccess._setDefaultCmbKeys(km, (ImmutableSet<InputConstants.Key>)cmb_keys);
        }
    }

    @SubscribeEvent
    static void onConfigReload(ModConfigEvent.Reloading evt) {
        DKSMod.__applyDefaultKeySetup();
    }

    public DKSMod() {
        ModLoadingContext load_ctx = ModLoadingContext.get();
        load_ctx.registerExtensionPoint(IExtensionPoint.DisplayTest.class, () -> new IExtensionPoint.DisplayTest(() -> "This is a client only mod.", (remote_version_string, network_bool) -> network_bool));
        load_ctx.registerConfig(ModConfig.Type.CLIENT, (IConfigSpec)DKSModConfig.CONFIG_SPEC);
        load_ctx.registerExtensionPoint(ConfigScreenHandler.ConfigScreenFactory.class, () -> new ConfigScreenHandler.ConfigScreenFactory((mc, screen) -> new ConfirmScreen(result -> {
            if (result) {
                DKSMod.__saveDefaultKeySetup();
                DKSMod.__applyDefaultKeySetup();
            }
            mc.m_91152_(screen);
        }, (Component)Component.m_237115_((String)"dks.gui.warning_title"), (Component)Component.m_237115_((String)"dks.gui.warning_msg"))));
        MinecraftForge.EVENT_BUS.register(new Object(){

            @SubscribeEvent
            void onOpenGui(ScreenEvent.Opening evt) {
                Minecraft mc;
                boolean should_reset_km;
                if (((Boolean)DKSModConfig.FORCE_KEY_RESET.get()).booleanValue()) {
                    DKSModConfig.FORCE_KEY_RESET.set((Object)false);
                    DKSModConfig.FORCE_KEY_RESET.save();
                    should_reset_km = true;
                } else {
                    mc = Minecraft.m_91087_();
                    File file = (File)ObfuscationReflectionHelper.getPrivateValue(Options.class, (Object)mc.f_91066_, (String)"f_92110_");
                    should_reset_km = !Objects.requireNonNull(file).exists();
                }
                DKSMod.__applyDefaultKeySetup();
                if (should_reset_km) {
                    mc = Minecraft.m_91087_();
                    Arrays.stream(mc.f_91066_.f_92059_).forEachOrdered(IForgeKeyMapping::setToDefault);
                    KeyMapping.m_90854_();
                }
                MinecraftForge.EVENT_BUS.unregister((Object)this);
            }
        });
    }
}

