/*
 * Decompiled with CFR 0.152.
 */
package com.dks.client;

import java.util.List;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.ForgeConfigSpec;

@OnlyIn(value=Dist.CLIENT)
final class DKSModConfig {
    static final ForgeConfigSpec CONFIG_SPEC;
    static final ForgeConfigSpec.BooleanValue FORCE_KEY_RESET;
    static final ForgeConfigSpec.ConfigValue<List<? extends String>> DEFAULT_KEY_SETUP;

    private DKSModConfig() {
    }

    static {
        ForgeConfigSpec.Builder builder = new ForgeConfigSpec.Builder();
        FORCE_KEY_RESET = builder.comment(new String[]{"DKS mod relies on the existence of the options.txt file to detect whether it is a fresh", "startup of the game. But mods like Default Options will generate this file at the very", "beginning of the game startup, which makes this approach infeasible. So this option was", "introduced to force the key binding reset on next startup."}).define("force_key_reset", false);
        DEFAULT_KEY_SETUP = builder.comment(new String[]{"Current default setup for key bindings. It will be applied if option.txt does not exist.", "DO NOT TRY TO MODIFY THIS MANUALLY! USE THE CONFIG GUI IN GAME INSTEAD!"}).defineList("default_key_setup", List.of(), String.class::isInstance);
        CONFIG_SPEC = builder.build();
    }
}

