/*
 * Decompiled with CFR 0.152.
 */
package ru.mcsgg.cptools;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.logging.LogUtils;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.data.event.GatherDataEvent;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.loading.FMLEnvironment;
import net.minecraftforge.server.permission.events.PermissionGatherEvent;
import net.minecraftforge.server.permission.nodes.PermissionNode;
import org.slf4j.Logger;
import ru.mcsgg.cptools.client.config.ClientCasesConfig;
import ru.mcsgg.cptools.client.config.ClientImagesConfig;
import ru.mcsgg.cptools.client.service.image.ImageService;
import ru.mcsgg.cptools.client.service.socket.SocketService;
import ru.mcsgg.cptools.command.RootCommand;
import ru.mcsgg.cptools.data.LanguageProvider;
import ru.mcsgg.cptools.network.PacketHandler;

@Mod(value="cptools")
public class CPTools {
    public static final String MOD_ID = "cptools";
    private static final Logger LOGGER = LogUtils.getLogger();

    public CPTools() {
        ModLoadingContext context = ModLoadingContext.get();
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        IEventBus eventBus = MinecraftForge.EVENT_BUS;
        if (FMLEnvironment.dist.isClient()) {
            ClientImagesConfig.get().load(context);
            ClientCasesConfig.get().load(context);
        }
        modEventBus.addListener(this::commonSetup);
        modEventBus.addListener(this::clientSetup);
        modEventBus.addListener(this::registerDataProviders);
        eventBus.addListener(this::registerCommands);
        eventBus.addListener(this::registerPermissionNodes);
    }

    public static ResourceLocation rl(String path) {
        return new ResourceLocation(MOD_ID, path);
    }

    private void commonSetup(FMLCommonSetupEvent event) {
        PacketHandler.init();
    }

    private void clientSetup(FMLClientSetupEvent event) {
        ImageService.get().init();
        SocketService.get().init();
    }

    private void registerDataProviders(GatherDataEvent event) {
        DataGenerator generator = event.getGenerator();
        PackOutput packOutput = generator.getPackOutput();
        generator.addProvider(event.includeClient(), (DataProvider)new LanguageProvider(packOutput));
    }

    private void registerCommands(RegisterCommandsEvent event) {
        CommandDispatcher dispatcher = event.getDispatcher();
        RootCommand.register((CommandDispatcher<CommandSourceStack>)dispatcher);
    }

    private void registerPermissionNodes(PermissionGatherEvent.Nodes event) {
        RootCommand.registerPermissions(xva$0 -> event.addNodes(new PermissionNode[]{xva$0}));
    }
}

