/*
 * Decompiled with CFR 0.152.
 */
package ru.mcsgg.cptools.client.action;

import com.mojang.logging.LogUtils;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import org.apache.commons.codec.digest.DigestUtils;
import org.slf4j.Logger;
import ru.mcsgg.cptools.client.config.ClientImagesConfig;
import ru.mcsgg.cptools.client.renderer.ItemImageRenderer;
import ru.mcsgg.cptools.client.service.image.ImageService;
import ru.mcsgg.cptools.client.service.image.adapter.ImageAdapter;
import ru.mcsgg.cptools.client.util.ChatUtil;

public class UploadItemImagesAction {
    private static final Logger LOGGER = LogUtils.getLogger();
    private final List<ItemStack> stacks;
    private final boolean force;

    public UploadItemImagesAction(List<ItemStack> stacks) {
        this(stacks, false);
    }

    public UploadItemImagesAction(List<ItemStack> stacks, boolean force) {
        this.stacks = stacks;
        this.force = force;
    }

    public Map<Item, String> run() {
        IdentityHashMap<Item, String> result = new IdentityHashMap<Item, String>();
        Integer scale = (Integer)ClientImagesConfig.get().categoriesItemsScale.get();
        try (ImageAdapter imageAdapter = ImageService.get().newSession();
             ItemImageRenderer renderer = new ItemImageRenderer(scale);){
            for (ItemStack stack : this.stacks) {
                this.upload(stack, result, imageAdapter, renderer);
            }
        }
        catch (Exception e) {
            ChatUtil.sendError(Component.m_237115_((String)"ftp.cptools.operation.error"));
            LOGGER.error("Failed to upload image", (Throwable)e);
        }
        return result;
    }

    private void upload(ItemStack stack, Map<Item, String> result, ImageAdapter images, ItemImageRenderer renderer) throws Exception {
        if (result.containsKey(stack.m_41720_())) {
            return;
        }
        String fileName = this.getFileName(stack);
        String filePath = "%s/%s.png".formatted(ClientImagesConfig.get().categoriesItemsFolder.get(), fileName);
        String fileURL = "%s/%s".formatted(ClientImagesConfig.get().webBaseUrl.get(), filePath);
        if (images.exists(filePath) && !this.force) {
            ChatUtil.sendProgress(Component.m_237110_((String)"ftp.cptools.file.exists", (Object[])new Object[]{ChatUtil.link(filePath, fileURL)}));
            result.put(stack.m_41720_(), fileURL);
            return;
        }
        renderer.render(stack);
        if (images.upload(filePath, renderer.export())) {
            result.put(stack.m_41720_(), fileURL);
            ChatUtil.sendSuccess(Component.m_237110_((String)"ftp.cptools.file.uploaded", (Object[])new Object[]{ChatUtil.link(filePath, fileURL)}));
        } else {
            ChatUtil.sendError(Component.m_237110_((String)"ftp.cptools.file.cannot_upload", (Object[])new Object[]{filePath}));
            LOGGER.error("Failed to upload image to {}", (Object)filePath);
        }
    }

    private String getFileName(ItemStack stack) {
        ResourceLocation key = BuiltInRegistries.f_257033_.m_7981_((Object)stack.m_41720_());
        String nbt = stack.m_41782_() ? stack.m_41783_().toString() : "";
        String nbtMD5 = DigestUtils.md5Hex((String)nbt);
        return ((String)ClientImagesConfig.get().categoriesItemsFilename.get()).replace("%modid%", key.m_135827_()).replace("%itemid%", key.m_135815_()).replace("%itemnbt%", nbtMD5);
    }
}

