/*
 * Decompiled with CFR 0.152.
 */
package ru.mcsgg.cptools.client.action;

import com.mojang.logging.LogUtils;
import java.util.List;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;
import org.slf4j.Logger;
import ru.mcsgg.cptools.client.config.ClientImagesConfig;
import ru.mcsgg.cptools.client.renderer.InventoryImageRenderer;
import ru.mcsgg.cptools.client.service.image.ImageService;
import ru.mcsgg.cptools.client.service.image.adapter.ImageAdapter;
import ru.mcsgg.cptools.client.util.ChatUtil;
import ru.mcsgg.cptools.client.util.PositionedItemStack;

public class UploadKitImageAction {
    private static final Logger LOGGER = LogUtils.getLogger();
    private final List<ItemStack> stacks;
    private final String name;
    private final boolean force;

    public UploadKitImageAction(List<ItemStack> stacks, String name) {
        this(stacks, name, false);
    }

    public UploadKitImageAction(List<ItemStack> stacks, String name, boolean force) {
        this.stacks = stacks;
        this.name = name;
        this.force = force;
    }

    public void run() {
        Integer scale = (Integer)ClientImagesConfig.get().categoriesKitsScale.get();
        Integer maxColumns = (Integer)ClientImagesConfig.get().categoriesKitsMaxColumns.get();
        List<PositionedItemStack> positionedStacks = PositionedItemStack.wrap(this.stacks, maxColumns);
        int rows = positionedStacks.stream().mapToInt(PositionedItemStack::row).max().orElse(0);
        int cols = positionedStacks.stream().mapToInt(PositionedItemStack::col).max().orElse(0);
        try (ImageAdapter imageAdapter = ImageService.get().newSession();
             InventoryImageRenderer renderer = new InventoryImageRenderer(rows, cols, scale);){
            this.upload(positionedStacks, imageAdapter, renderer);
        }
        catch (Exception e) {
            ChatUtil.sendError(Component.m_237115_((String)"ftp.cptools.operation.error"));
            LOGGER.error("Failed to perform FTP operation", (Throwable)e);
        }
    }

    private void upload(List<PositionedItemStack> positionedStacks, ImageAdapter images, InventoryImageRenderer renderer) throws Exception {
        String filePath = "%s/%s.png".formatted(ClientImagesConfig.get().categoriesKitsFolder.get(), this.name);
        String fileURL = "%s/%s".formatted(ClientImagesConfig.get().webBaseUrl.get(), filePath);
        if (images.exists(filePath) && !this.force) {
            ChatUtil.sendProgress(Component.m_237110_((String)"ftp.cptools.file.exists", (Object[])new Object[]{ChatUtil.link(filePath, fileURL)}));
            return;
        }
        for (PositionedItemStack positionedStack : positionedStacks) {
            renderer.render(positionedStack.stack(), positionedStack.row(), positionedStack.col());
        }
        if (images.upload(filePath, renderer.export())) {
            ChatUtil.sendSuccess(Component.m_237110_((String)"ftp.cptools.file.uploaded", (Object[])new Object[]{ChatUtil.link(filePath, fileURL)}));
        } else {
            ChatUtil.sendError(Component.m_237110_((String)"ftp.cptools.file.cannot_upload", (Object[])new Object[]{filePath}));
            LOGGER.error("Failed to upload image to {}", (Object)filePath);
        }
    }
}

