/*
 * Decompiled with CFR 0.152.
 */
package ru.mcsgg.cptools.client.renderer;

import com.mojang.blaze3d.pipeline.TextureTarget;
import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.platform.NativeImage;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.VertexSorting;
import java.io.IOException;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.FogRenderer;
import org.joml.Matrix4f;

public abstract class ImageRenderer
implements AutoCloseable {
    protected final int width;
    protected final int height;
    protected final int scale;
    protected final Minecraft client;
    protected final GuiGraphics guiGraphics;
    private final NativeImage nativeImage;
    private final TextureTarget fb;
    private final Matrix4f ogProjectionMatrix;

    ImageRenderer(int width, int height, int scale) {
        this.width = width;
        this.height = height;
        this.scale = scale;
        this.nativeImage = new NativeImage(width * scale, height * scale, true);
        this.fb = new TextureTarget(width * scale, height * scale, true, Minecraft.f_91002_);
        this.fb.m_83931_(0.0f, 0.0f, 0.0f, 0.0f);
        this.fb.m_83954_(Minecraft.f_91002_);
        this.client = Minecraft.m_91087_();
        this.guiGraphics = new GuiGraphics(this.client, this.client.m_91269_().m_110104_());
        this.ogProjectionMatrix = this.setupState();
    }

    @Override
    public void close() {
        this.clearState(this.ogProjectionMatrix);
        this.nativeImage.close();
        this.fb.m_83930_();
    }

    public void render(Runnable r) {
        this.render(r, true);
    }

    public void render(Runnable r, boolean clear) {
        this.fb.m_83947_(true);
        if (clear) {
            RenderSystem.clear((int)16640, (boolean)false);
        }
        r.run();
        this.fb.m_83970_();
    }

    public byte[] export() {
        this.fb.m_83956_();
        this.nativeImage.m_85045_(0, false);
        this.nativeImage.m_85122_();
        this.fb.m_83963_();
        try {
            return this.nativeImage.m_85121_();
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to encode image", e);
        }
    }

    private Matrix4f setupState() {
        Matrix4f projectionMatrix = RenderSystem.getProjectionMatrix();
        RenderSystem.setProjectionMatrix((Matrix4f)new Matrix4f().setOrtho(0.0f, (float)this.width, (float)this.height, 0.0f, 1000.0f, 21000.0f), (VertexSorting)VertexSorting.f_276633_);
        RenderSystem.getModelViewStack().m_85836_();
        RenderSystem.getModelViewStack().m_166856_();
        RenderSystem.getModelViewStack().m_252880_(0.0f, 0.0f, -11000.0f);
        RenderSystem.applyModelViewMatrix();
        Lighting.m_84931_();
        FogRenderer.m_109017_();
        return projectionMatrix;
    }

    private void clearState(Matrix4f projectionMatrix) {
        RenderSystem.setProjectionMatrix((Matrix4f)projectionMatrix, (VertexSorting)VertexSorting.f_276633_);
        RenderSystem.getModelViewStack().m_85849_();
        RenderSystem.applyModelViewMatrix();
    }
}

