/*
 * Decompiled with CFR 0.152.
 */
package ru.mcsgg.cptools.client.service.image.adapter;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.net.ftp.FTPClient;
import ru.mcsgg.cptools.client.config.ClientImagesConfig;
import ru.mcsgg.cptools.client.service.image.adapter.ImageAdapter;

public class FTPImageAdapter
implements ImageAdapter {
    private FTPClient client;

    @Override
    public void connect() throws Exception {
        this.client = new FTPClient();
        this.client.connect((String)ClientImagesConfig.get().adaptersFtpHost.get(), ((Integer)ClientImagesConfig.get().adaptersFtpPort.get()).intValue());
        this.client.login((String)ClientImagesConfig.get().adaptersFtpUser.get(), (String)ClientImagesConfig.get().adaptersFtpPass.get());
        this.client.enterLocalPassiveMode();
        this.client.setFileType(2);
    }

    @Override
    public boolean exists(String path) throws Exception {
        return this.client.listFiles(path).length > 0;
    }

    @Override
    public boolean upload(String path, byte[] data) throws Exception {
        this.createDirectories(path.substring(0, path.lastIndexOf(47)));
        try (ByteArrayInputStream stream = new ByteArrayInputStream(data);){
            boolean bl = this.client.storeFile(path, (InputStream)stream);
            return bl;
        }
    }

    @Override
    public void close() throws IOException {
        this.client.disconnect();
    }

    private void createDirectories(String path) throws Exception {
        String[] folders;
        String previous = this.client.printWorkingDirectory();
        if (this.client.changeWorkingDirectory(path)) {
            this.client.changeWorkingDirectory(previous);
            return;
        }
        for (String folder : folders = path.split("/")) {
            if (this.client.changeWorkingDirectory(folder)) continue;
            this.client.makeDirectory(folder);
            this.client.changeWorkingDirectory(folder);
        }
        this.client.changeWorkingDirectory("/");
    }
}

