/*
 * Decompiled with CFR 0.152.
 */
package ru.mcsgg.cptools.client.service.image.adapter;

import com.jcraft.jsch.ChannelSftp;
import com.jcraft.jsch.JSch;
import com.jcraft.jsch.Session;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import ru.mcsgg.cptools.client.config.ClientImagesConfig;
import ru.mcsgg.cptools.client.service.image.adapter.ImageAdapter;

public class SFTPImageAdapter
implements ImageAdapter {
    private Session session;
    private ChannelSftp channel;

    @Override
    public void connect() throws Exception {
        this.session = new JSch().getSession((String)ClientImagesConfig.get().adaptersSftpUser.get(), (String)ClientImagesConfig.get().adaptersSftpHost.get(), ((Integer)ClientImagesConfig.get().adaptersSftpPort.get()).intValue());
        this.session.setConfig("StrictHostKeyChecking", "no");
        this.session.setPassword((String)ClientImagesConfig.get().adaptersSftpPass.get());
        this.session.connect();
        this.channel = (ChannelSftp)this.session.openChannel("sftp");
        this.channel.connect();
    }

    @Override
    public boolean exists(String path) {
        try {
            return this.channel.stat(path) != null;
        }
        catch (Exception e) {
            return false;
        }
    }

    @Override
    public boolean upload(String path, byte[] data) throws Exception {
        this.createDirectories(path.substring(0, path.lastIndexOf(47)));
        try (ByteArrayInputStream stream = new ByteArrayInputStream(data);){
            this.channel.put((InputStream)stream, "/" + path);
            boolean bl = true;
            return bl;
        }
    }

    @Override
    public void close() {
        this.channel.disconnect();
        this.session.disconnect();
    }

    private void createDirectories(String path) throws Exception {
        if (this.exists(path)) {
            return;
        }
        String[] folders = path.split("/");
        StringBuilder subpath = new StringBuilder();
        for (String folder : folders) {
            subpath.append("/").append(folder);
            if (this.exists(subpath.toString())) continue;
            this.channel.mkdir(subpath.toString());
        }
    }
}

