/*
 * Decompiled with CFR 0.152.
 */
package ru.mcsgg.cptools.client.service.socket;

import com.mojang.logging.LogUtils;
import net.minecraft.network.chat.Component;
import org.java_websocket.server.WebSocketServer;
import org.slf4j.Logger;
import ru.mcsgg.cptools.client.dto.Dto;
import ru.mcsgg.cptools.client.service.socket.SocketServer;
import ru.mcsgg.cptools.client.util.ChatUtil;

public class SocketService {
    private static final SocketService INSTANCE = new SocketService();
    private static final Logger LOGGER = LogUtils.getLogger();
    private final WebSocketServer socketServer = new SocketServer(51791);

    private SocketService() {
    }

    public static SocketService get() {
        return INSTANCE;
    }

    public void init() {
        try {
            this.socketServer.start();
        }
        catch (Exception e) {
            LOGGER.error("Unable to start socket server", (Throwable)e);
        }
    }

    public void send(Dto dto) {
        if (this.socketServer.getConnections().isEmpty()) {
            ChatUtil.sendError(Component.m_237115_((String)"socket.cptools.connection.not_connected"));
            return;
        }
        this.socketServer.broadcast(dto.toJson());
        ChatUtil.sendSuccess(Component.m_237115_((String)"socket.cptools.message.sent"));
    }
}

