/*
 * Decompiled with CFR 0.152.
 */
package ru.mcsgg.cptools.command;

import com.mojang.brigadier.Message;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import java.util.List;
import java.util.Optional;
import java.util.stream.IntStream;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.items.IItemHandler;
import ru.mcsgg.cptools.network.PacketHandler;
import ru.mcsgg.cptools.network.packet.UploadItemImagePacket;
import ru.mcsgg.cptools.network.packet.UploadKitImagePacket;
import ru.mcsgg.cptools.util.RayTracingUtil;

public class ImagesSubCommands {
    private static final SimpleCommandExceptionType ERROR_HAND_EMPTY = new SimpleCommandExceptionType((Message)Component.m_237115_((String)"command.cptools.hand_empty"));
    private static final SimpleCommandExceptionType ERROR_NO_CONTAINER = new SimpleCommandExceptionType((Message)Component.m_237115_((String)"command.cptools.no_container"));

    private ImagesSubCommands() {
    }

    public static int handleUploadItem(CommandContext<CommandSourceStack> context, boolean force) throws CommandSyntaxException {
        ServerPlayer player = ((CommandSourceStack)context.getSource()).m_81375_();
        ItemStack stack = player.m_21205_();
        if (stack.m_41619_()) {
            throw ERROR_HAND_EMPTY.create();
        }
        PacketHandler.sendTo(player, new UploadItemImagePacket(stack, force));
        return 1;
    }

    public static int handleUploadKit(CommandContext<CommandSourceStack> context, String name, boolean force) throws CommandSyntaxException {
        ServerPlayer player = ((CommandSourceStack)context.getSource()).m_81375_();
        Level level = player.m_9236_();
        BlockHitResult hitResult = RayTracingUtil.tracePOVHitResult((Player)player);
        if (hitResult.m_6662_() == HitResult.Type.MISS) {
            throw ERROR_NO_CONTAINER.create();
        }
        BlockPos pos = hitResult.m_82425_();
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity == null) {
            throw ERROR_NO_CONTAINER.create();
        }
        Optional maybeHandler = blockEntity.getCapability(ForgeCapabilities.ITEM_HANDLER, null).resolve();
        if (maybeHandler.isEmpty()) {
            throw ERROR_NO_CONTAINER.create();
        }
        IItemHandler handler = (IItemHandler)maybeHandler.get();
        List<ItemStack> stacks = IntStream.range(0, handler.getSlots()).mapToObj(arg_0 -> ((IItemHandler)handler).getStackInSlot(arg_0)).toList();
        PacketHandler.sendTo(player, new UploadKitImagePacket(stacks, name, force));
        return 1;
    }
}

