/*
 * Decompiled with CFR 0.152.
 */
package ru.mcsgg.cptools.network;

import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.network.NetworkRegistry;
import net.minecraftforge.network.PacketDistributor;
import net.minecraftforge.network.simple.SimpleChannel;
import ru.mcsgg.cptools.CPTools;
import ru.mcsgg.cptools.network.packet.CasesAddItemPacket;
import ru.mcsgg.cptools.network.packet.ItemsAddItemPacket;
import ru.mcsgg.cptools.network.packet.UploadItemImagePacket;
import ru.mcsgg.cptools.network.packet.UploadKitImagePacket;

public class PacketHandler {
    private static final String PROTOCOL_VERSION = "1";
    private static final SimpleChannel CHANNEL = NetworkRegistry.newSimpleChannel((ResourceLocation)CPTools.rl("main"), () -> "1", "1"::equals, "1"::equals);
    private static int packetId = 0;

    private PacketHandler() {
    }

    public static void init() {
        PacketHandler.registerClientboundPackets();
        PacketHandler.registerServerboundPackets();
    }

    private static void registerClientboundPackets() {
        CHANNEL.registerMessage(++packetId, CasesAddItemPacket.class, CasesAddItemPacket::encode, CasesAddItemPacket::new, CasesAddItemPacket::handle);
        CHANNEL.registerMessage(++packetId, ItemsAddItemPacket.class, ItemsAddItemPacket::encode, ItemsAddItemPacket::new, ItemsAddItemPacket::handle);
        CHANNEL.registerMessage(++packetId, UploadItemImagePacket.class, UploadItemImagePacket::encode, UploadItemImagePacket::new, UploadItemImagePacket::handle);
        CHANNEL.registerMessage(++packetId, UploadKitImagePacket.class, UploadKitImagePacket::encode, UploadKitImagePacket::new, UploadKitImagePacket::handle);
    }

    private static void registerServerboundPackets() {
    }

    public static void sendTo(ServerPlayer player, Object packet) {
        CHANNEL.send(PacketDistributor.PLAYER.with(() -> player), packet);
    }
}

