/*
 * Decompiled with CFR 0.152.
 */
package ru.mcsgg.cptools.network.packet;

import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.network.NetworkEvent;
import ru.mcsgg.cptools.client.action.AddCaseItemAction;

public class CasesAddItemPacket {
    private final ItemStack stack;
    private final int rarity;
    private final int chance;
    private final int sort;

    public CasesAddItemPacket(ItemStack stack, int rarity, int chance, int sort) {
        this.stack = stack;
        this.rarity = rarity;
        this.chance = chance;
        this.sort = sort;
    }

    public CasesAddItemPacket(FriendlyByteBuf buf) {
        this.stack = buf.m_130267_();
        this.rarity = buf.readInt();
        this.chance = buf.readInt();
        this.sort = buf.readInt();
    }

    public void encode(FriendlyByteBuf buf) {
        buf.writeItemStack(this.stack, false);
        buf.writeInt(this.rarity);
        buf.writeInt(this.chance);
        buf.writeInt(this.sort);
    }

    public void handle(Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> new AddCaseItemAction(this.stack, this.rarity, this.chance, this.sort).run());
        ctx.get().setPacketHandled(true);
    }
}

