/*
 * Decompiled with CFR 0.152.
 */
package ru.mcsgg.cptools.network.packet;

import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.network.NetworkEvent;
import ru.mcsgg.cptools.client.action.AddItemAction;

public class ItemsAddItemPacket {
    private final ItemStack stack;
    private final int price;
    private final int sort;

    public ItemsAddItemPacket(ItemStack stack, int price, int sort) {
        this.stack = stack;
        this.price = price;
        this.sort = sort;
    }

    public ItemsAddItemPacket(FriendlyByteBuf buf) {
        this.stack = buf.m_130267_();
        this.price = buf.readInt();
        this.sort = buf.readInt();
    }

    public void encode(FriendlyByteBuf buf) {
        buf.writeItemStack(this.stack, false);
        buf.writeInt(this.price);
        buf.writeInt(this.sort);
    }

    public void handle(Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> new AddItemAction(this.stack, this.price, this.sort).run());
        ctx.get().setPacketHandled(true);
    }
}

