/*
 * Decompiled with CFR 0.152.
 */
package team.chisel.ctm.client.util;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import org.jetbrains.annotations.Nullable;
import team.chisel.ctm.client.newctm.LocalDirection;
import team.chisel.ctm.client.util.Dir;

@ParametersAreNonnullByDefault
public enum ConnectionLocations {
    UP(Dir.TOP),
    DOWN(Dir.BOTTOM),
    NORTH(Direction.EAST, Dir.RIGHT),
    SOUTH(Direction.EAST, Dir.LEFT),
    EAST(Dir.RIGHT),
    WEST(Dir.LEFT),
    NORTH_EAST(Direction.UP, Dir.TOP_RIGHT),
    NORTH_WEST(Direction.UP, Dir.TOP_LEFT),
    SOUTH_EAST(Direction.UP, Dir.BOTTOM_RIGHT),
    SOUTH_WEST(Direction.UP, Dir.BOTTOM_LEFT),
    NORTH_UP(Direction.EAST, Dir.TOP_RIGHT),
    NORTH_DOWN(Direction.EAST, Dir.BOTTOM_RIGHT),
    SOUTH_UP(Direction.EAST, Dir.TOP_LEFT),
    SOUTH_DOWN(Direction.EAST, Dir.BOTTOM_LEFT),
    EAST_UP(Dir.TOP_RIGHT),
    EAST_DOWN(Dir.BOTTOM_RIGHT),
    WEST_UP(Dir.TOP_LEFT),
    WEST_DOWN(Dir.BOTTOM_LEFT),
    NORTH_EAST_UP(Direction.EAST, Dir.TOP_RIGHT, true),
    NORTH_EAST_DOWN(Direction.EAST, Dir.BOTTOM_RIGHT, true),
    SOUTH_EAST_UP(Direction.EAST, Dir.TOP_LEFT, true),
    SOUTH_EAST_DOWN(Direction.EAST, Dir.BOTTOM_LEFT, true),
    SOUTH_WEST_UP(Direction.WEST, Dir.TOP_LEFT, true),
    SOUTH_WEST_DOWN(Direction.WEST, Dir.BOTTOM_LEFT, true),
    NORTH_WEST_UP(Direction.WEST, Dir.TOP_RIGHT, true),
    NORTH_WEST_DOWN(Direction.WEST, Dir.BOTTOM_RIGHT, true),
    UP_UP(Direction.UP, null, true),
    DOWN_DOWN(Direction.DOWN, null, true),
    NORTH_NORTH(Direction.NORTH, null, true),
    SOUTH_SOUTH(Direction.SOUTH, null, true),
    EAST_EAST(Direction.EAST, null, true),
    WEST_WEST(Direction.WEST, null, true);

    public static final ConnectionLocations[] VALUES;
    private final Direction normal;
    @Nullable
    private final LocalDirection dir;
    private final boolean offset;

    private ConnectionLocations(LocalDirection dir) {
        this(Direction.SOUTH, dir);
    }

    private ConnectionLocations(Direction normal, LocalDirection dir) {
        this(normal, dir, false);
    }

    private ConnectionLocations(Direction normal, LocalDirection dir, boolean offset) {
        this.normal = normal;
        this.dir = dir;
        this.offset = offset;
    }

    @Nullable
    public LocalDirection getDirForSide(Direction facing) {
        return this.dir == null ? null : this.dir.relativize(facing);
    }

    @Nullable
    public Direction clipOrDestroy(Direction direction) {
        throw new UnsupportedOperationException();
    }

    public BlockPos transform(BlockPos pos) {
        pos = this.dir != null ? pos.m_121955_((Vec3i)this.dir.getOffset(this.normal)) : pos.m_121945_(this.normal);
        if (this.offset) {
            pos = pos.m_121945_(this.normal);
        }
        return pos;
    }

    public static ConnectionLocations fromFacing(Direction facing) {
        return switch (facing) {
            default -> throw new IncompatibleClassChangeError();
            case Direction.NORTH -> NORTH;
            case Direction.SOUTH -> SOUTH;
            case Direction.EAST -> EAST;
            case Direction.WEST -> WEST;
            case Direction.UP -> UP;
            case Direction.DOWN -> DOWN;
        };
    }

    public static Direction toFacing(ConnectionLocations loc) {
        return switch (loc) {
            case NORTH -> Direction.NORTH;
            case SOUTH -> Direction.SOUTH;
            case EAST -> Direction.EAST;
            case WEST -> Direction.WEST;
            case UP -> Direction.UP;
            case DOWN -> Direction.DOWN;
            default -> Direction.NORTH;
        };
    }

    public static List<ConnectionLocations> decode(long data) {
        ArrayList<ConnectionLocations> list = new ArrayList<ConnectionLocations>();
        for (ConnectionLocations loc : ConnectionLocations.values()) {
            if ((1L & data >> loc.ordinal()) == 0L) continue;
            list.add(loc);
        }
        return list;
    }

    public long getMask() {
        return 1L << this.ordinal();
    }

    static {
        VALUES = ConnectionLocations.values();
    }
}

