/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.cadmus;

import com.teamresourceful.resourcefullib.common.utils.modinfo.ModInfoUtils;
import earth.terrarium.cadmus.api.claims.maxclaims.MaxClaimProviderApi;
import earth.terrarium.cadmus.api.teams.TeamProviderApi;
import earth.terrarium.cadmus.client.CadmusClient;
import earth.terrarium.cadmus.common.claims.CadmusDataHandler;
import earth.terrarium.cadmus.common.claims.ClaimHandler;
import earth.terrarium.cadmus.common.claims.ClaimType;
import earth.terrarium.cadmus.common.claims.admin.ModFlags;
import earth.terrarium.cadmus.common.claims.maxclaims.CadmusMaxClaimProvider;
import earth.terrarium.cadmus.common.compat.prometheus.PrometheusIntegration;
import earth.terrarium.cadmus.common.network.NetworkHandler;
import earth.terrarium.cadmus.common.teams.VanillaTeamProvider;
import earth.terrarium.cadmus.common.util.AdminUtils;
import earth.terrarium.cadmus.common.util.ModGameRules;
import earth.terrarium.cadmus.common.util.ModUtils;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.block.Block;

public class Cadmus {
    public static final String MOD_ID = "cadmus";
    public static final ResourceLocation DEFAULT_ID = new ResourceLocation("cadmus", "default");
    public static int FORCE_LOADED_CHUNK_COUNT;
    public static final TagKey<Block> ALLOWS_CLAIM_INTERACTIONS;
    public static final TagKey<Item> ALLOWS_CLAIM_PICKUP;
    public static final TagKey<Block> INTERACTABLE_STORAGE;
    public static final TagKey<Block> REDSTONE;
    public static final TagKey<Block> DOOR_LIKE;

    public static void init() {
        NetworkHandler.init();
        TeamProviderApi.API.register(DEFAULT_ID, new VanillaTeamProvider());
        MaxClaimProviderApi.API.register(DEFAULT_ID, new CadmusMaxClaimProvider());
        ModGameRules.init();
        ModFlags.init();
        if (!ModInfoUtils.isModLoaded((String)"argonauts")) {
            TeamProviderApi.API.setSelected(DEFAULT_ID);
        }
        if (PrometheusIntegration.prometheusLoaded()) {
            PrometheusIntegration.register();
        } else {
            MaxClaimProviderApi.API.setSelected(DEFAULT_ID);
        }
    }

    public static void enterChunkSection(Player player, ChunkPos pos) {
        if (player.m_9236_().m_5776_()) {
            CadmusClient.enterChunkSection();
        } else {
            ModUtils.displayTeamName((ServerPlayer)player, pos);
            AdminUtils.checkAccess((ServerPlayer)player, pos);
        }
    }

    public static void serverStarted(MinecraftServer server) {
        FORCE_LOADED_CHUNK_COUNT = 0;
        server.m_129785_().forEach(level -> ClaimHandler.getAllTeamClaims(level).forEach((id, data) -> data.forEach((pos, type) -> {
            if (type == ClaimType.CHUNK_LOADED) {
                ++FORCE_LOADED_CHUNK_COUNT;
                level.m_7726_().m_6692_(pos, true);
            }
        })));
        CadmusDataHandler.read(server);
    }

    static {
        ALLOWS_CLAIM_INTERACTIONS = TagKey.m_203882_((ResourceKey)Registries.f_256747_, (ResourceLocation)new ResourceLocation(MOD_ID, "allows_claim_interactions"));
        ALLOWS_CLAIM_PICKUP = TagKey.m_203882_((ResourceKey)Registries.f_256913_, (ResourceLocation)new ResourceLocation(MOD_ID, "allows_claim_pickup"));
        INTERACTABLE_STORAGE = TagKey.m_203882_((ResourceKey)Registries.f_256747_, (ResourceLocation)new ResourceLocation(MOD_ID, "interactable_storage"));
        REDSTONE = TagKey.m_203882_((ResourceKey)Registries.f_256747_, (ResourceLocation)new ResourceLocation(MOD_ID, "redstone"));
        DOOR_LIKE = TagKey.m_203882_((ResourceKey)Registries.f_256747_, (ResourceLocation)new ResourceLocation(MOD_ID, "door_like"));
    }
}

