/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.cadmus.client.claims;

import com.mojang.blaze3d.platform.NativeImage;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.teamresourceful.resourcefullib.client.CloseablePoseStack;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.resources.ResourceLocation;
import org.joml.Matrix4f;

public class ClaimMapRenderer {
    private static final ResourceLocation TEXTURE = new ResourceLocation("cadmus", "claimmaptextures");

    public ClaimMapRenderer(int[][] colors, int scale) {
        TextureManager textureManager = Minecraft.m_91087_().m_91097_();
        DynamicTexture dynamicTexture = new DynamicTexture(scale, scale, true);
        textureManager.m_118495_(TEXTURE, (AbstractTexture)dynamicTexture);
        this.updateTexture(dynamicTexture, colors, scale);
    }

    private void updateTexture(DynamicTexture texture, int[][] colors, int scale) {
        NativeImage nativeImage = texture.m_117991_();
        if (nativeImage == null) {
            return;
        }
        for (int i = 0; i < scale; ++i) {
            for (int j = 0; j < scale; ++j) {
                nativeImage.m_84988_(i, j, colors[i][j]);
            }
        }
        texture.m_117985_();
    }

    public void render(GuiGraphics graphics, int width, int height, int size) {
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)TEXTURE);
        RenderSystem.setShader(GameRenderer::m_172817_);
        BufferBuilder builder = Tesselator.m_85913_().m_85915_();
        try (CloseablePoseStack pose = new CloseablePoseStack(graphics);){
            pose.m_85837_((double)((float)width / 2.0f - (float)size / 2.0f), (double)((float)height / 2.0f - (float)size / 2.0f), 1.0);
            Matrix4f matrix4f = pose.m_85850_().m_252922_();
            builder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85817_);
            builder.m_252986_(matrix4f, 0.0f, (float)size, -0.01f).m_7421_(0.0f, 1.0f).m_5752_();
            builder.m_252986_(matrix4f, (float)size, (float)size, -0.01f).m_7421_(1.0f, 1.0f).m_5752_();
            builder.m_252986_(matrix4f, (float)size, 0.0f, -0.01f).m_7421_(1.0f, 0.0f).m_5752_();
            builder.m_252986_(matrix4f, 0.0f, 0.0f, -0.01f).m_7421_(0.0f, 0.0f).m_5752_();
            BufferUploader.m_231202_((BufferBuilder.RenderedBuffer)builder.m_231175_());
        }
    }
}

