/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.cadmus.client.claims;

import earth.terrarium.cadmus.client.claims.ClaimMapPalette;
import net.minecraft.Optionull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.BiomeColors;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.SectionPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.MapColor;

public class ClaimMapTopologyAlgorithm {
    public static final int BRIGHTER_COLOR = -16579837;

    public static int[][] setColors(int minX, int minZ, int maxX, int maxZ, ClientLevel level, Player player) {
        int[][] colors = new int[maxX - minX][maxZ - minZ];
        BlockPos.MutableBlockPos pos1 = new BlockPos.MutableBlockPos();
        BlockPos.MutableBlockPos pos2 = new BlockPos.MutableBlockPos();
        for (int x = minX; x < maxX; ++x) {
            pos1.m_142451_(x);
            double depth = 0.0;
            for (int z = minZ - 1; z < maxZ; ++z) {
                double darkness;
                double fluidDepth = 0.0;
                pos1.m_142443_(z);
                LevelChunk chunk = level.m_6325_(SectionPos.m_123171_((int)x), SectionPos.m_123171_((int)z));
                if (chunk.m_6430_()) continue;
                MapColor color = MapColor.f_283808_;
                double yDiff = 0.0;
                int y = level.m_6042_().f_63856_() ? ClaimMapTopologyAlgorithm.findBlockWithAirAbove(level, new BlockPos(x, player.m_146904_(), z)) : chunk.m_5885_(Heightmap.Types.WORLD_SURFACE, x, z) + 1;
                BlockState state = null;
                if (y > level.m_141937_() + 1) {
                    do {
                        pos1.m_142448_(--y);
                    } while (!ClaimMapTopologyAlgorithm.shouldRender(state = chunk.m_8055_((BlockPos)pos1), (Level)level, (BlockPos)pos1) && y > level.m_141937_());
                    if (y > level.m_141937_() && !state.m_60819_().m_76178_()) {
                        BlockState blockState2;
                        int y2 = y - 1;
                        pos2.m_122190_((Vec3i)pos1);
                        do {
                            pos2.m_142448_(y2--);
                            blockState2 = chunk.m_8055_((BlockPos)pos2);
                            fluidDepth += 1.0;
                        } while (y2 > level.m_141937_() && !blockState2.m_60819_().m_76178_());
                        state = ClaimMapTopologyAlgorithm.getCorrectStateForFluidBlock((Level)level, state, (BlockPos)pos1);
                    }
                    yDiff += (double)y;
                    color = (MapColor)Optionull.m_269278_((Object)state, b -> b.m_284242_((BlockGetter)level, (BlockPos)pos1), (Object)MapColor.f_283808_);
                }
                MapColor.Brightness brightness = color == MapColor.f_283864_ ? ((darkness = (fluidDepth /= 2.5) * 0.1 + (double)(x + z & 1) * 0.2) < 0.5 ? MapColor.Brightness.LOW : (darkness > 0.9 ? MapColor.Brightness.HIGH : MapColor.Brightness.NORMAL)) : ((darkness = (yDiff - depth) * 4.0 / 5.0 + ((double)(x + z & 1) - 0.5) * 0.4) > 0.6 ? MapColor.Brightness.HIGH : (darkness < -0.6 ? MapColor.Brightness.LOW : MapColor.Brightness.NORMAL));
                depth = yDiff;
                if (z == minZ - 1) continue;
                colors[x - minX][z - minZ] = ClaimMapTopologyAlgorithm.getTintShade(color, state, (Level)level, (BlockPos)pos1, brightness);
            }
        }
        return colors;
    }

    private static BlockState getCorrectStateForFluidBlock(Level level, BlockState blockState, BlockPos blockPos) {
        FluidState fluidState = blockState.m_60819_();
        return !fluidState.m_76178_() && !blockState.m_60783_((BlockGetter)level, blockPos, Direction.UP) ? fluidState.m_76188_() : blockState;
    }

    public static boolean shouldRender(BlockState state, Level level, BlockPos pos) {
        if (state.m_284242_((BlockGetter)level, pos) == MapColor.f_283808_) {
            return false;
        }
        if (state.m_60819_().m_76178_()) {
            return state.m_60713_(Blocks.f_50125_) || !state.m_247087_();
        }
        return true;
    }

    public static int getTintShade(MapColor color, BlockState state, Level level, BlockPos pos, MapColor.Brightness brightness) {
        if (color == MapColor.f_283864_ || color == MapColor.f_283824_ || color == MapColor.f_283915_) {
            int tintColor = BiomeColors.m_108793_((BlockAndTintGetter)level, (BlockPos)pos);
            if (color == MapColor.f_283864_) {
                tintColor = BiomeColors.m_108811_((BlockAndTintGetter)level, (BlockPos)pos);
            }
            if (color == MapColor.f_283915_) {
                tintColor = BiomeColors.m_108804_((BlockAndTintGetter)level, (BlockPos)pos);
            }
            int intColor = ClaimMapTopologyAlgorithm.rgb2abgr(tintColor);
            if (color == MapColor.f_283864_) {
                intColor = ClaimMapTopologyAlgorithm.brighter(intColor);
            }
            return switch (brightness) {
                default -> throw new IncompatibleClassChangeError();
                case MapColor.Brightness.LOWEST -> intColor;
                case MapColor.Brightness.LOW -> ClaimMapTopologyAlgorithm.darker(intColor);
                case MapColor.Brightness.NORMAL -> ClaimMapTopologyAlgorithm.darker(ClaimMapTopologyAlgorithm.darker(intColor));
                case MapColor.Brightness.HIGH -> ClaimMapTopologyAlgorithm.darker(ClaimMapTopologyAlgorithm.darker(ClaimMapTopologyAlgorithm.darker(intColor)));
            };
        }
        if (state != null) {
            int tintColor = Minecraft.m_91087_().m_91298_().m_92577_(state, (BlockAndTintGetter)level, pos, 0);
            if (tintColor == -1) {
                return ClaimMapPalette.getColor(color.f_283805_, brightness);
            }
            int intColor = ClaimMapTopologyAlgorithm.rgb2abgr(Minecraft.m_91087_().m_91298_().m_92582_(state, level, pos));
            return switch (brightness) {
                default -> throw new IncompatibleClassChangeError();
                case MapColor.Brightness.LOWEST -> intColor;
                case MapColor.Brightness.LOW -> ClaimMapTopologyAlgorithm.darker(intColor);
                case MapColor.Brightness.NORMAL -> ClaimMapTopologyAlgorithm.darker(ClaimMapTopologyAlgorithm.darker(intColor));
                case MapColor.Brightness.HIGH -> ClaimMapTopologyAlgorithm.darker(ClaimMapTopologyAlgorithm.darker(ClaimMapTopologyAlgorithm.darker(intColor)));
            };
        }
        return 0;
    }

    public static int rgb2abgr(int rgb) {
        return rgb & 0xFF00FF00 | (rgb & 0xFF) << 16 | rgb >> 16 & 0xFF | 0xFF000000;
    }

    private static int darker(int abgr) {
        int red = abgr >> 16 & 0xFF;
        int green = abgr >> 8 & 0xFF;
        int blue = abgr & 0xFF;
        return Math.max((int)((float)red * 0.7f), 0) << 16 | Math.max((int)((float)green * 0.7f), 0) << 8 | Math.max((int)((float)blue * 0.7f), 0) | 0xFF000000;
    }

    private static int brighter(int abgr) {
        int red = abgr >> 16 & 0xFF;
        int green = abgr >> 8 & 0xFF;
        int blue = abgr & 0xFF;
        if (red == 0 && green == 0 && blue == 0) {
            return -16579837;
        }
        if (red > 0 && red < 3) {
            red = 3;
        }
        if (green > 0 && green < 3) {
            green = 3;
        }
        if (blue > 0 && blue < 3) {
            blue = 3;
        }
        return Math.min((int)((float)red * 1.1f), 255) << 16 | Math.min((int)((float)green * 1.1f), 255) << 8 | Math.min((int)((float)blue * 1.1f), 255) | 0xFF000000;
    }

    private static int findBlockWithAirAbove(ClientLevel level, BlockPos pos) {
        int offset = 0;
        int y = pos.m_123342_();
        BlockPos.MutableBlockPos mutablePos = pos.m_122032_();
        int attempts = 0;
        while (level.m_8055_((BlockPos)mutablePos).m_60795_() || !level.m_8055_(mutablePos.m_7494_()).m_60795_() && !level.m_8055_(mutablePos.m_7495_()).m_60795_()) {
            offset = offset <= 0 ? -offset + 1 : -offset;
            mutablePos.m_142448_(offset + y);
            if (++attempts <= 500) continue;
            return y;
        }
        return mutablePos.m_123342_();
    }
}

