/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.cadmus.client.claims;

import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.datafixers.util.Pair;
import com.mojang.math.Axis;
import com.teamresourceful.resourcefullib.client.CloseablePoseStack;
import com.teamresourceful.resourcefullib.client.screens.BaseCursorScreen;
import com.teamresourceful.resourcefullib.common.networking.base.Packet;
import earth.terrarium.cadmus.client.CadmusClient;
import earth.terrarium.cadmus.client.claims.ClaimMapRenderer;
import earth.terrarium.cadmus.client.claims.ClaimMapTopologyAlgorithm;
import earth.terrarium.cadmus.client.claims.ClaimTool;
import earth.terrarium.cadmus.common.claims.ClaimType;
import earth.terrarium.cadmus.common.constants.ConstantComponents;
import earth.terrarium.cadmus.common.network.NetworkHandler;
import earth.terrarium.cadmus.common.network.messages.ClientboundSendClaimedChunksPacket;
import earth.terrarium.cadmus.common.network.messages.ServerboundClearChunksPacket;
import earth.terrarium.cadmus.common.network.messages.ServerboundUpdateClaimedChunksPacket;
import earth.terrarium.cadmus.common.util.ModUtils;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.stream.Collectors;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.ImageButton;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.ChunkPos;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ClaimScreen
extends BaseCursorScreen {
    public static final int MAP_SIZE = 200;
    public static final ResourceLocation CONTAINER_BACKGROUND = new ResourceLocation("cadmus", "textures/gui/map.png");
    public static final ResourceLocation MAP_ICONS = new ResourceLocation("textures/map/map_icons.png");
    public static final int ORANGE = -681438;
    public static final int AQUA = -11141121;
    public static final int DARK_RED = -4382683;
    private final Map<ChunkPos, Pair<String, ClaimType>> startClaims = new HashMap<ChunkPos, Pair<String, ClaimType>>();
    private final Map<ChunkPos, ClaimType> teamClaims = new HashMap<ChunkPos, ClaimType>();
    private final Map<ChunkPos, Pair<String, ClaimType>> otherClaims = new HashMap<ChunkPos, Pair<String, ClaimType>>();
    private final Map<String, Component> teamDisplayNames = new HashMap<String, Component>();
    private final Component displayName;
    private final int viewDistance;
    private final int color;
    private final int maxClaims;
    private final int maxChunkLoaded;
    @Nullable
    private ClaimMapRenderer mapRenderer;
    private ClaimTool tool = ClaimTool.NONE;
    private int claimedCount;
    private int chunkLoadedCount;
    private Button clearButton;

    public ClaimScreen(Map<ChunkPos, Pair<String, ClaimType>> claims, @Nullable String id, ChatFormatting color, Component displayName, Map<String, Component> teamDisplayNames, int claimedCount, int chunkLoadedCount, int maxClaims, int maxChunkLoaded, int viewDistance) {
        super((Component)Component.m_237119_());
        this.viewDistance = viewDistance;
        this.refreshMap();
        this.color = color.m_126665_() == null ? -11141121 : color.m_126665_() | 0xFF000000;
        claims.forEach((pos, pair) -> {
            if (((String)pair.getFirst()).equals(id)) {
                this.teamClaims.put((ChunkPos)pos, (ClaimType)((Object)((Object)pair.getSecond())));
                this.startClaims.put((ChunkPos)pos, (Pair<String, ClaimType>)pair);
            } else {
                this.otherClaims.put((ChunkPos)pos, (Pair<String, ClaimType>)pair);
            }
        });
        this.claimedCount = claimedCount;
        this.chunkLoadedCount = chunkLoadedCount;
        this.displayName = displayName;
        this.teamDisplayNames.putAll(teamDisplayNames);
        this.maxClaims = maxClaims;
        this.maxChunkLoaded = maxChunkLoaded;
    }

    public static void createFromPacket(Player player, ClientboundSendClaimedChunksPacket message) {
        Minecraft.m_91087_().m_91152_((Screen)new ClaimScreen(message.claims(), message.id(), message.color(), message.displayName().map(Component::m_130674_).orElse(player.m_5446_()), message.teamDisplayNames(), message.claimedCount(), message.chunkLoadedCount(), message.maxClaims(), message.maxChunkLoaded(), message.viewDistance()));
    }

    public void clearDimension() {
        NetworkHandler.CHANNEL.sendToServer((Packet)new ServerboundClearChunksPacket(false));
    }

    public void clearAll() {
        NetworkHandler.CHANNEL.sendToServer((Packet)new ServerboundClearChunksPacket(true));
    }

    public void refreshMap() {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player == null) {
            return;
        }
        ChunkPos chunkPos = player.m_146902_();
        int scale = this.getScaledRenderDistance();
        int minX = chunkPos.m_45604_() - scale;
        int minZ = chunkPos.m_45605_() - scale;
        int maxX = chunkPos.m_45608_() + scale + 1;
        int maxZ = chunkPos.m_45609_() + scale + 1;
        if (scale / 8 > 12) {
            CompletableFuture.supplyAsync(() -> ClaimMapTopologyAlgorithm.setColors(minX, minZ, maxX, maxZ, player.f_108545_, (Player)player)).thenAcceptAsync(colors -> {
                this.mapRenderer = new ClaimMapRenderer((int[][])colors, scale * 2 + 16);
            }, (Executor)Minecraft.m_91087_());
        } else {
            int[][] colors2 = ClaimMapTopologyAlgorithm.setColors(minX, minZ, maxX, maxZ, player.f_108545_, (Player)player);
            this.mapRenderer = new ClaimMapRenderer(colors2, scale * 2 + 16);
        }
    }

    public int getScaledRenderDistance() {
        int scale = this.viewDistance * 8;
        scale -= scale % 16;
        return scale;
    }

    public void m_7379_() {
        super.m_7379_();
        Map<ChunkPos, ClaimType> addedChunks = this.teamClaims.entrySet().stream().filter(entry -> !this.startClaims.containsKey(entry.getKey()) || this.startClaims.get(entry.getKey()).getSecond() != entry.getValue()).collect(Collectors.toUnmodifiableMap(Map.Entry::getKey, Map.Entry::getValue));
        Map<ChunkPos, ClaimType> removedChunks = this.startClaims.entrySet().stream().filter(entry -> !this.teamClaims.containsKey(entry.getKey())).collect(Collectors.toUnmodifiableMap(Map.Entry::getKey, entry -> (ClaimType)((Object)((Object)((Pair)entry.getValue()).getSecond()))));
        if (addedChunks.isEmpty() && removedChunks.isEmpty()) {
            return;
        }
        NetworkHandler.CHANNEL.sendToServer((Packet)new ServerboundUpdateClaimedChunksPacket(addedChunks, removedChunks));
    }

    public boolean m_7043_() {
        return false;
    }

    protected void m_7856_() {
        super.m_7856_();
        int x = (this.f_96543_ - 216) / 2;
        int y = (this.f_96544_ - 237) / 2;
        this.clearButton = (Button)this.m_142416_((GuiEventListener)new ImageButton(x + 7, y + 6, 11, 11, 216, 0, 11, CONTAINER_BACKGROUND, button -> {
            if (Screen.m_96638_()) {
                this.clearAll();
            } else {
                this.clearDimension();
            }
            CadmusClient.openClaimMap();
        }));
        ((ImageButton)this.m_142416_((GuiEventListener)new ImageButton(x + 216 - 11 - 7, y + 6, 11, 11, 227, 0, 11, CONTAINER_BACKGROUND, button -> this.m_7379_()))).m_257544_(Tooltip.m_257550_((Component)ConstantComponents.CLOSE));
    }

    public void m_88315_(@NotNull GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        super.m_280273_(graphics);
        this.renderBackgroundTexture(graphics);
        if (this.mapRenderer == null) {
            graphics.m_280653_(this.f_96547_, ConstantComponents.LOADING, (int)((float)this.f_96543_ / 2.0f), (int)((float)this.f_96544_ / 2.0f), 0xFFFFFF);
        } else {
            LocalPlayer player = Minecraft.m_91087_().f_91074_;
            if (player == null) {
                return;
            }
            this.mapRenderer.render(graphics, this.f_96543_, this.f_96544_, 200);
            try (CloseablePoseStack pose = new CloseablePoseStack(graphics);){
                pose.m_252880_(0.0f, 0.0f, 2.0f);
                this.renderText(graphics, mouseX, mouseY);
                this.renderClaims(player, graphics, mouseX, mouseY);
                this.renderPlayerAvatar(player, graphics);
            }
        }
        this.clearButton.m_257544_(Tooltip.m_257550_((Component)(ClaimScreen.m_96638_() ? ConstantComponents.CLEAR_ALL_CLAIMED_CHUNKS : ConstantComponents.CLEAR_CLAIMED_CHUNKS)));
        super.m_88315_(graphics, mouseX, mouseY, partialTick);
    }

    private void renderBackgroundTexture(GuiGraphics graphics) {
        graphics.m_280509_((this.f_96543_ - 200) / 2, (this.f_96544_ - 200) / 2, (this.f_96543_ + 200) / 2, (this.f_96544_ + 200) / 2, -16777216);
        int left = (this.f_96543_ - 216) / 2;
        int top = (this.f_96544_ - 237) / 2 + 1;
        RenderSystem.enableBlend();
        graphics.m_280218_(CONTAINER_BACKGROUND, left, top, 0, 0, 216, 237);
        graphics.m_280614_(this.f_96547_, ConstantComponents.TITLE, (int)((float)(this.f_96543_ - this.f_96547_.m_92852_((FormattedText)ConstantComponents.TITLE)) / 2.0f), top + 7, 0x404040, false);
    }

    private void renderPlayerAvatar(LocalPlayer player, GuiGraphics graphics) {
        float left = (float)this.f_96543_ / 2.0f;
        float top = (float)this.f_96544_ / 2.0f;
        double playerX = player.m_20185_();
        double playerZ = player.m_20189_();
        double x = playerX % 16.0 + (double)(playerX >= 0.0 ? -8 : 8);
        double y = playerZ % 16.0 + (double)(playerZ >= 0.0 ? -8 : 8);
        float scale = 200.0f / ((float)this.getScaledRenderDistance() * 2.0f + 16.0f);
        x *= (double)scale;
        y *= (double)scale;
        try (CloseablePoseStack pose = new CloseablePoseStack(graphics);){
            pose.m_85837_((double)left + x, (double)top + y, 0.0);
            pose.m_252781_(Axis.f_252403_.m_252977_(player.m_146908_()));
            pose.m_252880_(-4.0f, -4.0f, 0.0f);
            graphics.m_280163_(MAP_ICONS, 0, 0, 40.0f, 0.0f, 8, 8, 128, 128);
        }
    }

    private void renderText(GuiGraphics graphics, int mouseX, int mouseY) {
        graphics.m_280056_(this.f_96547_, this.claimedCount + "/" + this.maxClaims, (int)((float)(this.f_96543_ + 218) / 2.0f - 198.0f), (int)((float)(this.f_96544_ - 246) / 2.0f + 228.0f), 0x404040, false);
        graphics.m_280056_(this.f_96547_, this.chunkLoadedCount + "/" + this.maxChunkLoaded, (int)((float)(this.f_96543_ + 218) / 2.0f - 119.0f), (int)((float)(this.f_96544_ - 246) / 2.0f + 228.0f), 0x404040, false);
        float left = (float)(this.f_96543_ - 200) / 2.0f;
        float top = (float)(this.f_96544_ - 200) / 2.0f;
        if ((float)(mouseX + 2) > left && (float)mouseX < left + 57.142857f + 15.0f && (float)mouseY > top + 200.0f && (float)mouseY < top + 200.0f + 13.0f) {
            this.m_257404_((Component)Component.m_237110_((String)"gui.cadmus.claim_map.claimed_chunks", (Object[])new Object[]{this.claimedCount, this.maxClaims}));
        } else if ((float)(mouseX + 2) > left + 75.0f && (float)mouseX < left + 57.142857f + 70.0f && (float)mouseY > top + 200.0f && (float)mouseY < top + 200.0f + 13.0f) {
            this.m_257404_((Component)Component.m_237110_((String)"gui.cadmus.claim_map.chunk_loaded_chunks", (Object[])new Object[]{this.chunkLoadedCount, this.maxChunkLoaded}));
        }
    }

    private void renderClaims(LocalPlayer player, GuiGraphics graphics, int mouseX, int mouseY) {
        float left = (float)(this.f_96543_ - 200) / 2.0f;
        float top = (float)(this.f_96544_ - 200) / 2.0f;
        float scale = (float)this.getScaledRenderDistance() * 2.0f + 16.0f;
        float chunkScale = scale / 16.0f;
        float pixelScale = 200.0f / scale;
        ChunkPos playerChunk = player.m_146902_();
        int i = 0;
        while ((float)i < chunkScale) {
            int j = 0;
            while ((float)j < chunkScale) {
                int color;
                boolean isHovering;
                float x = left + (float)(i * 16) * pixelScale;
                float y = top + (float)(j * 16) * pixelScale;
                float width = pixelScale * 16.0f;
                float height = pixelScale * 16.0f;
                int playerChunkX = Math.round((float)playerChunk.f_45578_ - chunkScale / 2.0f);
                int playerChunkZ = Math.round((float)playerChunk.f_45579_ - chunkScale / 2.0f);
                ChunkPos chunkPos = new ChunkPos(playerChunkX + i, playerChunkZ + j);
                ClaimType teamType = this.teamClaims.get(chunkPos);
                Pair<String, ClaimType> otherInfo = this.otherClaims.get(chunkPos);
                ClaimType type = otherInfo != null ? (ClaimType)((Object)otherInfo.getSecond()) : teamType;
                boolean bl = isHovering = (float)mouseX >= x && (float)mouseX < x + width && (float)mouseY >= y && (float)mouseY < y + height;
                if (isHovering) {
                    if (otherInfo == null) {
                        type = this.useTool(chunkPos, type);
                    }
                    this.drawTooltips(teamType, otherInfo);
                    color = Screen.m_96638_() ? -681438 : (this.tool == ClaimTool.ERASER || otherInfo != null ? -4382683 : this.color);
                } else {
                    int n = otherInfo != null ? (ModUtils.isAdmin((String)otherInfo.getFirst()) ? -43521 : -4382683) : (teamType != null ? (teamType == ClaimType.CHUNK_LOADED ? -681438 : this.color) : (color = 0xFFFFFF));
                }
                if (type != null || isHovering) {
                    boolean north = j == 0 || this.getClaimType(new ChunkPos(playerChunkX + i, playerChunkZ + j - 1)) != type;
                    boolean east = (float)i == chunkScale - 1.0f || this.getClaimType(new ChunkPos(playerChunkX + i + 1, playerChunkZ + j)) != type;
                    boolean south = (float)j == chunkScale - 1.0f || this.getClaimType(new ChunkPos(playerChunkX + i, playerChunkZ + j + 1)) != type;
                    boolean west = i == 0 || this.getClaimType(new ChunkPos(playerChunkX + i - 1, playerChunkZ + j)) != type;
                    boolean northEast = j == 0 || (float)i == chunkScale - 1.0f || this.getClaimType(new ChunkPos(playerChunkX + i + 1, playerChunkZ + j - 1)) != type;
                    boolean southEast = (float)j == chunkScale - 1.0f || (float)i == chunkScale - 1.0f || this.getClaimType(new ChunkPos(playerChunkX + i + 1, playerChunkZ + j + 1)) != type;
                    boolean southWest = (float)j == chunkScale - 1.0f || i == 0 || this.getClaimType(new ChunkPos(playerChunkX + i - 1, playerChunkZ + j + 1)) != type;
                    boolean northWest = j == 0 || i == 0 || this.getClaimType(new ChunkPos(playerChunkX + i - 1, playerChunkZ + j - 1)) != type;
                    this.drawCTMSquare(isHovering, graphics, x, y, width, height, color, north, east, south, west, northEast, southEast, southWest, northWest);
                }
                ++j;
            }
            ++i;
        }
    }

    private ClaimType useTool(ChunkPos pos, @Nullable ClaimType teamType) {
        ClaimType type;
        switch (this.tool) {
            case BRUSH: 
            case CHUNK_LOAD_ERASER: {
                ClaimType claimType = ClaimType.CLAIMED;
                break;
            }
            case CHUNK_LOAD_BRUSH: {
                ClaimType claimType = ClaimType.CHUNK_LOADED;
                break;
            }
            default: {
                ClaimType claimType = type = null;
            }
        }
        if (this.tool == ClaimTool.NONE) {
            return null;
        }
        if (type != null) {
            if (this.claimedCount < this.maxClaims && this.tool == ClaimTool.BRUSH && !this.teamClaims.containsKey(pos)) {
                ++this.claimedCount;
                this.teamClaims.put(pos, type);
            }
            if (!(this.chunkLoadedCount >= this.maxChunkLoaded || this.tool != ClaimTool.CHUNK_LOAD_BRUSH || this.teamClaims.containsKey(pos) && this.teamClaims.get(pos) == ClaimType.CHUNK_LOADED)) {
                if (!this.teamClaims.containsKey(pos)) {
                    ++this.claimedCount;
                }
                ++this.chunkLoadedCount;
                this.teamClaims.put(pos, type);
            }
            if (this.tool == ClaimTool.CHUNK_LOAD_ERASER && this.teamClaims.containsKey(pos)) {
                if (teamType == ClaimType.CHUNK_LOADED) {
                    --this.chunkLoadedCount;
                }
                this.teamClaims.put(pos, type);
            }
        } else if (this.tool == ClaimTool.ERASER && this.teamClaims.containsKey(pos)) {
            --this.claimedCount;
            if (teamType == ClaimType.CHUNK_LOADED) {
                --this.chunkLoadedCount;
            }
            this.teamClaims.remove(pos);
        }
        return type;
    }

    private void drawTooltips(ClaimType teamType, Pair<String, ClaimType> otherInfo) {
        if (otherInfo != null) {
            ImmutableList.Builder tooltips = ImmutableList.builder();
            Component otherTeamDisplayName = this.teamDisplayNames.get(otherInfo.getFirst());
            if (otherTeamDisplayName == null || otherTeamDisplayName.getString().isEmpty()) {
                return;
            }
            tooltips.add((Object)otherTeamDisplayName.m_6881_().m_130940_(ModUtils.isAdmin((String)otherInfo.getFirst()) ? ChatFormatting.LIGHT_PURPLE : ChatFormatting.DARK_RED).m_7532_());
            if (otherInfo.getSecond() == ClaimType.CHUNK_LOADED) {
                tooltips.add((Object)ConstantComponents.CHUNK_LOADED.m_7532_());
            }
            if (ModUtils.isAdmin((String)otherInfo.getFirst())) {
                tooltips.add((Object)ConstantComponents.ADMIN_CLAIM.m_7532_());
            }
            this.m_257959_((List)tooltips.build());
        } else if (teamType != null && this.tool == ClaimTool.NONE) {
            ImmutableList.Builder tooltips = ImmutableList.builder();
            tooltips.add((Object)this.displayName.m_6881_().m_130948_(this.displayName.m_7383_().m_178520_(this.color)).m_7532_());
            if (teamType == ClaimType.CHUNK_LOADED) {
                tooltips.add((Object)ConstantComponents.CHUNK_LOADED.m_7532_());
            }
            this.m_257959_((List)tooltips.build());
        }
    }

    private void drawCTMSquare(boolean isHovering, GuiGraphics graphics, float x, float y, float width, float height, int color, boolean north, boolean east, boolean south, boolean west, boolean northEast, boolean southEast, boolean southWest, boolean northWest) {
        int roundedX = Math.round(x);
        int roundedY = Math.round(y);
        int roundedWidth = Math.round(x + width);
        int roundedHeight = Math.round(y + height);
        if (north || isHovering) {
            graphics.m_280509_(roundedX, roundedY, roundedWidth, roundedY + 1, color);
        } else if (northEast) {
            graphics.m_280509_(roundedWidth - 1, roundedY, roundedWidth, roundedY + 1, color);
        }
        if (east || isHovering) {
            graphics.m_280509_(roundedWidth - 1, roundedY, roundedWidth, roundedHeight, color);
        } else if (southEast) {
            graphics.m_280509_(roundedWidth - 1, roundedHeight - 1, roundedWidth, roundedHeight, color);
        }
        if (south || isHovering) {
            graphics.m_280509_(roundedX, roundedHeight - 1, roundedWidth, roundedHeight, color);
        } else if (southWest) {
            graphics.m_280509_(roundedX, roundedHeight - 1, roundedX + 1, roundedHeight, color);
        }
        if (west || isHovering) {
            graphics.m_280509_(roundedX, roundedY, roundedX + 1, roundedHeight, color);
        } else if (northWest) {
            graphics.m_280509_(roundedX, roundedY, roundedX + 1, roundedY + 1, color);
        }
        graphics.m_280509_(roundedX, roundedY, roundedWidth, roundedHeight, color & 0x33FFFFFF);
    }

    @Nullable
    private ClaimType getClaimType(ChunkPos chunkPos) {
        ClaimType teamType = this.teamClaims.get(chunkPos);
        if (teamType != null) {
            return teamType;
        }
        Pair<String, ClaimType> otherInfo = this.otherClaims.get(chunkPos);
        if (otherInfo != null) {
            return (ClaimType)((Object)otherInfo.getSecond());
        }
        return null;
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        this.m_7522_(null);
        this.tool = button == 0 ? (Screen.m_96638_() ? ClaimTool.CHUNK_LOAD_BRUSH : ClaimTool.BRUSH) : (Screen.m_96638_() ? ClaimTool.CHUNK_LOAD_ERASER : ClaimTool.ERASER);
        return super.m_6375_(mouseX, mouseY, button);
    }

    public boolean m_6348_(double mouseX, double mouseY, int button) {
        this.tool = ClaimTool.NONE;
        return super.m_6348_(mouseX, mouseY, button);
    }
}

