/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.cadmus.common.claims;

import com.teamresourceful.resourcefullib.common.networking.base.Packet;
import earth.terrarium.cadmus.common.claims.ClaimHandler;
import earth.terrarium.cadmus.common.claims.ClaimType;
import earth.terrarium.cadmus.common.network.NetworkHandler;
import earth.terrarium.cadmus.common.network.messages.ClientboundUpdateListeningChunksPacket;
import earth.terrarium.cadmus.common.teams.TeamHelper;
import it.unimi.dsi.fastutil.objects.Object2BooleanMap;
import it.unimi.dsi.fastutil.objects.Object2BooleanOpenHashMap;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;

public final class ClaimListenHandler {
    private static final int MAX_CHUNKS_PER_PACKET = 500;
    private final Set<UUID> listeners = new HashSet<UUID>();
    private final ResourceKey<Level> dimension;

    public ClaimListenHandler(ResourceKey<Level> dimension) {
        this.dimension = dimension;
    }

    public void addListener(Player player) {
        this.listeners.add(player.m_20148_());
        MinecraftServer server = player.m_20194_();
        if (server == null) {
            return;
        }
        ServerLevel level = server.m_129880_(this.dimension);
        if (level == null) {
            return;
        }
        for (Map.Entry<String, Map<ChunkPos, ClaimType>> entry : ClaimHandler.getAllTeamClaims(level).entrySet()) {
            String id = entry.getKey();
            Object2BooleanOpenHashMap claims = new Object2BooleanOpenHashMap(entry.getValue().size());
            entry.getValue().keySet().forEach(arg_0 -> ClaimListenHandler.lambda$addListener$0((Object2BooleanMap)claims, arg_0));
            this.sendOrSplitPacket(List.of((ServerPlayer)player), level, id, (Object2BooleanMap<ChunkPos>)claims);
        }
    }

    public void removeListener(Player player) {
        this.listeners.remove(player.m_20148_());
    }

    public void addClaims(ServerLevel level, String id, Set<ChunkPos> claimData) {
        this.sendPacket(level, id, () -> {
            Object2BooleanOpenHashMap claims = new Object2BooleanOpenHashMap(claimData.size());
            claimData.forEach(arg_0 -> ClaimListenHandler.lambda$addClaims$1((Object2BooleanMap)claims, arg_0));
            return claims;
        });
    }

    public void removeClaims(ServerLevel level, String id, Set<ChunkPos> claimData) {
        this.sendPacket(level, id, () -> {
            Object2BooleanOpenHashMap claims = new Object2BooleanOpenHashMap(claimData.size());
            claimData.forEach(arg_0 -> ClaimListenHandler.lambda$removeClaims$3((Object2BooleanMap)claims, arg_0));
            return claims;
        });
    }

    private void sendPacket(ServerLevel level, String id, Supplier<Object2BooleanMap<ChunkPos>> getter) {
        if (this.listeners.isEmpty()) {
            return;
        }
        List<ServerPlayer> players = level.m_7654_().m_6846_().m_11314_().stream().filter(p -> this.listeners.contains(p.m_20148_())).toList();
        if (players.isEmpty()) {
            return;
        }
        Object2BooleanMap<ChunkPos> claims = getter.get();
        if (claims.isEmpty()) {
            return;
        }
        this.sendOrSplitPacket(players, level, id, claims);
    }

    private void sendClaims(List<ServerPlayer> players, Component displayName, int color, Object2BooleanMap<ChunkPos> claims) {
        ArrayList<Object2BooleanOpenHashMap> split = new ArrayList<Object2BooleanOpenHashMap>();
        Object2BooleanOpenHashMap current = new Object2BooleanOpenHashMap();
        int count = 0;
        for (Object2BooleanMap.Entry entry : claims.object2BooleanEntrySet()) {
            current.put((Object)((ChunkPos)entry.getKey()), entry.getBooleanValue());
            if (++count < 500) continue;
            split.add(current);
            current = new Object2BooleanOpenHashMap();
            count = 0;
        }
        if (!current.isEmpty()) {
            split.add(current);
        }
        for (Object2BooleanMap object2BooleanMap : split) {
            NetworkHandler.CHANNEL.sendToPlayers((Packet)new ClientboundUpdateListeningChunksPacket(this.dimension, displayName, color, (Map<ChunkPos, Boolean>)object2BooleanMap), players);
        }
    }

    private void sendOrSplitPacket(List<ServerPlayer> players, ServerLevel level, String id, Object2BooleanMap<ChunkPos> claims) {
        Component displayName = TeamHelper.getTeamName(id, level.m_7654_());
        ChatFormatting color = TeamHelper.getTeamColor(id, level.m_7654_());
        this.sendClaims(players, displayName, color.m_126665_() == null ? -1 : color.m_126665_(), claims);
    }

    private static /* synthetic */ void lambda$removeClaims$3(Object2BooleanMap claims, ChunkPos c) {
        claims.put((Object)c, false);
    }

    private static /* synthetic */ void lambda$addClaims$1(Object2BooleanMap claims, ChunkPos c) {
        claims.put((Object)c, true);
    }

    private static /* synthetic */ void lambda$addListener$0(Object2BooleanMap claims, ChunkPos c) {
        claims.put((Object)c, true);
    }
}

