/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.cadmus.common.claims.maxclaims;

import com.mojang.logging.LogUtils;
import earth.terrarium.cadmus.api.claims.maxclaims.MaxClaimProvider;
import java.util.UUID;
import net.luckperms.api.LuckPermsProvider;
import net.luckperms.api.cacheddata.CachedPermissionData;
import net.luckperms.api.model.user.User;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.player.Player;

public class CadmusMaxClaimProvider
implements MaxClaimProvider {
    @Override
    public void calculate(String id, MinecraftServer server) {
    }

    @Override
    public void removeTeam(String id, MinecraftServer server) {
    }

    @Override
    public int getMaxClaims(String id, MinecraftServer server, Player player) {
        return this.getMaxClaims(id, (ServerLevel)player.m_9236_(), player.m_20148_());
    }

    @Override
    public int getMaxClaims(String id, ServerLevel level, UUID playerUUID) {
        User user = LuckPermsProvider.get().getUserManager().getUser(playerUUID);
        if (user == null) {
            return 1;
        }
        int maxClaims = 1;
        CachedPermissionData permissionData = user.getCachedData().getPermissionData();
        for (String permission : permissionData.getPermissionMap().keySet()) {
            if (!permission.startsWith("cadmus.claims.")) continue;
            try {
                int value = Integer.parseInt(permission.substring("cadmus.claims.".length()));
                maxClaims = Math.max(maxClaims, value);
            }
            catch (NumberFormatException e) {
                LogUtils.getLogger().error("Invalid claims permission format: " + permission, (Throwable)e);
            }
        }
        return maxClaims;
    }

    @Override
    public int getMaxChunkLoaded(String id, MinecraftServer server, Player player) {
        return 0;
    }

    @Override
    public int getMaxChunkLoaded(String id, ServerLevel level, UUID player) {
        return 0;
    }
}

