/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.cadmus.common.commands.claims;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.datafixers.util.Pair;
import com.teamresourceful.resourcefullib.common.utils.CommonUtils;
import earth.terrarium.cadmus.common.claims.ClaimHandler;
import earth.terrarium.cadmus.common.claims.ClaimType;
import earth.terrarium.cadmus.common.commands.claims.CommandHelper;
import earth.terrarium.cadmus.common.constants.ConstantComponents;
import earth.terrarium.cadmus.common.teams.TeamHelper;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.coordinates.ColumnPosArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.Style;
import net.minecraft.server.level.ColumnPos;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.ChunkPos;

public class ClaimInfoCommand {
    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)Commands.m_82127_((String)"claim").then(((LiteralArgumentBuilder)Commands.m_82127_((String)"info").then(Commands.m_82129_((String)"pos", (ArgumentType)ColumnPosArgument.m_118989_()).executes(context -> {
            ServerPlayer player = ((CommandSourceStack)context.getSource()).m_81375_();
            ColumnPos pos = ColumnPosArgument.m_118992_((CommandContext)context, (String)"pos");
            CommandHelper.runAction(() -> ClaimInfoCommand.claimInfo(player, pos.m_143196_()));
            return 1;
        }))).executes(context -> {
            ServerPlayer player = ((CommandSourceStack)context.getSource()).m_81375_();
            CommandHelper.runAction(() -> ClaimInfoCommand.claimInfo(player, player.m_146902_()));
            return 1;
        })));
    }

    public static void claimInfo(ServerPlayer player, ChunkPos pos) {
        Pair<String, ClaimType> claimData = ClaimHandler.getClaim(player.m_284548_(), pos);
        Component status = null;
        if (claimData == null) {
            status = ConstantComponents.UNCLAIMED;
        } else {
            ChatFormatting color;
            Component displayName = TeamHelper.getTeamName((String)claimData.getFirst(), player.f_8924_);
            boolean isMember = TeamHelper.isMember((String)claimData.getFirst(), player.f_8924_, player.m_20148_());
            ChatFormatting chatFormatting = color = isMember ? TeamHelper.getTeamColor((String)claimData.getFirst(), player.f_8924_) : ChatFormatting.DARK_RED;
            if (displayName != null && color != null) {
                Component type = switch (((String)claimData.getFirst()).charAt(0)) {
                    case 't' -> ConstantComponents.TEAM;
                    case 'p' -> ConstantComponents.PLAYER;
                    case 'a' -> ConstantComponents.ADMIN;
                    default -> ConstantComponents.UNKNOWN;
                };
                status = switch ((ClaimType)((Object)claimData.getSecond())) {
                    default -> throw new IncompatibleClassChangeError();
                    case ClaimType.CLAIMED -> CommonUtils.serverTranslatable((String)"text.cadmus.info.claimed_by", (Object[])new Object[]{displayName.getString(), type.getString()});
                    case ClaimType.CHUNK_LOADED -> CommonUtils.serverTranslatable((String)"text.cadmus.info.chunk_loaded_by", (Object[])new Object[]{displayName.getString(), type.getString()});
                };
                status = status.m_6881_().m_130948_(Style.f_131099_.m_131140_(color).m_131144_(new HoverEvent(HoverEvent.Action.f_130831_, (Object)Component.m_237113_((String)((String)claimData.getFirst())).m_130940_(color))));
            }
        }
        Component location = CommonUtils.serverTranslatable((String)"text.cadmus.info.location", (Object[])new Object[]{pos.f_45578_, pos.f_45579_});
        if (status != null) {
            player.m_5661_(status, false);
        }
        player.m_5661_(location, false);
    }
}

