/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.cadmus.common.commands.claims.admin;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.teamresourceful.resourcefullib.common.utils.CommonUtils;
import earth.terrarium.cadmus.api.claims.admin.FlagApi;
import earth.terrarium.cadmus.api.claims.admin.flags.Flag;
import earth.terrarium.cadmus.common.claims.AdminClaimHandler;
import earth.terrarium.cadmus.common.commands.claims.ClaimException;
import earth.terrarium.cadmus.common.commands.claims.CommandHelper;
import earth.terrarium.cadmus.common.commands.claims.admin.AdminClaimCommands;
import java.util.Map;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.server.level.ServerPlayer;

public class AdminFlagCommands {
    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        LiteralArgumentBuilder command = (LiteralArgumentBuilder)Commands.m_82127_((String)"cadmus").requires(commandSourceStack -> commandSourceStack.m_6761_(2));
        FlagApi.API.getAll().forEach((id, flag) -> dispatcher.register((LiteralArgumentBuilder)command.then(Commands.m_82127_((String)"adminclaims").then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"flag").then(Commands.m_82127_((String)"set").then(Commands.m_82129_((String)"id", (ArgumentType)StringArgumentType.string()).suggests(AdminClaimCommands.ADMIN_CLAIM_SUGGESTION_PROVIDER).then(Commands.m_82127_((String)id).then(flag.createArgument("value").executes(context -> {
            ServerPlayer player = ((CommandSourceStack)context.getSource()).m_81375_();
            String adminClaim = StringArgumentType.getString((CommandContext)context, (String)"id");
            CommandHelper.runAction(() -> AdminFlagCommands.flag(player, adminClaim, id, flag.getFromArgument((CommandContext<CommandSourceStack>)context, "value")));
            return 1;
        })))))).then(Commands.m_82127_((String)"remove").then(Commands.m_82129_((String)"id", (ArgumentType)StringArgumentType.string()).suggests(AdminClaimCommands.ADMIN_CLAIM_SUGGESTION_PROVIDER).then(Commands.m_82127_((String)id).executes(context -> {
            ServerPlayer player = ((CommandSourceStack)context.getSource()).m_81375_();
            String adminClaim = StringArgumentType.getString((CommandContext)context, (String)"id");
            CommandHelper.runAction(() -> AdminFlagCommands.remove(player, adminClaim, id));
            return 1;
        }))))).then(Commands.m_82127_((String)"list").then(Commands.m_82129_((String)"id", (ArgumentType)StringArgumentType.string()).suggests(AdminClaimCommands.ADMIN_CLAIM_SUGGESTION_PROVIDER).executes(context -> {
            ServerPlayer player = ((CommandSourceStack)context.getSource()).m_81375_();
            String adminClaim = StringArgumentType.getString((CommandContext)context, (String)"id");
            CommandHelper.runAction(() -> AdminFlagCommands.list(player, adminClaim));
            return 1;
        })))))));
    }

    public static void flag(ServerPlayer player, String id, String flagName, Flag<?> flag) throws ClaimException {
        if (AdminClaimHandler.get(player.f_8924_, id) == null) {
            throw ClaimException.CLAIM_DOES_NOT_EXIST;
        }
        Object oldVal = AdminClaimHandler.getFlag(player.f_8924_, id, flagName);
        AdminClaimHandler.setFlag(player.f_8924_, id, flagName, flag);
        player.m_5661_(CommonUtils.serverTranslatable((String)"text.cadmus.admin.set_flag", (Object[])new Object[]{flagName, oldVal, flag.getValue()}), false);
    }

    public static void remove(ServerPlayer player, String id, String flagName) throws ClaimException {
        if (AdminClaimHandler.get(player.f_8924_, id) == null) {
            throw ClaimException.CLAIM_DOES_NOT_EXIST;
        }
        AdminClaimHandler.removeFlag(player.f_8924_, id, flagName);
        player.m_5661_(CommonUtils.serverTranslatable((String)"text.cadmus.admin.remove_flag", (Object[])new Object[]{flagName}), false);
    }

    public static void list(ServerPlayer player, String id) throws ClaimException {
        if (AdminClaimHandler.get(player.f_8924_, id) == null) {
            throw ClaimException.CLAIM_DOES_NOT_EXIST;
        }
        Map<String, Flag<?>> flags = AdminClaimHandler.getAllFlags(player.f_8924_, id);
        if (flags.isEmpty()) {
            throw ClaimException.CLAIM_HAS_NO_FLAGS;
        }
        flags.forEach((name, value) -> player.m_5661_(CommonUtils.serverTranslatable((String)"text.cadmus.admin.list", (Object[])new Object[]{name, value.getValue()}), false));
    }
}

