/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.cadmus.common.network.messages;

import com.mojang.datafixers.util.Pair;
import com.teamresourceful.bytecodecs.base.ByteCodec;
import com.teamresourceful.bytecodecs.base.ObjectEntryByteCodec;
import com.teamresourceful.bytecodecs.base.object.ObjectByteCodec;
import com.teamresourceful.resourcefullib.common.networking.base.CodecPacketHandler;
import com.teamresourceful.resourcefullib.common.networking.base.Packet;
import com.teamresourceful.resourcefullib.common.networking.base.PacketContext;
import com.teamresourceful.resourcefullib.common.networking.base.PacketHandler;
import earth.terrarium.cadmus.api.claims.maxclaims.MaxClaimProviderApi;
import earth.terrarium.cadmus.common.claims.ClaimHandler;
import earth.terrarium.cadmus.common.claims.ClaimType;
import earth.terrarium.cadmus.common.constants.ConstantComponents;
import earth.terrarium.cadmus.common.network.NetworkHandler;
import earth.terrarium.cadmus.common.network.messages.ClientboundSendClaimedChunksPacket;
import earth.terrarium.cadmus.common.teams.TeamHelper;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.Optionull;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.ChunkPos;

public record ServerboundRequestClaimedChunksPacket(int renderDistance) implements Packet<ServerboundRequestClaimedChunksPacket>
{
    public static final ResourceLocation ID = new ResourceLocation("cadmus", "request_claimed_chunks");
    public static final Handler HANDLER = new Handler();

    public ResourceLocation getID() {
        return ID;
    }

    public PacketHandler<ServerboundRequestClaimedChunksPacket> getHandler() {
        return HANDLER;
    }

    private static class Handler
    extends CodecPacketHandler<ServerboundRequestClaimedChunksPacket> {
        public Handler() {
            super(ObjectByteCodec.create((ObjectEntryByteCodec)ByteCodec.VAR_INT.fieldOf(ServerboundRequestClaimedChunksPacket::renderDistance), ServerboundRequestClaimedChunksPacket::new));
        }

        public PacketContext handle(ServerboundRequestClaimedChunksPacket message) {
            return (player, level) -> {
                ChunkPos start = player.m_146902_();
                int viewDistance = Math.min(((ServerLevel)level).m_7654_().m_6846_().m_11312_(), 32);
                int renderDistance = Math.min(message.renderDistance, viewDistance);
                String id = TeamHelper.getTeamId(player.m_20194_(), player.m_20148_());
                Map<String, Map<ChunkPos, ClaimType>> claimData = ClaimHandler.getAllTeamClaims((ServerLevel)level);
                HashMap<ChunkPos, Pair<String, ClaimType>> claims = new HashMap<ChunkPos, Pair<String, ClaimType>>();
                if (claimData != null) {
                    claimData.forEach((teamId, teamClaims) -> teamClaims.forEach((pos, type) -> {
                        ChunkPos chunkPos = new ChunkPos(start.f_45578_ - pos.f_45578_, start.f_45579_ - pos.f_45579_);
                        if (chunkPos.f_45578_ < renderDistance && chunkPos.f_45578_ > -renderDistance && chunkPos.f_45579_ < renderDistance && chunkPos.f_45579_ > -renderDistance) {
                            claims.put((ChunkPos)pos, (Pair<String, ClaimType>)Pair.of((Object)teamId, (Object)type));
                        }
                    }));
                }
                Optional<String> displayName = Optional.ofNullable((String)Optionull.m_269382_((Object)TeamHelper.getTeamName(id, player.m_20194_()), Component::getString));
                ChatFormatting color = TeamHelper.getTeamColor(id, player.m_20194_());
                Map teamDisplayNames = ClaimHandler.getAllTeamClaims((ServerLevel)level).keySet().stream().filter(t -> !t.equals(id)).collect(HashMap::new, (map, teamId) -> map.put(teamId, Optional.ofNullable(TeamHelper.getTeamName(teamId, player.m_20194_())).orElse(ConstantComponents.UNKNOWN)), HashMap::putAll);
                int claimedChunks = 0;
                int chunkLoadedCount = 0;
                for (ServerLevel serverLevel : level.m_7654_().m_129785_()) {
                    Map<ChunkPos, ClaimType> teamClaims2 = ClaimHandler.getTeamClaims(serverLevel, id);
                    if (teamClaims2 == null) continue;
                    for (Map.Entry<ChunkPos, ClaimType> data : teamClaims2.entrySet()) {
                        ++claimedChunks;
                        if (data.getValue() != ClaimType.CHUNK_LOADED) continue;
                        ++chunkLoadedCount;
                    }
                }
                int maxClaims = MaxClaimProviderApi.API.getSelected().getMaxClaims(id, player.m_20194_(), player);
                int maxChunkLoaded = MaxClaimProviderApi.API.getSelected().getMaxChunkLoaded(id, player.m_20194_(), player);
                NetworkHandler.CHANNEL.sendToPlayer((Packet)new ClientboundSendClaimedChunksPacket(claims, id, color, displayName, teamDisplayNames, claimedChunks, chunkLoadedCount, maxClaims, maxChunkLoaded, renderDistance), player);
            };
        }
    }
}

