/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.cadmus.common.teams;

import com.mojang.authlib.GameProfile;
import earth.terrarium.cadmus.api.teams.TeamProviderApi;
import earth.terrarium.cadmus.common.claims.AdminClaimHandler;
import earth.terrarium.cadmus.common.util.ModUtils;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.entity.player.Player;
import org.jetbrains.annotations.NotNull;

public class TeamHelper {
    private static final ChatFormatting[] COLORS = new ChatFormatting[]{ChatFormatting.DARK_GREEN, ChatFormatting.GREEN, ChatFormatting.AQUA, ChatFormatting.DARK_AQUA, ChatFormatting.DARK_BLUE, ChatFormatting.BLUE, ChatFormatting.LIGHT_PURPLE, ChatFormatting.DARK_PURPLE};

    public static Set<GameProfile> getTeamMembers(String id, MinecraftServer server) {
        if (ModUtils.isAdmin(id) || ModUtils.isPlayer(id)) {
            return new HashSet<GameProfile>();
        }
        return TeamProviderApi.API.getSelected().getTeamMembers(TeamHelper.teamId(id), server);
    }

    @NotNull
    public static Component getTeamName(String id, MinecraftServer server) {
        Component name;
        if (ModUtils.isAdmin(id)) {
            name = (Component)AdminClaimHandler.getFlag(server, TeamHelper.teamId(id), "display-name");
        } else if (ModUtils.isPlayer(id)) {
            Optional profile = ModUtils.getProfileCache(server).m_11002_(UUID.fromString(TeamHelper.teamId(id)));
            name = (Component)profile.map(p -> Component.m_237113_((String)p.getName())).orElse(Component.m_237113_((String)id));
        } else {
            name = TeamProviderApi.API.getSelected().getTeamName(TeamHelper.teamId(id), server);
        }
        return name == null ? Component.m_237113_((String)id) : name;
    }

    public static String getTeamId(MinecraftServer server, UUID player) {
        String id = TeamProviderApi.API.getSelected().getTeamId(server, player);
        return id == null ? "p:" + player.toString() : id;
    }

    public static String getTeamId(Player player) {
        return TeamHelper.getTeamId(player.m_20194_(), player.m_20148_());
    }

    public static boolean isMember(String id, MinecraftServer server, UUID player) {
        if (ModUtils.isAdmin(id)) {
            return true;
        }
        if (ModUtils.isPlayer(id)) {
            return TeamHelper.teamId(id).equals(player.toString());
        }
        return TeamProviderApi.API.getSelected().isMember(TeamHelper.teamId(id), server, player);
    }

    public static ChatFormatting getTeamColor(String id, MinecraftServer server) {
        if (ModUtils.isAdmin(id)) {
            return ChatFormatting.LIGHT_PURPLE;
        }
        if (ModUtils.isPlayer(id)) {
            int uniqueishId = id.isEmpty() ? 0 : (int)id.charAt(id.length() - 1);
            return COLORS[Math.abs(uniqueishId) % COLORS.length];
        }
        return TeamProviderApi.API.getSelected().getTeamColor(TeamHelper.teamId(id), server);
    }

    public static String teamId(String id) {
        return id.substring(2);
    }
}

