/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.cadmus.common.util;

import earth.terrarium.cadmus.common.claims.AdminClaimHandler;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.ChunkPos;

public class AdminUtils {
    public static void preventAdminChunkEntry(ServerPlayer player, ChunkPos lastChunkPos) {
        if (lastChunkPos == null) {
            return;
        }
        if (player.m_5833_() || AdminClaimHandler.getBooleanFlag(player.m_284548_(), player.m_146902_(), "allow-entry")) {
            return;
        }
        Component message = (Component)AdminClaimHandler.getFlag((ServerLevel)player.m_9236_(), player.m_146902_(), "entry-deny-message");
        if (!message.getString().isBlank()) {
            player.m_5661_((Component)message.m_6881_().m_130940_(ChatFormatting.RED), false);
        }
        BlockPos currentPos = player.m_20183_();
        BlockPos lastPos = lastChunkPos.m_151394_(player.m_146904_());
        BlockPos betweenPos = new BlockPos(currentPos.m_123341_() + (lastPos.m_123341_() - currentPos.m_123341_()) / 4, currentPos.m_123342_(), currentPos.m_123343_() + (lastPos.m_123343_() - currentPos.m_123343_()) / 4);
        player.m_6021_((double)betweenPos.m_123341_(), (double)betweenPos.m_123342_(), (double)betweenPos.m_123343_());
    }

    public static void preventAdminChunkExit(ServerPlayer player, ChunkPos lastChunkPos) {
        if (lastChunkPos == null) {
            return;
        }
        if (player.m_5833_() || AdminClaimHandler.getBooleanFlag(player.m_284548_(), lastChunkPos, "allow-exit")) {
            return;
        }
        Component message = (Component)AdminClaimHandler.getFlag((ServerLevel)player.m_9236_(), lastChunkPos, "exit-deny-message");
        if (!message.getString().isBlank() && ((Component)AdminClaimHandler.getFlag((ServerLevel)player.m_9236_(), player.m_146902_(), "exit-deny-message")).getString().isBlank()) {
            player.m_5661_((Component)message.m_6881_().m_130940_(ChatFormatting.RED), false);
        }
        BlockPos currentPos = player.m_20183_();
        BlockPos lastPos = lastChunkPos.m_151394_(player.m_146904_());
        BlockPos betweenPos = new BlockPos(currentPos.m_123341_() + (lastPos.m_123341_() - currentPos.m_123341_()) / 4, currentPos.m_123342_(), currentPos.m_123343_() + (lastPos.m_123343_() - currentPos.m_123343_()) / 4);
        player.m_6021_((double)betweenPos.m_123341_(), (double)betweenPos.m_123342_(), (double)betweenPos.m_123343_());
    }

    public static void checkAccess(ServerPlayer player, ChunkPos lastChunkPos) {
        AdminUtils.preventAdminChunkEntry(player, lastChunkPos);
        AdminUtils.preventAdminChunkExit(player, lastChunkPos);
    }
}

