/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.cadmus.common.util;

import dev.architectury.injectables.annotations.ExpectPlatform;
import earth.terrarium.cadmus.api.claims.maxclaims.MaxClaimProviderApi;
import earth.terrarium.cadmus.common.claims.CadmusDataHandler;
import earth.terrarium.cadmus.common.compat.prometheus.PrometheusIntegration;
import earth.terrarium.cadmus.common.util.forge.ModGameRulesImpl;
import earth.terrarium.cadmus.mixins.common.GameRulesAccessor;
import java.util.HashMap;
import java.util.function.BiConsumer;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;

public class ModGameRules {
    public static final GameRules.Key<GameRules.IntegerValue> RULE_MAX_CLAIMED_CHUNKS = ModGameRules.register("maxClaimedChunks", GameRules.Category.MISC, ModGameRules.createIntRule(1089));
    public static final GameRules.Key<GameRules.IntegerValue> RULE_MAX_CHUNK_LOADED = ModGameRules.register("maxChunkLoaded", GameRules.Category.MISC, ModGameRules.createIntRule(64));
    public static final GameRules.Key<GameRules.BooleanValue> RULE_DO_CLAIMED_BLOCK_BREAKING = ModGameRules.register("doClaimedBlockBreaking", GameRules.Category.MISC, ModGameRules.createBooleanRule(false));
    public static final GameRules.Key<GameRules.BooleanValue> RULE_DO_CLAIMED_BLOCK_PLACING = ModGameRules.register("doClaimedBlockPlacing", GameRules.Category.MISC, ModGameRules.createBooleanRule(false));
    public static final GameRules.Key<GameRules.BooleanValue> RULE_DO_CLAIMED_BLOCK_EXPLOSIONS = ModGameRules.register("doClaimedBlockExplosions", GameRules.Category.MISC, ModGameRules.createBooleanRule(false));
    public static final GameRules.Key<GameRules.BooleanValue> RULE_DO_CLAIMED_BLOCK_INTERACTIONS = ModGameRules.register("doClaimedBlockInteractions", GameRules.Category.MISC, ModGameRules.createBooleanRule(false));
    public static final GameRules.Key<GameRules.BooleanValue> RULE_DO_CLAIMED_ENTITY_INTERACTIONS = ModGameRules.register("doClaimedEntityInteractions", GameRules.Category.MISC, ModGameRules.createBooleanRule(false));
    public static final GameRules.Key<GameRules.BooleanValue> RULE_CLAIMED_DAMAGE_ENTITIES = ModGameRules.register("doClaimedDamageEntities", GameRules.Category.MISC, ModGameRules.createBooleanRule(false));
    public static final GameRules.Key<GameRules.BooleanValue> RULE_CLAIMED_MOB_GRIEFING = ModGameRules.register("claimedMobGriefing", GameRules.Category.MISC, ModGameRules.createBooleanRule(false));
    public static final GameRules.Key<GameRules.BooleanValue> RULE_CAN_PICKUP_CLAIMED_ITEMS = ModGameRules.register("canPickupClaimedItems", GameRules.Category.MISC, ModGameRules.createBooleanRule(false));
    public static final GameRules.Key<GameRules.BooleanValue> DO_COMBINED_CLAIM_LIMIT = ModGameRules.registerIfPrometheusInstalled("doCombinedClaimLimit", GameRules.Category.MISC, ModGameRules.createBooleanRule(false, (server, rule) -> CadmusDataHandler.getMaxTeamClaims(server).keySet().forEach(id -> MaxClaimProviderApi.API.getSelected().calculate((String)id, (MinecraftServer)server))));

    public static void init() {
    }

    public static <T extends GameRules.Value<T>> GameRules.Key<T> registerIfPrometheusInstalled(String name, GameRules.Category category, GameRules.Type<T> type) {
        return PrometheusIntegration.prometheusLoaded() ? ModGameRules.register(name, category, type) : null;
    }

    /*
     * WARNING - void declaration
     */
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static <T extends GameRules.Value<T>> GameRules.Key<T> register(String name, GameRules.Category category, GameRules.Type<T> type) {
        void var2_2;
        void var1_1;
        return ModGameRulesImpl.register(name, (GameRules.Category)var1_1, var2_2);
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static GameRules.Type<GameRules.IntegerValue> createIntRule(int defaultValue) {
        return ModGameRulesImpl.createIntRule(defaultValue);
    }

    public static GameRules.Type<GameRules.BooleanValue> createBooleanRule(boolean defaultValue) {
        return ModGameRules.createBooleanRule(defaultValue, (server, rule) -> {});
    }

    /*
     * WARNING - void declaration
     */
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static GameRules.Type<GameRules.BooleanValue> createBooleanRule(boolean defaultValue, BiConsumer<MinecraftServer, GameRules.BooleanValue> biConsumer) {
        void var1_1;
        return ModGameRulesImpl.createBooleanRule(defaultValue, (BiConsumer<MinecraftServer, GameRules.BooleanValue>)var1_1);
    }

    public static int getOrCreateIntGameRule(Level level, GameRules.Key<GameRules.IntegerValue> key) {
        GameRulesAccessor gameRules = (GameRulesAccessor)level.m_46469_();
        if (!gameRules.rules().containsKey(key)) {
            ModGameRules.copyAndAddRule(gameRules, key);
        }
        return ((GameRules.IntegerValue)gameRules.rules().get(key)).m_46288_();
    }

    public static boolean getOrCreateBooleanGameRule(Level level, GameRules.Key<GameRules.BooleanValue> key) {
        GameRulesAccessor gameRules = (GameRulesAccessor)level.m_46469_();
        if (!gameRules.rules().containsKey(key)) {
            ModGameRules.copyAndAddRule(gameRules, key);
        }
        return ((GameRules.BooleanValue)gameRules.rules().get(key)).m_46223_();
    }

    private static void copyAndAddRule(GameRulesAccessor gameRules, GameRules.Key<?> key) {
        HashMap rules = new HashMap(gameRules.rules());
        rules.put(key, GameRulesAccessor.getAllRules().get(key).m_46352_());
        gameRules.setRules(rules);
    }
}

