/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.cadmus.mixins.common;

import com.mojang.authlib.GameProfile;
import earth.terrarium.cadmus.common.claims.AdminClaimHandler;
import earth.terrarium.cadmus.common.util.LastMessageHolder;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ElytraItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ServerPlayer.class})
public abstract class ServerPlayerMixin
extends Player
implements LastMessageHolder {
    @Nullable
    private Component cadmus$lastMessage;

    @Shadow
    public abstract boolean m_6469_(DamageSource var1, float var2);

    public ServerPlayerMixin(Level level, BlockPos blockPos, float f, GameProfile gameProfile) {
        super(level, blockPos, f, gameProfile);
    }

    public boolean m_36319_() {
        ItemStack itemStack;
        if (!this.m_20096_() && !this.m_21255_() && !this.m_20069_() && !this.m_21023_(MobEffects.f_19620_) && (itemStack = this.m_6844_(EquipmentSlot.CHEST)).m_150930_(Items.f_42741_) && ElytraItem.m_41140_((ItemStack)itemStack)) {
            this.m_36320_();
            return true;
        }
        return false;
    }

    @Override
    public Component cadmus$getLastMessage() {
        return this.cadmus$lastMessage;
    }

    @Override
    public void cadmus$setLastMessage(Component message) {
        this.cadmus$lastMessage = message;
    }

    @Inject(method={"tick"}, at={@At(value="HEAD")})
    public void tick(CallbackInfo ci) {
        if (this.m_9236_().m_46467_() % 20L == 0L) {
            float healRate = ((Float)AdminClaimHandler.getFlag((ServerLevel)this.m_9236_(), this.m_146902_(), "heal-rate")).floatValue();
            if (healRate > 0.0f) {
                this.m_5634_(healRate);
            } else if (healRate < 0.0f) {
                this.m_6469_(this.m_269291_().m_269264_(), -healRate);
            }
            float feedRate = ((Float)AdminClaimHandler.getFlag((ServerLevel)this.m_9236_(), this.m_146902_(), "feed-rate")).floatValue();
            if (feedRate > 0.0f && feedRate > this.f_19796_.m_188501_()) {
                this.m_36324_().m_38707_((int)Math.ceil(feedRate), feedRate);
            }
        }
    }

    @Inject(method={"teleportTo(DDD)V"}, at={@At(value="HEAD")}, cancellable=true)
    private void cadmus$teleportTo(double x, double y, double z, CallbackInfo ci) {
        ServerPlayer player = (ServerPlayer)this;
        if (!AdminClaimHandler.getBooleanFlag(player.m_284548_(), new ChunkPos(BlockPos.m_274561_((double)x, (double)y, (double)z)), "allow-entry")) {
            Component message = (Component)AdminClaimHandler.getFlag(player.m_284548_(), player.m_146902_(), "entry-deny-message");
            if (!message.getString().isBlank()) {
                player.m_5661_((Component)message.m_6881_().m_130940_(ChatFormatting.RED), false);
            }
            ci.cancel();
        }
        if (!AdminClaimHandler.getBooleanFlag(player.m_284548_(), player.m_146902_(), "allow-exit")) {
            ci.cancel();
        }
    }

    @Inject(method={"restoreFrom"}, at={@At(value="HEAD", target="Lnet/minecraft/server/level/ServerPlayer;onUpdateAbilities()V")})
    private void cadmus$restoreFrom(ServerPlayer that, boolean keepEverything, CallbackInfo ci) {
        if (!keepEverything && AdminClaimHandler.getBooleanFlag(that.m_284548_(), that.m_146902_(), "keep-inventory")) {
            this.m_150109_().m_36006_(that.m_150109_());
            this.f_36078_ = that.f_36078_;
            this.f_36079_ = that.f_36079_;
            this.f_36080_ = that.f_36080_;
            this.m_36397_(that.m_36344_());
        }
    }
}

