/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.cadmus.mixins.common.chunkprotection;

import com.mojang.datafixers.util.Pair;
import earth.terrarium.cadmus.api.claims.ClaimApi;
import earth.terrarium.cadmus.api.claims.InteractionType;
import earth.terrarium.cadmus.common.claims.AdminClaimHandler;
import earth.terrarium.cadmus.common.claims.ClaimHandler;
import earth.terrarium.cadmus.common.claims.ClaimType;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={Entity.class})
public abstract class EntityMixin {
    @Inject(method={"mayInteract"}, at={@At(value="HEAD")}, cancellable=true)
    private void cadmus$mayInteract(Level level, BlockPos pos, CallbackInfoReturnable<Boolean> cir) {
        Entity entity = (Entity)this;
        if (entity instanceof Player) {
            Player player = (Player)entity;
            if (!ClaimApi.API.canInteractWithBlock(level, pos, InteractionType.WORLD, player)) {
                cir.setReturnValue((Object)false);
            }
        } else if (!ClaimApi.API.canEntityGrief(level, pos, entity)) {
            cir.setReturnValue((Object)false);
        }
    }

    @Inject(method={"canRide"}, at={@At(value="RETURN")}, cancellable=true)
    private void cadmus$canRide(Entity entity, CallbackInfoReturnable<Boolean> cir) {
        if (((Boolean)cir.getReturnValue()).booleanValue() && !entity.m_9236_().f_46443_) {
            Pair<String, ClaimType> id = ClaimHandler.getClaim((ServerLevel)entity.m_9236_(), entity.m_146902_());
            if (id == null) {
                return;
            }
            if (!AdminClaimHandler.getBooleanFlag(entity.m_9236_().m_7654_(), (String)id.getFirst(), "use-vehicles")) {
                cir.setReturnValue((Object)false);
            }
        }
    }
}

