/*
 * Decompiled with CFR 0.152.
 */
package customskinloader.loader;

import com.mojang.authlib.GameProfile;
import customskinloader.CustomSkinLoader;
import customskinloader.config.SkinSiteProfile;
import customskinloader.loader.ProfileLoader;
import customskinloader.plugin.ICustomSkinLoaderPlugin;
import customskinloader.profile.UserProfile;
import customskinloader.utils.HttpRequestUtil;
import customskinloader.utils.HttpUtil0;
import java.io.File;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;

public class JsonAPILoader
implements ICustomSkinLoaderPlugin,
ProfileLoader.IProfileLoader {
    private final IJsonAPI jsonAPI;

    public JsonAPILoader(IJsonAPI jsonAPI) {
        this.jsonAPI = jsonAPI;
    }

    @Override
    public ProfileLoader.IProfileLoader getProfileLoader() {
        return this;
    }

    @Override
    public List<ICustomSkinLoaderPlugin.IDefaultProfile> getDefaultProfiles() {
        return this.jsonAPI.getDefaultProfiles(this);
    }

    @Override
    public UserProfile loadProfile(SkinSiteProfile ssp, GameProfile gameProfile) throws Exception {
        String json;
        String username = gameProfile.getName();
        if (StringUtils.isEmpty((CharSequence)ssp.root)) {
            CustomSkinLoader.logger.info("Root not defined.");
            return null;
        }
        boolean local = HttpUtil0.isLocal(ssp.root);
        String jsonUrl = this.jsonAPI.toJsonUrl(ssp.root, username);
        if (jsonUrl == null) {
            CustomSkinLoader.logger.info("Profile url not found.");
            return null;
        }
        if (local) {
            File jsonFile = new File(CustomSkinLoader.DATA_DIR, jsonUrl);
            if (!jsonFile.exists()) {
                CustomSkinLoader.logger.info("Profile File not found.");
                return null;
            }
            json = IOUtils.toString((InputStream)Files.newInputStream(jsonFile.toPath(), new OpenOption[0]), (Charset)StandardCharsets.UTF_8);
        } else {
            try {
                HttpRequestUtil.HttpResponce responce = HttpRequestUtil.makeHttpRequest(new HttpRequestUtil.HttpRequest(jsonUrl).setCacheTime(90).setUserAgent(ssp.userAgent).setPayload(this.jsonAPI.getPayload(ssp, username)));
                json = responce.content;
            }
            catch (ProfileNotFoundException ignored) {
                CustomSkinLoader.logger.info("Profile not found.");
                return null;
            }
        }
        if (json == null || json.equals("")) {
            CustomSkinLoader.logger.info("Profile not found.");
            return null;
        }
        ErrorProfile profile = (ErrorProfile)CustomSkinLoader.GSON.fromJson(json, ErrorProfile.class);
        if (profile.errno != 0) {
            CustomSkinLoader.logger.info("Error " + profile.errno + ": " + profile.msg);
            return null;
        }
        UserProfile p = this.jsonAPI.toUserProfile(ssp.root, json, local);
        if (p == null || p.isEmpty()) {
            CustomSkinLoader.logger.info("Both skin and cape not found.");
            return null;
        }
        return p;
    }

    @Override
    public boolean compare(SkinSiteProfile ssp0, SkinSiteProfile ssp1) {
        return !StringUtils.isNoneEmpty((CharSequence[])new CharSequence[]{ssp0.root}) || ssp0.root.equalsIgnoreCase(ssp1.root);
    }

    @Override
    public String getName() {
        return this.jsonAPI.getName();
    }

    @Override
    public void init(SkinSiteProfile ssp) {
        File f;
        if (HttpUtil0.isLocal(ssp.root) && !(f = new File(ssp.root)).exists()) {
            f.mkdirs();
        }
    }

    public static class ProfileNotFoundException
    extends RuntimeException {
    }

    public static abstract class DefaultProfile
    implements ICustomSkinLoaderPlugin.IDefaultProfile {
        protected final JsonAPILoader loader;

        public DefaultProfile(JsonAPILoader loader) {
            this.loader = loader;
        }

        @Override
        public void updateSkinSiteProfile(SkinSiteProfile ssp) {
            ssp.type = this.loader.getName();
            ssp.root = this.getRoot();
        }

        public abstract String getRoot();
    }

    public static class ErrorProfile {
        public int errno;
        public String msg;
    }

    public static interface IJsonAPI {
        public List<ICustomSkinLoaderPlugin.IDefaultProfile> getDefaultProfiles(JsonAPILoader var1);

        public String toJsonUrl(String var1, String var2);

        default public String getPayload(SkinSiteProfile ssp) {
            return null;
        }

        default public String getPayload(SkinSiteProfile ssp, String username) {
            return this.getPayload(ssp);
        }

        public UserProfile toUserProfile(String var1, String var2, boolean var3);

        public String getName();
    }
}

