/*
 * Decompiled with CFR 0.152.
 */
package fuzs.easymagic.world.inventory;

import com.google.common.collect.Lists;
import fuzs.easymagic.EasyMagic;
import fuzs.easymagic.config.ServerConfig;
import fuzs.easymagic.init.ModRegistry;
import fuzs.easymagic.mixin.accessor.EnchantmentMenuAccessor;
import fuzs.easymagic.mixin.accessor.PlayerAccessor;
import fuzs.easymagic.network.S2CEnchantingDataMessage;
import fuzs.easymagic.util.ChiseledBookshelfHelper;
import fuzs.easymagic.util.PlayerExperienceHelper;
import fuzs.puzzleslib.api.core.v1.CommonAbstractions;
import fuzs.puzzleslib.api.network.v2.MessageV2;
import java.util.List;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.ContainerListener;
import net.minecraft.world.inventory.DataSlot;
import net.minecraft.world.inventory.EnchantmentMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.EnchantmentInstance;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.EnchantmentTableBlock;

public class ModEnchantmentMenu
extends EnchantmentMenu
implements ContainerListener {
    public static final int REROLL_CATALYST_SLOT = 38;
    private final Container enchantSlots;
    private final ContainerLevelAccess access;
    private final Player player;
    private final RandomSource random;
    private final DataSlot enchantmentSeed;

    public ModEnchantmentMenu(int id, Inventory playerInventory) {
        this(id, playerInventory, (Container)new SimpleContainer(((ServerConfig)EasyMagic.CONFIG.get(ServerConfig.class)).dedicatedRerollCatalyst ? 3 : 2), ContainerLevelAccess.f_39287_);
    }

    public ModEnchantmentMenu(int id, Inventory inventory, Container container, ContainerLevelAccess access) {
        super(id, inventory, access);
        this.enchantSlots = container;
        this.access = access;
        this.player = inventory.f_35978_;
        this.random = ((EnchantmentMenuAccessor)((Object)this)).getRandom();
        this.enchantmentSeed = ((EnchantmentMenuAccessor)((Object)this)).getEnchantmentSeed();
        ((EnchantmentMenuAccessor)((Object)this)).setEnchantSlots(container);
        boolean dedicatedRerollCatalyst = ((ServerConfig)EasyMagic.CONFIG.get(ServerConfig.class)).dedicatedRerollCatalyst;
        if (dedicatedRerollCatalyst) {
            this.m_38897_(new Slot(container, 2, 41, 47){

                public boolean m_5857_(ItemStack stack) {
                    return stack.m_204117_(ModRegistry.REROLL_CATALYSTS_ITEM_TAG);
                }
            });
        }
        this.f_38839_.set(0, (Object)((Slot)Util.m_137469_((Object)new Slot(container, 0, dedicatedRerollCatalyst ? 5 : 15, 47){

            public int m_6641_() {
                return 1;
            }
        }, slot -> {
            slot.f_40219_ = 0;
        })));
        this.f_38839_.set(1, (Object)((Slot)Util.m_137469_((Object)new Slot(container, 1, dedicatedRerollCatalyst ? 23 : 35, 47){

            public boolean m_5857_(ItemStack stack) {
                return stack.m_204117_(ModRegistry.ENCHANTING_CATALYSTS_ITEM_TAG);
            }
        }, slot -> {
            slot.f_40219_ = 1;
        })));
        this.m_38893_(this);
    }

    public MenuType<?> m_6772_() {
        return (MenuType)ModRegistry.ENCHANTMENT_MENU_TYPE.get();
    }

    public void m_6199_(Container inventory) {
        if (inventory == this.enchantSlots) {
            ItemStack enchantedItem = inventory.m_8020_(0);
            if (!enchantedItem.m_41619_() && enchantedItem.m_41792_()) {
                this.access.m_39292_((world, pos) -> {
                    int power = ((ServerConfig)EasyMagic.CONFIG.get(ServerConfig.class)).maxEnchantingPower == 0 ? 15 : this.getEnchantingPower((Level)world, (BlockPos)pos) * 15 / ((ServerConfig)EasyMagic.CONFIG.get(ServerConfig.class)).maxEnchantingPower;
                    this.random.m_188584_((long)this.enchantmentSeed.m_6501_());
                    this.updateLevels(enchantedItem, (Level)world, (BlockPos)pos, power);
                    this.createClues(enchantedItem);
                    this.m_38946_();
                    this.sendEnchantingData(enchantedItem);
                });
            } else {
                this.resetLevelsAndClues();
            }
        }
    }

    public void m_7934_(AbstractContainerMenu abstractContainerMenu, int i, ItemStack itemStack) {
        if (abstractContainerMenu == this) {
            this.access.m_39292_((Level2, BlockPos2) -> {
                if (i >= 0 && i < 2) {
                    this.m_6199_(this.enchantSlots);
                }
            });
        }
    }

    public void m_142153_(AbstractContainerMenu abstractContainerMenu, int i, int j) {
    }

    private void resetLevelsAndClues() {
        for (int i = 0; i < 3; ++i) {
            this.f_39446_[i] = 0;
            this.f_39447_[i] = -1;
            this.f_39448_[i] = -1;
        }
    }

    private void updateLevels(ItemStack itemstack, Level world, BlockPos pos, int power) {
        for (int i1 = 0; i1 < 3; ++i1) {
            this.f_39446_[i1] = EnchantmentHelper.m_220287_((RandomSource)this.random, (int)i1, (int)power, (ItemStack)itemstack);
            if (this.f_39446_[i1] >= i1 + 1) continue;
            this.f_39446_[i1] = 0;
        }
    }

    private void createClues(ItemStack itemstack) {
        for (int j1 = 0; j1 < 3; ++j1) {
            List<EnchantmentInstance> list;
            if (this.f_39446_[j1] <= 0 || (list = this.createEnchantmentInstance(itemstack, j1)) == null || list.isEmpty()) continue;
            EnchantmentInstance enchantmentdata = list.get(this.random.m_188503_(list.size()));
            this.f_39447_[j1] = BuiltInRegistries.f_256876_.m_7447_((Object)enchantmentdata.f_44947_);
            this.f_39448_[j1] = enchantmentdata.f_44948_;
        }
    }

    private List<EnchantmentInstance> createEnchantmentInstance(ItemStack enchantedItem, int enchantSlot) {
        return ((EnchantmentMenuAccessor)((Object)this)).callGetEnchantmentList(enchantedItem, enchantSlot, this.f_39446_[enchantSlot]);
    }

    private List<EnchantmentInstance> getEnchantmentHint(ItemStack enchantedItem, int enchantSlot, ServerConfig.EnchantmentHint enchantmentHint) {
        return switch (enchantmentHint) {
            default -> throw new IncompatibleClassChangeError();
            case ServerConfig.EnchantmentHint.NONE -> Lists.newArrayList();
            case ServerConfig.EnchantmentHint.SINGLE -> {
                List<EnchantmentInstance> enchantmentData = this.createEnchantmentInstance(enchantedItem, enchantSlot);
                if (enchantmentData.isEmpty()) {
                    yield Lists.newArrayList();
                }
                yield Lists.newArrayList((Object[])new EnchantmentInstance[]{enchantmentData.get(this.random.m_188503_(enchantmentData.size()))});
            }
            case ServerConfig.EnchantmentHint.ALL -> this.createEnchantmentInstance(enchantedItem, enchantSlot);
        };
    }

    private void sendEnchantingData(ItemStack enchantedItem) {
        ServerConfig.EnchantmentHint enchantmentHint = ((ServerConfig)EasyMagic.CONFIG.get(ServerConfig.class)).enchantmentHint;
        List<EnchantmentInstance> firstSlotData = this.getEnchantmentHint(enchantedItem, 0, enchantmentHint);
        List<EnchantmentInstance> secondSlotData = this.getEnchantmentHint(enchantedItem, 1, enchantmentHint);
        List<EnchantmentInstance> thirdSlotData = this.getEnchantmentHint(enchantedItem, 2, enchantmentHint);
        EasyMagic.NETWORK.sendTo((MessageV2)new S2CEnchantingDataMessage(this.f_38840_, firstSlotData, secondSlotData, thirdSlotData), (ServerPlayer)this.player);
    }

    private int getEnchantingPower(Level level, BlockPos pos) {
        float enchantingPower = 0.0f;
        int chiseledBookshelfBooks = 0;
        for (BlockPos offset : EnchantmentTableBlock.f_207902_) {
            if (!EnchantmentTableBlock.m_207909_((Level)level, (BlockPos)pos, (BlockPos)offset)) continue;
            enchantingPower += CommonAbstractions.INSTANCE.getEnchantPowerBonus(level.m_8055_(pos.m_121955_((Vec3i)offset)), level, pos.m_121955_((Vec3i)offset));
            chiseledBookshelfBooks += ChiseledBookshelfHelper.findValidBooks(level, pos, offset);
        }
        return (int)enchantingPower + chiseledBookshelfBooks / 3;
    }

    public boolean m_6366_(Player player, int data) {
        if (data == 4) {
            int catalystSlot;
            ItemStack itemstack;
            if (((ServerConfig)EasyMagic.CONFIG.get(ServerConfig.class)).rerollEnchantments && this.canUseReroll() && ((itemstack = this.enchantSlots.m_8020_(catalystSlot = ((ServerConfig)EasyMagic.CONFIG.get(ServerConfig.class)).dedicatedRerollCatalyst ? 2 : 1)).m_41613_() >= ((ServerConfig)EasyMagic.CONFIG.get(ServerConfig.class)).rerollCatalystCost && PlayerExperienceHelper.getTotalExperience(player) >= ((ServerConfig)EasyMagic.CONFIG.get(ServerConfig.class)).rerollExperiencePointsCost || player.m_150110_().f_35937_)) {
                this.access.m_39292_((level, pos) -> {
                    this.enchantmentSeed.m_6422_(this.player.m_217043_().m_188502_());
                    ((PlayerAccessor)this.player).setEnchantmentSeed(this.enchantmentSeed.m_6501_());
                    if (!player.m_150110_().f_35937_) {
                        if (((ServerConfig)EasyMagic.CONFIG.get(ServerConfig.class)).rerollCatalystCost > 0) {
                            itemstack.m_41774_(((ServerConfig)EasyMagic.CONFIG.get(ServerConfig.class)).rerollCatalystCost);
                            if (itemstack.m_41619_()) {
                                this.enchantSlots.m_6836_(catalystSlot, ItemStack.f_41583_);
                            }
                        }
                        if (((ServerConfig)EasyMagic.CONFIG.get(ServerConfig.class)).rerollExperiencePointsCost > 0) {
                            player.m_6756_(-((ServerConfig)EasyMagic.CONFIG.get(ServerConfig.class)).rerollExperiencePointsCost);
                        }
                    }
                    this.enchantSlots.m_6596_();
                    this.m_6199_(this.enchantSlots);
                });
                return true;
            }
            return false;
        }
        return super.m_6366_(player, data);
    }

    public boolean canUseReroll() {
        ItemStack itemToEnchant = this.enchantSlots.m_8020_(0);
        if (!itemToEnchant.m_41619_() && itemToEnchant.m_41792_()) {
            for (int cost : this.f_39446_) {
                if (cost <= 0) continue;
                return true;
            }
        }
        return false;
    }

    public boolean m_6875_(Player playerIn) {
        return this.enchantSlots.m_6542_(playerIn);
    }

    public void m_6877_(Player playerIn) {
        ItemStack itemstack;
        if (playerIn instanceof ServerPlayer && !(itemstack = this.m_142621_()).m_41619_()) {
            if (playerIn.m_6084_() && !((ServerPlayer)playerIn).m_9232_()) {
                playerIn.m_150109_().m_150079_(itemstack);
            } else {
                playerIn.m_36176_(itemstack, false);
            }
            this.m_142503_(ItemStack.f_41583_);
        }
    }

    public int getRerollCatalystCount() {
        if (((ServerConfig)EasyMagic.CONFIG.get(ServerConfig.class)).dedicatedRerollCatalyst) {
            return this.enchantSlots.m_8020_(2).m_41613_();
        }
        return this.m_39492_();
    }

    public ItemStack m_7648_(Player player, int index) {
        ItemStack itemStack = ItemStack.f_41583_;
        Slot slot = (Slot)this.f_38839_.get(index);
        if (slot != null && slot.m_6657_()) {
            ItemStack itemStack2 = slot.m_7993_();
            itemStack = itemStack2.m_41777_();
            boolean override = false;
            boolean dedicatedRerollCatalyst = ((ServerConfig)EasyMagic.CONFIG.get(ServerConfig.class)).dedicatedRerollCatalyst;
            if (dedicatedRerollCatalyst && index == 38) {
                override = true;
                if (!this.m_38903_(itemStack2, 2, 38, true)) {
                    return ItemStack.f_41583_;
                }
            } else if (index != 0 && index != 1) {
                if (itemStack2.m_204117_(ModRegistry.ENCHANTING_CATALYSTS_ITEM_TAG)) {
                    override = true;
                    if (!this.m_38903_(itemStack2, 1, 2, true)) {
                        return ItemStack.f_41583_;
                    }
                } else if (dedicatedRerollCatalyst && itemStack2.m_204117_(ModRegistry.REROLL_CATALYSTS_ITEM_TAG)) {
                    override = true;
                    if (!this.m_38903_(itemStack2, 38, 39, true)) {
                        return ItemStack.f_41583_;
                    }
                }
            }
            if (!override) {
                return super.m_7648_(player, index);
            }
            if (itemStack2.m_41619_()) {
                slot.m_5852_(ItemStack.f_41583_);
            } else {
                slot.m_6654_();
            }
            if (itemStack2.m_41613_() == itemStack.m_41613_()) {
                return ItemStack.f_41583_;
            }
            slot.m_142406_(player, itemStack2);
        }
        return itemStack;
    }
}

