/*
 * Decompiled with CFR 0.152.
 */
package gg.essential.elementa.components;

import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import gg.essential.elementa.UIComponent;
import gg.essential.elementa.state.BasicState;
import gg.essential.elementa.state.State;
import gg.essential.universal.UMatrixStack;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.TagParser;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0007\u0018\u0000 \u00182\u00020\u0001:\u0001\u0018B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u0013\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00030\u0006\u00a2\u0006\u0002\u0010\u0007J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J \u0010\u0010\u001a\u00020\r2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0012H\u0002J8\u0010\u0014\u001a\u00020\r2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0015\u001a\u00020\u00122\u0006\u0010\u0016\u001a\u00020\u00122\u0006\u0010\u0017\u001a\u00020\u0012H\u0002R$\u0010\u0002\u001a\u00020\u00032\u0006\u0010\b\u001a\u00020\u00038F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\u0004R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00030\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lgg/essential/elementa/components/ItemStackComponent;", "Lgg/essential/elementa/UIComponent;", "stack", "Lnet/minecraft/world/item/ItemStack;", "(Lnet/minecraft/world/item/ItemStack;)V", "stackState", "Lgg/essential/elementa/state/State;", "(Lgg/essential/elementa/state/State;)V", "value", "getStack", "()Lnet/minecraft/world/item/ItemStack;", "setStack", "draw", "", "matrixStack", "Lgg/essential/universal/UMatrixStack;", "renderItemStack", "x", "", "y", "renderStack", "scaleX", "scaleY", "scaleZ", "Companion", "MSCore"})
public final class ItemStackComponent
extends UIComponent {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final State<ItemStack> stackState;

    public ItemStackComponent(@NotNull State<ItemStack> stackState) {
        Intrinsics.checkNotNullParameter(stackState, (String)"stackState");
        this.stackState = stackState;
    }

    public ItemStackComponent(@NotNull ItemStack stack) {
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        this((State<ItemStack>)new BasicState<ItemStack>(stack));
    }

    @NotNull
    public final ItemStack getStack() {
        return this.stackState.get();
    }

    public final void setStack(@NotNull ItemStack value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        this.stackState.set(value);
    }

    @Override
    public void draw(@NotNull UMatrixStack matrixStack) {
        Intrinsics.checkNotNullParameter((Object)matrixStack, (String)"matrixStack");
        this.beforeDrawCompat(matrixStack);
        this.renderItemStack(this.getStack(), this.getLeft(), this.getTop());
        super.draw(matrixStack);
    }

    private final void renderItemStack(ItemStack stack, float x, float y) {
        float scaleX = this.getWidth() / 16.0f;
        float scaleY = this.getHeight() / 16.0f;
        this.renderStack(stack, x, y, scaleX, scaleY, scaleX);
    }

    private final void renderStack(ItemStack stack, float x, float y, float scaleX, float scaleY, float scaleZ) {
        boolean notUsesBlockLight;
        Minecraft mc = Minecraft.m_91087_();
        ItemRenderer renderItem = mc.m_91291_();
        BakedModel model = renderItem.m_174264_(stack, null, (LivingEntity)Minecraft.m_91087_().f_91074_, 0);
        double centerX = (double)((float)16 * scaleX) / 2.0;
        double centerY = (double)((float)16 * scaleY) / 2.0;
        mc.f_90987_.m_118506_(InventoryMenu.f_39692_).m_117960_(false, false);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)InventoryMenu.f_39692_);
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        PoseStack poseStack = RenderSystem.getModelViewStack();
        poseStack.m_85836_();
        poseStack.m_85837_((double)x + centerX, (double)y + centerY, 100.0);
        poseStack.m_85841_(16.0f, -16.0f, 16.0f);
        poseStack.m_85841_(scaleX, scaleY, scaleZ);
        RenderSystem.applyModelViewMatrix();
        MultiBufferSource.BufferSource rtb = Minecraft.m_91087_().m_91269_().m_110104_();
        boolean bl = notUsesBlockLight = !model.m_7547_();
        if (notUsesBlockLight) {
            Lighting.m_84930_();
        }
        renderItem.m_115143_(stack, ItemDisplayContext.GUI, false, new PoseStack(), (MultiBufferSource)rtb, 0xF000F0, OverlayTexture.f_118083_, model);
        rtb.m_109911_();
        if (notUsesBlockLight) {
            Lighting.m_84931_();
        }
        poseStack.m_85849_();
        RenderSystem.applyModelViewMatrix();
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final ItemStackComponent of(@NotNull String uid, int count, int meta, @NotNull String nbt) {
        return Companion.of(uid, count, meta, nbt);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final ItemStackComponent of(@NotNull String uid, int count, int meta) {
        return Companion.of(uid, count, meta);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final ItemStackComponent of(@NotNull String uid, int count) {
        return Companion.of(uid, count);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final ItemStackComponent of(@NotNull String uid) {
        return Companion.of(uid);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J(\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u0005H\u0002J.\u0010\u0011\u001a\u00020\u00122\u0006\u0010\f\u001a\u00020\u00052\b\b\u0002\u0010\r\u001a\u00020\u000e2\b\b\u0002\u0010\u000f\u001a\u00020\u000e2\b\b\u0002\u0010\u0010\u001a\u00020\u0005H\u0007J,\u0010\u0013\u001a\u00020\u000b*\u0004\u0018\u00010\u00042\b\b\u0002\u0010\r\u001a\u00020\u000e2\b\b\u0002\u0010\u0014\u001a\u00020\u000e2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0015H\u0002R\u001a\u0010\u0003\u001a\u0004\u0018\u00010\u0004*\u00020\u00058BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u001a\u0010\b\u001a\u0004\u0018\u00010\u0004*\u00020\u00058BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\u0007\u00a8\u0006\u0016"}, d2={"Lgg/essential/elementa/components/ItemStackComponent$Companion;", "", "()V", "asBlock", "Lnet/minecraft/world/level/ItemLike;", "", "getAsBlock", "(Ljava/lang/String;)Lnet/minecraft/world/level/ItemLike;", "asItem", "getAsItem", "findItemStack", "Lnet/minecraft/world/item/ItemStack;", "uid", "count", "", "meta", "nbt", "of", "Lgg/essential/elementa/components/ItemStackComponent;", "asStack", "damage", "Lnet/minecraft/nbt/CompoundTag;", "MSCore"})
    public static final class Companion {
        private Companion() {
        }

        private final ItemLike getAsItem(String $this$asItem) {
            return (ItemLike)ForgeRegistries.ITEMS.getValue(new ResourceLocation($this$asItem));
        }

        private final ItemLike getAsBlock(String $this$asBlock) {
            return (ItemLike)ForgeRegistries.BLOCKS.getValue(new ResourceLocation($this$asBlock));
        }

        private final ItemStack findItemStack(String uid, int count, int meta, String nbt) {
            try {
                ItemLike itemLike;
                CompoundTag tag = ((CharSequence)nbt).length() > 0 ? TagParser.m_129359_((String)nbt) : null;
                ItemLike itemLike2 = this.getAsItem(uid);
                if (itemLike2 == null) {
                    itemLike2 = itemLike = this.getAsBlock(uid);
                }
                if (itemLike2 == null || (itemLike = this.asStack(itemLike, count, meta, tag)) == null) {
                    ItemStack itemStack = ItemStack.f_41583_;
                    itemLike = itemStack;
                    Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"EMPTY");
                }
                return itemLike;
            }
            catch (Throwable e) {
                ItemStack itemStack = ItemStack.f_41583_;
                Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"EMPTY");
                return itemStack;
            }
        }

        private final ItemStack asStack(ItemLike $this$asStack, int count, int damage, CompoundTag nbt) {
            ItemStack itemStack;
            ItemLike itemLike = $this$asStack;
            if (itemLike != null) {
                ItemStack itemStack2;
                ItemLike $this$asStack_u24lambda_u241 = itemLike;
                boolean bl = false;
                ItemStack $this$asStack_u24lambda_u241_u24lambda_u240 = itemStack2 = new ItemStack($this$asStack_u24lambda_u241, count);
                boolean bl2 = false;
                $this$asStack_u24lambda_u241_u24lambda_u240.m_41721_(damage);
                $this$asStack_u24lambda_u241_u24lambda_u240.m_41751_(nbt);
                itemStack = itemStack2;
            } else {
                ItemStack itemStack3 = ItemStack.f_41583_;
                itemStack = itemStack3;
                Intrinsics.checkNotNullExpressionValue((Object)itemStack3, (String)"EMPTY");
            }
            return itemStack;
        }

        static /* synthetic */ ItemStack asStack$default(Companion companion, ItemLike itemLike, int n, int n2, CompoundTag compoundTag, int n3, Object object) {
            if ((n3 & 1) != 0) {
                n = 1;
            }
            if ((n3 & 2) != 0) {
                n2 = 0;
            }
            return companion.asStack(itemLike, n, n2, compoundTag);
        }

        @JvmStatic
        @JvmOverloads
        @NotNull
        public final ItemStackComponent of(@NotNull String uid, int count, int meta, @NotNull String nbt) {
            Intrinsics.checkNotNullParameter((Object)uid, (String)"uid");
            Intrinsics.checkNotNullParameter((Object)nbt, (String)"nbt");
            return new ItemStackComponent(this.findItemStack(uid, count, meta, nbt));
        }

        public static /* synthetic */ ItemStackComponent of$default(Companion companion, String string, int n, int n2, String string2, int n3, Object object) {
            if ((n3 & 2) != 0) {
                n = 1;
            }
            if ((n3 & 4) != 0) {
                n2 = 0;
            }
            if ((n3 & 8) != 0) {
                string2 = "";
            }
            return companion.of(string, n, n2, string2);
        }

        @JvmStatic
        @JvmOverloads
        @NotNull
        public final ItemStackComponent of(@NotNull String uid, int count, int meta) {
            Intrinsics.checkNotNullParameter((Object)uid, (String)"uid");
            return gg.essential.elementa.components.ItemStackComponent$Companion.of$default(this, uid, count, meta, null, 8, null);
        }

        @JvmStatic
        @JvmOverloads
        @NotNull
        public final ItemStackComponent of(@NotNull String uid, int count) {
            Intrinsics.checkNotNullParameter((Object)uid, (String)"uid");
            return gg.essential.elementa.components.ItemStackComponent$Companion.of$default(this, uid, count, 0, null, 12, null);
        }

        @JvmStatic
        @JvmOverloads
        @NotNull
        public final ItemStackComponent of(@NotNull String uid) {
            Intrinsics.checkNotNullParameter((Object)uid, (String)"uid");
            return gg.essential.elementa.components.ItemStackComponent$Companion.of$default(this, uid, 0, 0, null, 14, null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

